/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Misc;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
abstract class BT_Base {
    static final boolean ALLOW_TRACING = false;
    static final boolean CHECK_JIKESBT = false;
    static final boolean CHECK_INPUT = false;
    protected static final boolean CHECK_USER = false;
    static final boolean CHECK_USER_THOROUGHLY = false;
    static final boolean CHECK_JIKESBT_THOROUGHLY = false;
    static final boolean FAIL_NORMALLY = true;
    private static final String endl_ = System.getProperties().getProperty("line.separator");
    private static final BT_MonitorStream stackDepthSt_ = new BT_MonitorStream();
    private static boolean notedUse_ = false;

    BT_Base() {
    }

    public static String endl() {
        return endl_;
    }

    private static int threadStackDepth() {
        stackDepthSt_.reset();
        new Throwable().printStackTrace(new PrintStream(stackDepthSt_));
        return stackDepthSt_.getEolCount();
    }

    private static String traceLinePrefix() {
        int depth = BT_Base.threadStackDepth();
        String dS = "   " + depth;
        return String.valueOf(dS.substring(dS.length() - 3)) + "  .  :   .  .  :  .  .  |  .  .  :  .  .  :  .  .  :".substring(0, depth % 25);
    }

    static final void fatal(String message, Exception ex) {
        new Exception("fatal JikesBT Error: " + message + " " + ex).printStackTrace();
    }

    static final void fatal(String message) {
        new Exception("fatal JikesBT Error: " + message).printStackTrace();
    }

    private static void noteUseIf(String caller) {
        if (!notedUse_) {
            notedUse_ = true;
        }
    }

    protected static final void assert(String message) {
        BT_Base.noteUseIf("BT_Base.assert");
        BT_Base.fatal("Assertion failure: " + message);
    }

    protected static final void expect(String message) {
        BT_Base.noteUseIf("BT_Base.expect");
    }

    static PrintStream traceStream() {
        BT_Base.noteUseIf("BT_Base.traceStream()");
        return new PrintStream(new NullOutputStream());
    }

    static void traceln(String text) {
        BT_Base.noteUseIf("BT_Base.trace");
        BT_Base.traceStream().println("  t " + BT_Base.traceLinePrefix() + text);
    }

    static void queryJikesBTReadyToShip() {
        BT_Misc._queryJikesBTReadyToShip_want("BT_Base.ALLOW_TRACING", false, false);
        BT_Misc._queryJikesBTReadyToShip_want("BT_Base.CHECK_JIKESBT", false, true);
        BT_Misc._queryJikesBTReadyToShip_want("BT_Base.CHECK_JIKESBT_THOROUGHLY", false, false);
        BT_Misc._queryJikesBTReadyToShip_want("BT_Base.CHECK_USER", false, true);
        BT_Misc._queryJikesBTReadyToShip_want("BT_Base.CHECK_USER_THOROUGHLY", false, false);
        BT_Misc._queryJikesBTReadyToShip_want("BT_Base.FAIL_NORMALLY", true, true);
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void emptyBuffer() throws IOException {
        }
    }

    public static class BT_MonitorStream
    extends OutputStream {
        private int eolCount_ = 0;

        public void write(int b) {
            if (b == 10) {
                ++this.eolCount_;
            }
        }

        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) {
            int to = off + len;
            int i = off;
            while (i != to) {
                if (b[i] == 10) {
                    ++this.eolCount_;
                }
                ++i;
            }
        }

        public void flush() {
        }

        public void close() {
        }

        public void reset() {
            this.eolCount_ = 0;
        }

        public int getEolCount() {
            return this.eolCount_;
        }
    }
}

