/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_ArrayEnumerator;
import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class BT_AttributeVector
implements Cloneable,
Serializable {
    protected int elementCount = 0;
    protected BT_Attribute[] elementData;
    protected int capacityIncrement;
    private static final BT_Attribute[] emptyData = new BT_Attribute[0];
    private static final int DEFAULT_SIZE = 0;

    public BT_AttributeVector() {
        this(0, 0);
    }

    public BT_AttributeVector(int capacity) {
        this(capacity, 0);
    }

    public BT_AttributeVector(int capacity, int capacityIncrement) {
        this.elementData = capacity == 0 ? emptyData : new BT_Attribute[capacity];
        this.capacityIncrement = capacityIncrement;
    }

    public void addElement(BT_Attribute object) {
        this.insertElementAt(object, this.elementCount);
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        try {
            BT_AttributeVector vector = (BT_AttributeVector)super.clone();
            int length = this.elementData.length;
            vector.elementData = new BT_Attribute[length];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, length);
            return vector;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean contains(BT_Attribute object) {
        return this.indexOf(object, 0) != -1;
    }

    public void copyInto(BT_Attribute[] elements) {
        System.arraycopy(this.elementData, 0, elements, 0, this.elementCount);
    }

    public BT_Attribute elementAt(int location) {
        if (location < this.elementCount) {
            return this.elementData[location];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Enumeration elements() {
        return new BT_ArrayEnumerator(this.elementData, this.elementCount);
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            this.grow(minimumCapacity);
        }
    }

    public BT_Attribute firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    private void grow(int newCapacity) {
        BT_Attribute[] newData = new BT_Attribute[newCapacity];
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    public int indexOf(BT_Attribute object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(BT_Attribute object, int location) {
        int i = location;
        while (i < this.elementCount) {
            BT_Attribute element = this.elementData[i];
            if (element == object) {
                return i;
            }
            if (element != null && element.equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(BT_Attribute object, int location) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                int newCapacity = (this.capacityIncrement == 0 ? this.elementCount : this.capacityIncrement) + this.elementCount;
                if (newCapacity == 0) {
                    ++newCapacity;
                }
                this.grow(newCapacity);
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy(this.elementData, location, this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public BT_Attribute lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public int lastIndexOf(BT_Attribute object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(BT_Attribute object, int location) {
        if (location < this.elementCount) {
            int i = location;
            while (i >= 0) {
                BT_Attribute element = this.elementData[i];
                if (element == object) {
                    return i;
                }
                if (element != null && element.equals(object)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public boolean removeElement(BT_Attribute object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public void removeElementAt(int location) {
        if (location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy(this.elementData, location + 1, this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setElementAt(BT_Attribute object, int location) {
        if (location < this.elementCount) {
            this.elementData[location] = object;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setSize(int length) {
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            int i = length;
            while (i < this.elementCount) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.elementCount = length;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        int i = 0;
        while (i < length) {
            buffer.append(this.elementData[i]);
            buffer.append(',');
            ++i;
        }
        buffer.append(this.elementData[length]);
        buffer.append(']');
        return buffer.toString();
    }

    public void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }

    public BT_Attribute getAttribute(String name) {
        int n = 0;
        while (n < this.size()) {
            if (this.elementData[n].getName().equals(name)) {
                return this.elementData[n];
            }
            ++n;
        }
        return null;
    }

    public BT_Attribute removeAttribute(String name) {
        int n = 0;
        while (n < this.size()) {
            if (this.elementData[n].getName().equals(name)) {
                BT_Attribute att = this.elementData[n];
                this.removeElementAt(n);
                return att;
            }
            ++n;
        }
        return null;
    }

    public void print(PrintStream ps, String prefix) {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i].print(ps, prefix);
            ++i;
        }
    }

    static BT_AttributeVector read(DataInputStream di, BT_ConstantPool pool, Object container) throws BT_ClassFileException, IOException {
        BT_AttributeVector v = null;
        int count = di.readUnsignedShort();
        v = new BT_AttributeVector(count);
        int i = 0;
        while (i < count) {
            BT_Attribute at = BT_Attribute.read(di, pool, container);
            if (at != null) {
                String atName = at.getName();
                if (at.singletonRequired() && v.getAttribute(atName) != null) {
                    throw new BT_ClassFileException("duplicate " + atName + " attribute");
                }
                v.addElement(at);
            }
            ++i;
        }
        return v;
    }

    void dereference() {
        int i = 0;
        while (i < this.size()) {
            this.elementAt(i).dereference();
            ++i;
        }
    }

    void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
        int i = 0;
        while (i < this.size()) {
            this.elementAt(i).changeReferencesFromTo(oldIns, newIns);
            ++i;
        }
    }

    public void resolve(BT_ConstantPool pool) {
        int i = 0;
        while (i < this.size()) {
            this.elementAt(i).resolve(pool);
            ++i;
        }
    }

    int writtenLength() {
        int nb = 2;
        int i = 0;
        while (i < this.size()) {
            nb += this.elementAt(i).writtenLength();
            ++i;
        }
        return nb;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeShort(this.size());
        int i = 0;
        while (i < this.size()) {
            this.elementAt(i).write(dos, pool);
            ++i;
        }
    }
}

