/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Field;
import com.ibm.jikesbt.BT_Method;

public abstract class BT_AnyConstantValue {
    public abstract int findInPool(BT_ConstantPool var1);

    static BT_AnyConstantValue create(BT_ConstantPool pool, int index, BT_Class fieldType) throws BT_ClassFileException {
        switch (pool.getEntryTypeAt(index)) {
            case 6: {
                BT_AnyConstantValue.verifyValueType(fieldType == pool.getRepository().getDouble(), index);
                return new DoubleV(pool.getDoubleAt(index));
            }
            case 4: {
                BT_AnyConstantValue.verifyValueType(fieldType == pool.getRepository().getFloat(), index);
                return new FloatV(pool.getFloatAt(index));
            }
            case 3: {
                BT_AnyConstantValue.verifyValueType(fieldType.getOpcodeForStore() == 54, index);
                return new IntV(pool.getIntegerAt(index));
            }
            case 5: {
                BT_AnyConstantValue.verifyValueType(fieldType == pool.getRepository().getLong(), index);
                return new LongV(pool.getLongAt(index));
            }
            case 8: {
                BT_AnyConstantValue.verifyValueType(fieldType.getName().equals("java.lang.String"), index);
                return new StringV(pool.getStringAt(index));
            }
        }
        throw new BT_ClassFileException("invalid constant type at cp index " + index);
    }

    private static void verifyValueType(boolean valid, int index) throws BT_ClassFileException {
        if (!valid) {
            throw new BT_ClassFileException("invalid constant value at cp index " + index);
        }
    }

    public abstract String toString();

    public static class ClassV
    extends BT_AnyConstantValue {
        public final BT_Class value;

        ClassV(BT_Class v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfClassRef(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class DoubleV
    extends BT_AnyConstantValue {
        public final double value;

        DoubleV(double v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfDouble(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class FieldV
    extends BT_AnyConstantValue {
        public final BT_Field value;

        FieldV(BT_Field v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfFieldRef(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class FloatV
    extends BT_AnyConstantValue {
        public final float value;

        FloatV(float v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfFloat(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class IntV
    extends BT_AnyConstantValue {
        public final int value;

        IntV(int v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfInteger(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class InterfaceMethodV
    extends BT_AnyConstantValue {
        public final BT_Method value;

        InterfaceMethodV(BT_Method v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfInterfaceMethodRef(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class LongV
    extends BT_AnyConstantValue {
        public final long value;

        LongV(long v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfLong(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class MethodV
    extends BT_AnyConstantValue {
        public final BT_Method value;

        MethodV(BT_Method v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfMethodRef(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class NameAndTypeV
    extends BT_AnyConstantValue {
        public final String valueName;
        public final String valueType;

        NameAndTypeV(String vn, String vt) {
            this.valueName = vn;
            this.valueType = vt;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfNameAndType(this.valueName, this.valueType);
        }

        public String toString() {
            return String.valueOf(this.valueType) + "-" + this.valueName;
        }
    }

    public static class StringV
    extends BT_AnyConstantValue {
        public final String value;

        StringV(String v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfString(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Utf8V
    extends BT_AnyConstantValue {
        public final String value;

        Utf8V(String v) {
            this.value = v;
        }

        public int findInPool(BT_ConstantPool pool) {
            return pool.indexOfUtf8(this.value);
        }

        public String toString() {
            return this.value;
        }
    }
}

