/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.beans.petrinet.AblePetriArc;
import com.ibm.able.beans.petrinet.AblePetriNet;
import com.ibm.able.beans.petrinet.AblePetriNode;
import com.ibm.able.beans.petrinet.AblePetriToken;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.statistics.AbleExponentialDistribution;
import java.io.Serializable;
import java.util.Random;
import java.util.Vector;

public class AblePetriTransition
extends AblePetriNode
implements Serializable {
    static final long serialVersionUID = 2005020100000000001L;
    protected AbleExpression myExpression;
    protected boolean myEnabledFlag;
    protected double myFiringProbability = 1.0;
    protected double myMeanDelay = 0.0;
    protected AbleExponentialDistribution myDelayDistribution;
    protected Random myRandom = new Random();
    private String myExpressionText = "";
    private String myGuardClause = "";
    protected AblePetriNet myPetriNet = null;

    public AblePetriTransition() throws AbleException {
        super("Transition");
    }

    public AblePetriTransition(String string) throws AbleException {
        super(string);
    }

    public boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public void setMeanDelay(double d) {
        this.myMeanDelay = d;
        if (this.myMeanDelay != 0.0) {
            this.myDelayDistribution = new AbleExponentialDistribution(this.myMeanDelay);
        }
    }

    public double getMeanDelay() {
        return this.myMeanDelay;
    }

    public void setFiringProbability(double d) {
        this.myFiringProbability = d;
    }

    public double getFiringProbability() {
        return this.myFiringProbability;
    }

    public void init() throws AbleException {
        if (this.parent instanceof AblePetriNet) {
            this.myPetriNet = (AblePetriNet)this.parent;
        }
    }

    public boolean isEnabled(double d) throws AbleException {
        AbleExpression ableExpression;
        AbleIfThenElseRule ableIfThenElseRule = (AbleIfThenElseRule)this.myPetriNet.getRule(this.name);
        if (ableIfThenElseRule != null && !(ableExpression = ableIfThenElseRule.getAntecedent()).getBooleanValue()) {
            this.myEnabledFlag = false;
            return this.myEnabledFlag;
        }
        if (this.myInputArcs == null) {
            this.myEnabledFlag = true;
            return true;
        }
        if (this.myFiringProbability != 1.0 && d > this.myFiringProbability) {
            this.myEnabledFlag = false;
            return false;
        }
        for (int i = 0; i < this.myInputArcs.size(); ++i) {
            AblePetriArc ablePetriArc = (AblePetriArc)this.myInputArcs.get(i);
            boolean bl = ablePetriArc.isEnabled();
            if (ablePetriArc.isInhibitory()) {
                if (!bl) continue;
                this.myEnabledFlag = false;
                return this.myEnabledFlag;
            }
            if (bl) continue;
            this.myEnabledFlag = false;
            return this.myEnabledFlag;
        }
        this.myEnabledFlag = true;
        return true;
    }

    public void process() throws AbleException {
        AbleIfThenElseRule ableIfThenElseRule;
        AbleVariable ableVariable;
        Vector<AblePetriToken> vector = new Vector<AblePetriToken>();
        System.out.println("*** Firing " + this.name);
        if (this.myInputArcs != null) {
            for (int i = 0; i < this.myInputArcs.size(); ++i) {
                AblePetriArc ablePetriArc = (AblePetriArc)this.myInputArcs.get(i);
                if (ablePetriArc.isInhibitory()) continue;
                vector.addAll(ablePetriArc.removeTokens());
            }
        }
        if ((ableVariable = this.myPetriNet.getVariable("tokens")) != null) {
            ableVariable.setValue((AbleLiteral)new AbleGenericLiteral(vector));
        }
        if ((ableVariable = this.myPetriNet.getVariable("token")) != null && vector.size() > 0) {
            ableVariable.setValue((AbleLiteral)new AbleGenericLiteral(vector.get(0)));
        }
        if (this.myDelayDistribution != null) {
            double d = this.myDelayDistribution.next();
            try {
                Thread.sleep((long)d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((ableIfThenElseRule = (AbleIfThenElseRule)this.myPetriNet.getRule(this.name)) != null) {
            this.fireRule(ableIfThenElseRule);
        }
        if (this.myOutputArcs != null) {
            AblePetriArc ablePetriArc;
            int n;
            if (vector.size() == 0) {
                for (n = 0; n < this.myOutputArcs.size(); ++n) {
                    ablePetriArc = (AblePetriArc)this.myOutputArcs.get(n);
                    int n2 = ablePetriArc.getMultiplicity();
                    for (int i = 0; i < n2; ++i) {
                        vector.add(new AblePetriToken());
                    }
                }
            }
            for (n = 0; n < this.myOutputArcs.size(); ++n) {
                ablePetriArc = (AblePetriArc)this.myOutputArcs.get(n);
                ablePetriArc.addTokens(vector);
            }
        }
    }

    private void fireRule(AbleIfThenElseRule ableIfThenElseRule) throws AbleException {
        Vector vector = ableIfThenElseRule.getThenClauses();
        AbleInferenceEngine ableInferenceEngine = this.myPetriNet.getInferenceEngine();
        for (int i = 0; i < vector.size(); ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector.get(i);
            if (ableConsequentClause == null) continue;
            ableInferenceEngine.evalConsequentClause(ableConsequentClause);
        }
    }

    public String toString() {
        return this.name + " Transition is enabled? " + this.myEnabledFlag + Able.LS;
    }

    public AbleExpression getExpression() {
        return this.myExpression;
    }

    public String getExpressionText() {
        return this.myExpressionText;
    }

    public void setExpressionText(String string) {
        this.myExpressionText = string;
    }

    public String getGuardClauseText() {
        return this.myGuardClause;
    }

    public void setGuardClauseText(String string) {
        this.myGuardClause = string;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

