/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.beans.petrinet.AblePetriArc;
import com.ibm.able.beans.petrinet.AblePetriNode;
import com.ibm.able.beans.petrinet.AblePetriPlace;
import com.ibm.able.beans.petrinet.AblePetriTransition;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class AblePetriNet
extends AbleDefaultAgent
implements Serializable {
    static final long serialVersionUID = 2005020100000000001L;
    protected Vector myPlaces = new Vector();
    protected Vector myTransitions = new Vector();
    protected Vector myArcs = new Vector();
    protected Vector myInitializationExpressions;
    protected transient AbleRuleSet myRuleSet = null;
    private String myExpressionText = "";
    private String myVariablesText = "";
    protected transient ClassLoader myClassLoader = this.getClass().getClassLoader();

    public AblePetriNet() throws AbleException {
        super("AblePetriNet");
    }

    public AblePetriNet(String string) throws AbleException {
        super(string);
    }

    public Vector getPlaces() {
        return this.myPlaces;
    }

    public Vector getTransitions() {
        return this.myTransitions;
    }

    public Vector getArcs() {
        return this.myArcs;
    }

    public void addPlace(AblePetriPlace ablePetriPlace) {
        this.myPlaces.add(ablePetriPlace);
    }

    public void removePlace(AblePetriPlace ablePetriPlace) {
        this.myPlaces.remove(ablePetriPlace);
    }

    public void addTransition(AblePetriTransition ablePetriTransition) {
        this.myTransitions.add(ablePetriTransition);
    }

    public void removeTransition(AblePetriTransition ablePetriTransition) {
        this.myTransitions.remove(ablePetriTransition);
    }

    public void addArc(AblePetriArc ablePetriArc) {
        this.myArcs.add(ablePetriArc);
    }

    public void removeArc(AblePetriArc ablePetriArc) {
        this.myArcs.remove(ablePetriArc);
    }

    public void init() throws AbleException {
        try {
            this.createRuleSet();
        }
        catch (AbleException ableException) {
            System.out.println("Error: cannot create a valid ruleset from defined text sections - please check syntax");
            throw new AbleException("Error: cannot create a valid ruleset from defined text segments - please check syntax", (Throwable)ableException);
        }
        try {
            this.myRuleSet.init();
            this.myRuleSet.enterContext();
        }
        catch (AbleException ableException) {
            System.out.println("Error: cannot initialize the ruleset - check init() ruleblock logic.");
            throw new AbleException("Error: cannot initialize the ruleset - check init() rueblock logic.", (Throwable)ableException);
        }
        try {
            super.init();
            Vector vector = this.getBeans();
            for (int i = 0; i < vector.size(); ++i) {
                AbleBean ableBean = (AbleBean)vector.get(i);
                ableBean.init();
            }
        }
        catch (AbleException ableException) {
            System.out.println("Error: cannot initialize the ruleset or contained beans in the petri net. ");
            throw new AbleException("Error: cannot initialize the ruleset or contained beans in the petri net. ", (Throwable)ableException);
        }
    }

    protected void createRuleSet() throws AbleException {
        String string;
        AblePetriNode ablePetriNode;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ruleset PetriNet {" + Able.LS);
        stringBuffer.append(this.myVariablesText + Able.LS);
        stringBuffer.append(this.myExpressionText);
        stringBuffer.append(Able.LS + " void process() using Script { " + Able.LS);
        stringBuffer.append("   //  Place initialization rules ..." + Able.LS);
        for (n = 0; n < this.myPlaces.size(); ++n) {
            ablePetriNode = (AblePetriPlace)this.myPlaces.get(n);
            string = "";
            if (((AblePetriPlace)ablePetriNode).getExpressionText() != null) {
                string = ((AblePetriPlace)ablePetriNode).getExpressionText().trim();
            }
            if (string.length() <= 0) continue;
            stringBuffer.append("  " + ablePetriNode.getName() + ": if ( true ) { ");
            stringBuffer.append(((AblePetriPlace)ablePetriNode).getExpressionText());
            stringBuffer.append(Able.LS + "  };" + Able.LS);
        }
        stringBuffer.append("   //  Transition action rules ..." + Able.LS);
        for (n = 0; n < this.myTransitions.size(); ++n) {
            ablePetriNode = (AblePetriTransition)this.myTransitions.get(n);
            string = ((AblePetriTransition)ablePetriNode).getExpressionText().trim();
            if (string.length() <= 0) continue;
            String string2 = ((AblePetriTransition)ablePetriNode).getGuardClauseText().trim();
            if (string2.length() > 0) {
                stringBuffer.append("  " + ablePetriNode.getName() + ": if ( " + ((AblePetriTransition)ablePetriNode).getGuardClauseText() + ") { ");
            } else {
                stringBuffer.append("  " + ablePetriNode.getName() + ": if ( true ) { ");
            }
            stringBuffer.append(((AblePetriTransition)ablePetriNode).getExpressionText());
            stringBuffer.append(Able.LS + "  };" + Able.LS);
        }
        stringBuffer.append(" }" + Able.LS);
        stringBuffer.append("}");
        String string3 = stringBuffer.toString();
        System.out.println(string3);
        this.myRuleSet = new AbleRuleSet(this.name);
        this.myRuleSet.setClassLoader(this.myClassLoader);
        this.myRuleSet = this.myRuleSet.parseRuleSetFromARL(string3);
    }

    public AbleInferenceEngine getInferenceEngine() {
        return this.myRuleSet.getInferenceEngine("process()");
    }

    public AbleRule getRule(String string) {
        return this.myRuleSet.getRule(string);
    }

    public AbleRuleSet getRuleSet() {
        return this.myRuleSet;
    }

    public AbleVariable getVariable(String string) {
        return this.myRuleSet.getVariable(string);
    }

    public Vector getVariables() {
        try {
            return new Vector(this.myRuleSet.getVariables().values());
        }
        catch (AbleException ableException) {
            return new Vector();
        }
    }

    public void processTimerEvent() throws AbleException {
        this.process();
    }

    public void process() throws AbleException {
        AblePetriTransition ablePetriTransition;
        int n;
        if (this.myRuleSet == null) {
            if (this.getState() != 1026) {
                this.init();
            } else {
                System.out.println("Error: cannot process() ... PetriNet must be initialized!");
                throw new AbleException("Error - PetriNet must be initialized!");
            }
        }
        Vector<AblePetriTransition> vector = new Vector<AblePetriTransition>();
        Random random = new Random();
        double d = random.nextDouble();
        int n2 = 0;
        vector.clear();
        for (n = 0; n < this.myTransitions.size(); ++n) {
            ablePetriTransition = (AblePetriTransition)this.myTransitions.get(n);
            if (!ablePetriTransition.isEnabled(d)) continue;
            vector.add(ablePetriTransition);
        }
        n2 = vector.size();
        if (n2 > 0) {
            n = random.nextInt(n2);
            ablePetriTransition = (AblePetriTransition)vector.get(n);
            ablePetriTransition.process();
        }
        this.dataChanged(this);
    }

    public void addSourceBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.sourceBufferConnections.addElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("sourceBufferConnections", null, ableBufferConnection);
        this.changed = true;
        AbleBean ableBean = ableBufferConnection.getSource();
        AbleBean ableBean2 = ableBufferConnection.getDest();
        if (ableBean instanceof AblePetriNode && ableBean2 instanceof AblePetriNode) {
            AblePetriArc ablePetriArc = ableBean instanceof AblePetriPlace ? new AblePetriArc((AblePetriPlace)ableBean, (AblePetriTransition)ableBean2) : new AblePetriArc((AblePetriTransition)ableBean, (AblePetriPlace)ableBean2);
            ablePetriArc.setBufferConnection(ableBufferConnection);
        }
    }

    public void removeSourceBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.sourceBufferConnections.removeElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("sourceBufferConnections", ableBufferConnection, null);
        this.changed = true;
        AbleBean ableBean = ableBufferConnection.getSource();
        AbleBean ableBean2 = ableBufferConnection.getDest();
        Iterator iterator = this.myArcs.iterator();
        while (iterator.hasNext()) {
            AblePetriArc ablePetriArc = (AblePetriArc)iterator.next();
            if (ableBean != ablePetriArc.getSource() || ableBean2 != ablePetriArc.getTarget()) continue;
            this.myArcs.remove(ablePetriArc);
            break;
        }
    }

    public Vector getSourceBufferConnections() {
        return (Vector)this.sourceBufferConnections.clone();
    }

    public void addDestBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.destBufferConnections.addElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("destBufferConnections", null, ableBufferConnection);
        this.changed = true;
        AbleBean ableBean = ableBufferConnection.getSource();
        AbleBean ableBean2 = ableBufferConnection.getDest();
        if (ableBean instanceof AblePetriNode && ableBean2 instanceof AblePetriNode) {
            AblePetriArc ablePetriArc = ableBean instanceof AblePetriPlace ? new AblePetriArc((AblePetriPlace)ableBean, (AblePetriTransition)ableBean2) : new AblePetriArc((AblePetriTransition)ableBean, (AblePetriPlace)ableBean2);
            ablePetriArc.setBufferConnection(ableBufferConnection);
            this.addArc(ablePetriArc);
        }
    }

    public void removeDestBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.destBufferConnections.removeElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("destBufferConnections", ableBufferConnection, null);
        this.changed = true;
    }

    public Vector getDestBufferConnections() {
        return (Vector)this.destBufferConnections.clone();
    }

    public void addBean(AbleBean ableBean) throws AbleException {
        super.addBean(ableBean);
        if (ableBean instanceof AblePetriPlace) {
            if (!this.myPlaces.contains(ableBean)) {
                this.addPlace((AblePetriPlace)ableBean);
            }
        } else if (ableBean instanceof AblePetriTransition && !this.myTransitions.contains(ableBean)) {
            this.addTransition((AblePetriTransition)ableBean);
        }
    }

    public void removeBean(AbleBean ableBean) throws AbleException {
        super.removeBean(ableBean);
        if (ableBean instanceof AblePetriPlace) {
            this.removePlace((AblePetriPlace)ableBean);
        } else if (ableBean instanceof AblePetriTransition) {
            this.removeTransition((AblePetriTransition)ableBean);
        }
    }

    public void removeAllBeans() throws AbleException {
        super.removeAllBeans();
        this.myPlaces.clear();
        this.myTransitions.clear();
        this.myArcs.clear();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.myPlaces.size(); ++n) {
            stringBuffer.append(this.myPlaces.get(n).toString());
        }
        for (n = 0; n < this.myTransitions.size(); ++n) {
            stringBuffer.append(this.myTransitions.get(n).toString());
        }
        for (n = 0; n < this.myArcs.size(); ++n) {
            stringBuffer.append(this.myArcs.get(n).toString());
        }
        return stringBuffer.toString();
    }

    public String getVariablesText() {
        return this.myVariablesText;
    }

    public void setVariablesText(String string) {
        this.myVariablesText = string;
    }

    public String getExpressionText() {
        return this.myExpressionText;
    }

    public void setExpressionText(String string) {
        this.myExpressionText = string;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.myClassLoader = classLoader;
        }
    }

    public ClassLoader getClassLoader() {
        return this.myClassLoader;
    }

    protected void buildProcessList() throws AbleException {
        this.processListOK = true;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

