/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.beans.petrinet.AblePetriNode;
import com.ibm.able.beans.petrinet.AblePetriPlace;
import com.ibm.able.beans.petrinet.AblePetriTransition;
import com.ibm.able.data.AbleExpression;
import java.io.Serializable;
import java.util.Vector;

public class AblePetriArc
implements Serializable {
    static final long serialVersionUID = 2005020100000000001L;
    protected AbleExpression myExpression;
    protected AblePetriNode mySource;
    protected AblePetriNode myTarget;
    protected boolean myInhibitorFlag = false;
    protected boolean mySourceIsPlace = false;
    protected int myMultiplicity = 1;
    protected AbleBufferConnection myBufferConnection;

    public AblePetriArc() {
    }

    public AblePetriArc(AbleExpression ableExpression) {
        this.myExpression = ableExpression;
    }

    public AblePetriArc(AblePetriPlace ablePetriPlace, AblePetriTransition ablePetriTransition) {
        this.mySource = ablePetriPlace;
        this.myTarget = ablePetriTransition;
        this.mySourceIsPlace = true;
        this.mySource.addOutputArc(this);
        this.myTarget.addInputArc(this);
    }

    public AblePetriArc(AblePetriTransition ablePetriTransition, AblePetriPlace ablePetriPlace) {
        this.mySource = ablePetriTransition;
        this.myTarget = ablePetriPlace;
        this.mySourceIsPlace = false;
        this.mySource.addOutputArc(this);
        this.myTarget.addInputArc(this);
    }

    public void setInhibitory(boolean bl) {
        this.myInhibitorFlag = bl;
        if (this.myBufferConnection != null) {
            this.myBufferConnection.setInhibitory(bl);
        }
    }

    public boolean isInhibitory() {
        if (this.myBufferConnection != null) {
            this.myInhibitorFlag = this.myBufferConnection.getInhibitory();
        }
        return this.myInhibitorFlag;
    }

    public AblePetriNode getSource() {
        return this.mySource;
    }

    public AblePetriNode getTarget() {
        return this.myTarget;
    }

    public void setMultiplicity(int n) {
        this.myMultiplicity = n;
        if (this.myBufferConnection != null) {
            this.myBufferConnection.setMultiplicity(n);
        }
    }

    public int getMultiplicity() {
        if (this.myBufferConnection != null) {
            this.myMultiplicity = this.myBufferConnection.getMultiplicity();
        }
        return this.myMultiplicity;
    }

    public boolean isEnabled() {
        AblePetriPlace ablePetriPlace;
        return this.mySourceIsPlace && (ablePetriPlace = (AblePetriPlace)this.mySource).getNumTokens() >= this.myMultiplicity;
    }

    public Vector removeTokens() {
        Vector vector = null;
        if (this.myInhibitorFlag) {
            return null;
        }
        if (this.mySourceIsPlace) {
            AblePetriPlace ablePetriPlace = (AblePetriPlace)this.mySource;
            vector = ablePetriPlace.removeNTokens(this.myMultiplicity);
        }
        return vector;
    }

    public void addTokens(Vector vector) {
        if (this.myInhibitorFlag) {
            return;
        }
        this.getMultiplicity();
        AblePetriPlace ablePetriPlace = (AblePetriPlace)this.myTarget;
        for (int i = 0; i < this.myMultiplicity; ++i) {
            ablePetriPlace.addToken(vector.remove(0));
        }
    }

    public String toString() {
        return " Arc from " + this.mySource.getName() + " to " + this.myTarget.getName() + " has mult = " + this.myMultiplicity + Able.LS;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public void setBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.myBufferConnection = ableBufferConnection;
    }
}

