/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.knn.AbleKnnDistributed;
import com.ibm.able.beans.knn.JasKnnDistributedAgentIF;
import com.ibm.able.data.AbleField;
import com.ibm.able.platform.AblePlatformDefaultAgent;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.Locator;

public class JasKnnDistributedAgent
extends AblePlatformDefaultAgent
implements JasKnnDistributedAgentIF,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = "JasKnnDistributedAgent";
    private String trainDataFileName;
    private int bufferSize = 0;
    private int k = 1;
    private AbleFilter filt1 = null;
    private AbleFilter filt2 = null;
    private AbleImport imp1 = null;
    private AbleKnnDistributed knnDistributed = null;

    public JasKnnDistributedAgent() throws RemoteException, AbleException {
        this(defaultName);
    }

    public JasKnnDistributedAgent(String string) throws RemoteException, AbleException {
        super(string);
        this.setDefaults();
    }

    protected void setDefaults() throws AbleException {
        this.k = 1;
        this.setSleepTime(10L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public AbleKnnDistributed getDistributedKnnBean() {
        return this.knnDistributed;
    }

    public void init() throws AbleException {
        if (this.trainDataFileName == null || this.trainDataFileName.equals("")) {
            if (this.trace.isLogging() && (this.trainDataFileName == null || this.trainDataFileName.equals(""))) {
                this.trace.text(524288L, (Object)this, "init()", "k-NN Classifier Agent " + this.getName() + " not initialized due to lack of trainDataFileName.");
            }
            return;
        }
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "init()", "Configuring k-NN Classifier Agent " + this.getName());
        }
        AbleDefaultAgent.removeBeans((AbleBeanContainer)this, (AbleBean[])new AbleBean[]{this.imp1, this.filt1, this.filt2, this.knnDistributed});
        this.imp1 = new AbleImport();
        this.addBean((AbleBean)this.imp1);
        this.imp1.setBufferSize(this.bufferSize);
        this.imp1.setDataFileName(this.trainDataFileName);
        this.imp1.init();
        this.filt1 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        this.filt2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
        this.addBean((AbleBean)this.filt1);
        this.addBean((AbleBean)this.filt2);
        this.knnDistributed = new AbleKnnDistributed();
        this.addBean((AbleBean)this.knnDistributed);
        this.knnDistributed.generateTranslateTemplates(this.filt1, this.filt2, this.imp1.getFieldList());
        int n = this.filt1.getNumInUnits();
        int n2 = n + 1;
        int n3 = this.calcNumClasses();
        long l = this.imp1.getNumRecords();
        this.knnDistributed.setK(this.k);
        this.knnDistributed.setModelParameters(l, n2, n3);
        this.knnDistributed.init();
        new AbleBufferConnection((AbleBean)this.imp1, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.knnDistributed);
        new AbleBufferConnection((AbleBean)this.knnDistributed, (AbleBean)this.filt2);
        this.setInputBuffer(this.filt1.getInputBuffer());
        this.setOutputBuffer(this.filt2.getOutputBuffer());
        this.imp1.setDataFlowEnabled(true);
        this.filt1.setDataFlowEnabled(true);
        this.filt2.setDataFlowEnabled(true);
        this.knnDistributed.setDataFlowEnabled(true);
        int n4 = 0;
        while ((long)n4 < l) {
            this.process();
            ++n4;
        }
        super.init();
    }

    private int calcNumClasses() throws AbleException {
        if (this.imp1 == null) {
            return 0;
        }
        Vector vector = this.imp1.getFieldList("output");
        if (vector.size() == 0) {
            return 0;
        }
        AbleField ableField = (AbleField)vector.elementAt(0);
        return ableField.getMap().size();
    }

    public void reset() throws AbleException {
        this.setDefaults();
        if (this.imp1 != null) {
            this.imp1.reset();
        }
        if (this.knnDistributed != null) {
            this.knnDistributed.reset();
        }
        if (this.filt1 != null) {
            this.filt1.reset();
        }
        if (this.filt2 != null) {
            this.filt2.reset();
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (ableEvent.getId() == 2) {
            this.knnDistributed.reset();
        }
        super.handleAbleEvent(ableEvent);
    }

    public void setTrainDataFileName(String string) throws AbleException {
        if (this.imp1 != null) {
            String string2 = this.imp1.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp1.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp1.setDataFileName(string);
            }
        }
        this.trainDataFileName = string;
    }

    public String getTrainDataFileName() {
        return this.trainDataFileName;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AbleKnnDistributed getKnnBean() {
        return this.knnDistributed;
    }

    public AbleImport getKnnImp1() {
        return this.imp1;
    }

    public AbleFilter getKnnFil1() {
        return this.filt1;
    }

    public AbleFilter getKnnFil2() {
        return this.filt2;
    }

    public void setK(int n) {
        block3: {
            try {
                this.k = n;
                if (this.knnDistributed != null) {
                    this.knnDistributed.setK(n);
                }
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block3;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
    }

    public void setFilt1(AbleFilter ableFilter) {
        this.filt1 = ableFilter;
    }

    public void setFilt2(AbleFilter ableFilter) {
        this.filt2 = ableFilter;
    }

    public int getK() {
        if (this.knnDistributed != null) {
            this.k = this.knnDistributed.getK();
            return this.k;
        }
        return this.k;
    }

    public long getNumRecords() {
        long l = 0L;
        if (this.knnDistributed != null) {
            l = this.knnDistributed.getNumRecords();
        }
        return l;
    }

    public int getNumClasses() {
        int n = 0;
        if (this.knnDistributed != null) {
            n = this.knnDistributed.getNumClasses();
        }
        return n;
    }

    public int getNumAttributes() {
        int n = 0;
        if (this.knnDistributed != null) {
            n = this.knnDistributed.getNumAttributes();
        }
        return n;
    }

    public void sendTo(Locator locator, AgentName agentName, Object object) throws AbleException {
        this.debugTrace(this.getName() + ": Yowza! Instructed to send a transpo' message.  Yassuh! Right away, Suh!");
        this.sendTransportMessage(locator, agentName, object);
    }

    protected void debugTrace(String string) {
        try {
            System.out.println("!!- " + this.getClass().getName() + ": " + string);
        }
        catch (Exception exception) {
            System.out.println("!!- " + this.getClass().getName() + ": " + "debugTrace(): Caught exception: " + exception);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

