/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.knn.AbleKnnCentral;
import com.ibm.able.beans.knn.JasKnnDistributedAgent;
import com.ibm.able.beans.knn.JasKnnDistributedAgentIF;
import com.ibm.able.data.AbleField;
import com.ibm.able.platform.AblePlatformDefaultAgent;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.directory.AgentDescription;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrObject;
import org.jagent.acr.AcrPayload;

public class JasKnnCentralAgent
extends AblePlatformDefaultAgent {
    private String testDataFileName;
    private AbleImport imp2;
    private AbleFilter filt1;
    private AbleFilter filt2;
    private AbleKnnCentral knnCentral;
    private double[] currentTestExample = null;
    private int k = 1;
    private long numRecords = 0L;
    private int numAttributes = 0;
    private int numClasses = 0;
    private int bufferSize = 0;
    private Vector model1 = null;
    private Vector model2 = null;
    private JasKnnDistributedAgent lclJasKnnAgent1a = null;
    private JasKnnDistributedAgent lclJasKnnAgent2a = null;
    private AgentName lclAgentName1 = null;
    private AgentName lclAgentName2 = null;
    private JasKnnDistributedAgentIF lclJasKnnAgent1b = null;
    private JasKnnDistributedAgentIF lclJasKnnAgent2b = null;
    private Locator lclAbleMasterLocator1 = null;
    private Locator lclAbleMasterLocator2 = null;
    private Locator lclAbleDistrLocator1 = null;
    private Locator lclAbleDistrLocator2 = null;
    static /* synthetic */ Class class$javax$agent$TransportMessage;

    public JasKnnDistributedAgent getAgent1() {
        return this.lclJasKnnAgent1a;
    }

    public JasKnnDistributedAgent getAgent2() {
        return this.lclJasKnnAgent2a;
    }

    public AbleImport getKnnImp2() {
        return this.imp2;
    }

    public AbleFilter getKnnFil1() {
        return this.filt1;
    }

    public AbleFilter getKnnFil2() {
        return this.filt2;
    }

    public Vector getKnnModel1() {
        return this.model1;
    }

    public Vector getKnnModel2() {
        return this.model2;
    }

    public JasKnnDistributedAgent getLclJasKnnAgent1a() {
        return this.lclJasKnnAgent1a;
    }

    public JasKnnDistributedAgent getLclJasKnnAgent2a() {
        return this.lclJasKnnAgent2a;
    }

    public Locator getLclAbleMasterLocator1() {
        return this.lclAbleMasterLocator1;
    }

    public Locator getLclAbleMasterLocator2() {
        return this.lclAbleMasterLocator2;
    }

    public Locator getLclAbleDistrLocator1() {
        return this.lclAbleDistrLocator1;
    }

    public Locator getLclAbleDistrLocator2() {
        return this.lclAbleDistrLocator2;
    }

    public AgentName getLclAgentName1() {
        return this.lclAgentName1;
    }

    public AgentName getLclAgentName2() {
        return this.lclAgentName2;
    }

    public void init() throws AbleException {
        if (this.testDataFileName == null || this.testDataFileName.equals("")) {
            if (this.trace.isLogging() && (this.testDataFileName == null || this.testDataFileName.equals(""))) {
                this.trace.text(524288L, (Object)this, "init()", "k-NN Central Classifier Agent " + this.getName() + " not initialized due to lack of testDataFileName.");
            }
            return;
        }
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "init()", "Configuring k-NN Central Classifier Agent " + this.getName());
        }
        if (this.model1 == null) {
            this.model1 = new Vector();
        } else {
            this.model1.removeAllElements();
        }
        if (this.model2 == null) {
            this.model2 = new Vector();
        } else {
            this.model2.removeAllElements();
        }
        AbleDefaultAgent.removeBeans((AbleBeanContainer)this, (AbleBean[])new AbleBean[]{this.imp2, this.filt1, this.filt2, this.knnCentral});
        this.imp2 = new AbleImport();
        this.addBean((AbleBean)this.imp2);
        this.imp2.setBufferSize(this.bufferSize);
        this.imp2.setDataFileName(this.testDataFileName);
        this.imp2.init();
        this.filt1 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        this.filt2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
        this.addBean((AbleBean)this.filt1);
        this.addBean((AbleBean)this.filt2);
        this.knnCentral = new AbleKnnCentral();
        this.addBean((AbleBean)this.knnCentral);
        this.knnCentral.generateTranslateTemplates(this.filt1, this.filt2, this.imp2.getFieldList());
        this.numAttributes = this.filt1.getNumInUnits();
        int n = this.numAttributes + 1;
        this.numClasses = this.calcNumClasses();
        this.numRecords = this.imp2.getNumRecords();
        this.knnCentral.setK(this.k);
        this.knnCentral.setModelParameters(this.numRecords, this.numAttributes, this.numClasses);
        this.knnCentral.init();
        new AbleBufferConnection((AbleBean)this.imp2, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.knnCentral);
        new AbleBufferConnection((AbleBean)this.knnCentral, (AbleBean)this.filt2);
        this.setInputBuffer(this.filt1.getInputBuffer());
        this.setOutputBuffer(this.filt2.getOutputBuffer());
        this.imp2.setDataFlowEnabled(true);
        this.filt1.setDataFlowEnabled(true);
        this.filt2.setDataFlowEnabled(true);
        this.knnCentral.setDataFlowEnabled(true);
        this.setDataFlowEnabled(false);
        this.setMode(this.knnCentral.getKnnMode());
        super.init();
    }

    public static void main(String[] stringArray) {
        Able.setTraceConsoleHandlerLevel((long)524288L);
        Able.setMessageConsoleHandlerLevel((long)4L);
        String string = "";
        int n = 5;
        int n2 = 5;
        try {
            if (stringArray.length >= 1 && (string = stringArray[0]) != null && string.trim().length() != 0) {
                n = Integer.parseInt(string.trim());
            }
            if (stringArray.length >= 2 && (string = stringArray[1]) != null && string.trim().length() != 0) {
                n2 = Integer.parseInt(string.trim());
            }
            JasKnnCentralAgent jasKnnCentralAgent = new JasKnnCentralAgent();
            jasKnnCentralAgent.setTestDataFileName("C:/ableWS/able/com/ibm/able/beans/knn/data/AnimalTest2.dfn");
            jasKnnCentralAgent.setK(1);
            jasKnnCentralAgent.setDataFlowEnabled(true);
            jasKnnCentralAgent.runBaseKnn();
            System.out.println(jasKnnCentralAgent.knnCentral.getError());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("++test.KnnJas.main(): Caught exception: " + exception);
        }
    }

    private void runBaseKnn() throws AbleException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        try {
            method = clazz.getMethod("someOtherRcvMsgMethod1", class$javax$agent$TransportMessage == null ? (class$javax$agent$TransportMessage = JasKnnCentralAgent.class$("javax.agent.TransportMessage")) : class$javax$agent$TransportMessage);
            method2 = clazz.getMethod("someOtherRcvMsgMethod2", class$javax$agent$TransportMessage == null ? (class$javax$agent$TransportMessage = JasKnnCentralAgent.class$("javax.agent.TransportMessage")) : class$javax$agent$TransportMessage);
            method3 = clazz.getMethod("rcvMsgForFooBar", class$javax$agent$TransportMessage == null ? (class$javax$agent$TransportMessage = JasKnnCentralAgent.class$("javax.agent.TransportMessage")) : class$javax$agent$TransportMessage);
            method4 = clazz.getMethod("rcvMsgForBarBaz", class$javax$agent$TransportMessage == null ? (class$javax$agent$TransportMessage = JasKnnCentralAgent.class$("javax.agent.TransportMessage")) : class$javax$agent$TransportMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.text(4L, (Object)this, "runBaseKnn", noSuchMethodException.getLocalizedMessage());
            this.trace.exception(262144L, (Object)this, "runBaseKnn", (Throwable)noSuchMethodException);
            throw new AbleException("ABLE JAS agent caught NoSuchMethodException.", (Throwable)noSuchMethodException);
        }
        AbleUserDefinedFunction ableUserDefinedFunction = new AbleUserDefinedFunction("receiveMessage", (Object)this, method);
        AbleUserDefinedFunction ableUserDefinedFunction2 = new AbleUserDefinedFunction("receiveMessage", (Object)this, method2);
        AbleUserDefinedFunction ableUserDefinedFunction3 = new AbleUserDefinedFunction("receiveMessage", (Object)this, method3);
        AbleUserDefinedFunction ableUserDefinedFunction4 = new AbleUserDefinedFunction("receiveMessage", (Object)this, method4);
        this.setName("Master");
        this.setComment("Hee, hee: I control slaves <A> and <B> !");
        this.setAgentType("Just a Knn agent");
        this.addJasAgentAttribute("Knn-user-attr1", "attr 1 value");
        this.addJasAgentAttribute("Knn-user-attr2", "attr two value");
        this.addAgentInbox(new Object[]{"defaultProtocol", ableUserDefinedFunction});
        this.addAgentInbox(new Object[]{"defaultProtocol", ableUserDefinedFunction2});
        this.init();
        this.setDataFlowEnabled(true);
        System.out.println("We created the central (master) agent, now we start creating the distributed agents (slaves)");
        try {
            Locator locator;
            int n;
            this.debugTrace("Constructing fooFram agent.");
            this.lclJasKnnAgent1a = new JasKnnDistributedAgent();
            this.lclJasKnnAgent1a.setName("fooFram");
            this.lclJasKnnAgent1a.setComment("I'm slave <A> to the master.");
            this.lclJasKnnAgent1a.setAgentType("Just a Knn agent named fooFram");
            this.lclJasKnnAgent1a.addJasAgentAttribute("foo-Knn-user-attr1", "FOO: attr 1 value");
            this.lclJasKnnAgent1a.addJasAgentAttribute("foo-Knn-user-attr2", "FOO: attr two value");
            this.lclJasKnnAgent1a.addAgentInbox(new Object[]{"defaultProtocol", ableUserDefinedFunction3});
            this.lclJasKnnAgent1a.setTrainDataFileName("C:/ableWS/able/com/ibm/able/beans/knn/data/Animal.dfn");
            this.lclJasKnnAgent1a.setK(1);
            if (this.filt1 != null) {
                this.lclJasKnnAgent1a.setFilt1(this.filt1);
            }
            if (this.filt2 != null) {
                this.lclJasKnnAgent1a.setFilt2(this.filt2);
            }
            this.lclJasKnnAgent1a.init();
            this.lclJasKnnAgent1a.setDataFlowEnabled(true);
            this.debugTrace("Constructing barBaz agent.");
            this.lclJasKnnAgent2a = new JasKnnDistributedAgent();
            this.lclJasKnnAgent2a.setName("barBaz");
            this.lclJasKnnAgent2a.setComment("I'm another slave, slave <B>.");
            this.lclJasKnnAgent2a.setAgentType("Just a Knn agent named barBaz");
            this.lclJasKnnAgent2a.addJasAgentAttribute("bar-Knn-user-attr1", "BAR: attr 1 value");
            this.lclJasKnnAgent2a.addJasAgentAttribute("bar-Knn-user-attr2", "BAR: attr two value");
            this.lclJasKnnAgent2a.addAgentInbox(new Object[]{"defaultProtocol", ableUserDefinedFunction4});
            this.lclJasKnnAgent2a.setTrainDataFileName("C:/ableWS/able/com/ibm/able/beans/knn/data/Animal.dfn");
            this.lclJasKnnAgent2a.setK(1);
            if (this.filt1 != null) {
                this.lclJasKnnAgent2a.setFilt1(this.filt1);
            }
            if (this.filt2 != null) {
                this.lclJasKnnAgent2a.setFilt2(this.filt2);
            }
            this.lclJasKnnAgent2a.init();
            this.lclJasKnnAgent2a.setDataFlowEnabled(true);
            AgentDescription[] agentDescriptionArray = null;
            Locator[] locatorArray = null;
            agentDescriptionArray = this.lookUpAgent("javax.agent.agent-display-name", "Master");
            if (agentDescriptionArray == null || agentDescriptionArray.length == 0) {
                this.debugTrace("Didn't find AgentDescriptions for <Master> agent.");
                return;
            }
            locatorArray = agentDescriptionArray[0].getLocators();
            if (locatorArray == null || locatorArray.length == 0) {
                this.debugTrace("Didn't find Locators for <Master> agent.");
                return;
            }
            for (n = 0; n < locatorArray.length; ++n) {
                locator = locatorArray[n];
                this.debugTrace("Locator " + n + " type is <" + locator.getType() + ">.");
                System.out.println("type " + locator.getType());
            }
            this.lclAbleMasterLocator1 = locatorArray[0];
            this.lclAbleMasterLocator2 = locatorArray[1];
            agentDescriptionArray = null;
            locatorArray = null;
            agentDescriptionArray = this.lookUpAgent("javax.agent.agent-display-name", "fooFram");
            if (agentDescriptionArray == null || agentDescriptionArray.length == 0) {
                this.debugTrace("Didn't find AgentDescriptions for <fooFram> agent.");
                return;
            }
            this.lclAgentName1 = agentDescriptionArray[0].getAgentName();
            locatorArray = agentDescriptionArray[0].getLocators();
            if (locatorArray == null || locatorArray.length == 0) {
                this.debugTrace("Didn't find Locators for <fooFram> agent.");
                return;
            }
            if (locatorArray.length < 2) {
                this.debugTrace("Didn't find at least TWO Locators for <fooFram> agent.");
                return;
            }
            for (n = 0; n < locatorArray.length; ++n) {
                locator = locatorArray[n];
                this.debugTrace("Locator " + n + " type is <" + locator.getType() + ">.");
                System.out.println("type " + locator.getType());
            }
            this.lclAbleDistrLocator1 = locatorArray[0];
            agentDescriptionArray = null;
            locatorArray = null;
            agentDescriptionArray = this.lookUpAgent("javax.agent.agent-display-name", "barBaz");
            if (agentDescriptionArray == null || agentDescriptionArray.length == 0) {
                this.debugTrace("Didn't find AgentDescriptions for <barBaz> agent.");
                return;
            }
            this.lclAgentName2 = agentDescriptionArray[0].getAgentName();
            locatorArray = agentDescriptionArray[0].getLocators();
            if (locatorArray == null || locatorArray.length == 0) {
                this.debugTrace("Didn't find Locators for <barBaz> agent.");
                return;
            }
            if (locatorArray.length < 2) {
                this.debugTrace("Didn't find at least TWO Locators for <barBaz> agent.");
                return;
            }
            for (n = 0; n < locatorArray.length; ++n) {
                locator = locatorArray[n];
                this.debugTrace("Locator " + n + " type is <" + locator.getType() + ">.");
                System.out.println("type " + locator.getType());
            }
            this.lclAbleDistrLocator2 = locatorArray[0];
            Locator locator2 = locatorArray[0];
            for (long i = 0L; i < this.getNumRec(); ++i) {
                this.process();
            }
        }
        catch (Exception exception) {
            this.debugTrace("Caught exception " + exception);
            exception.printStackTrace();
        }
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }

    public long getNumRec() {
        return this.numRecords;
    }

    public void setNumRec(long l) {
        this.numRecords = l;
    }

    public void setTestDataFileName(String string) throws AbleException {
        if (this.imp2 != null) {
            String string2 = this.imp2.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp2.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp2.setDataFileName(string);
            }
        }
        this.testDataFileName = string;
    }

    public String getTestDataFileName() {
        return this.testDataFileName;
    }

    private int calcNumClasses() throws AbleException {
        if (this.imp2 == null) {
            return 0;
        }
        Vector vector = this.imp2.getFieldList("output");
        if (vector.size() == 0) {
            return 0;
        }
        AbleField ableField = (AbleField)vector.elementAt(0);
        return ableField.getMap().size();
    }

    public void setMode(int n) throws AbleException {
        int n2 = this.getState();
        if (n2 == 1026 || n2 == 1020) {
            return;
        }
        if (n == 1) {
            if (this.imp2.getState() != 1026) {
                this.imp2.setDataFlowEnabled(true);
                this.setDataFlowEnabled(false);
            }
            this.knnCentral.setKnnMode(1);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "k-NN classifier agent using TEST mode");
            }
        } else if (n == 2) {
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(true);
            this.knnCentral.setKnnMode(2);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "k-NN classifier agent using RUN mode");
            }
        }
    }

    public void receiveMessage(TransportMessage transportMessage) {
        if (this.trace.isLogging()) {
            this.trace.entry(262144L, (Object)this, "receiveMessage");
        }
        this.debugTrace("Oh my.  Seems I've received a message in RECEIVE MESSAGE: \n" + transportMessage);
        if (this.trace.isLogging()) {
            this.trace.exit(262144L, (Object)this, "receiveMessage");
        }
    }

    public Object processDistrAgent1(Object object) {
        TransportMessage transportMessage = (TransportMessage)object;
        AcrPayload acrPayload = (AcrPayload)transportMessage.getPayload();
        AclMessage aclMessage = (AclMessage)acrPayload.getMessage();
        AcrObject acrObject = (AcrObject)aclMessage.getContent();
        Object object2 = acrObject.getObject();
        Vector vector = null;
        try {
            vector = this.lclJasKnnAgent1a.getDistributedKnnBean().getKNN((double[])object2);
            this.lclJasKnnAgent1a.sendTo(this.lclAbleMasterLocator1, this.myJasAgentName, vector);
        }
        catch (Exception exception) {
            System.out.println("!!- " + ((Object)((Object)this)).getClass().getName() + ": " + "debugTrace(): Caught exception: " + exception);
        }
        return vector;
    }

    public Object processDistrAgent2(Object object) {
        TransportMessage transportMessage = (TransportMessage)object;
        AcrPayload acrPayload = (AcrPayload)transportMessage.getPayload();
        AclMessage aclMessage = (AclMessage)acrPayload.getMessage();
        AcrObject acrObject = (AcrObject)aclMessage.getContent();
        Object object2 = acrObject.getObject();
        Vector vector = null;
        try {
            vector = this.lclJasKnnAgent2a.getDistributedKnnBean().getKNN((double[])object2);
            this.lclJasKnnAgent1a.sendTo(this.lclAbleMasterLocator2, this.myJasAgentName, vector);
        }
        catch (Exception exception) {
            System.out.println("!!- " + ((Object)((Object)this)).getClass().getName() + ": " + "debugTrace(): Caught exception: " + exception);
        }
        return vector;
    }

    public void sendTo(Locator locator, AgentName agentName, Object object) throws AbleException {
        this.debugTrace(this.getName() + ": Yowza! Instructed to send a transpo' message.  Yassuh! Right away, Suh!");
        this.sendTransportMessage(locator, agentName, object);
    }

    public Object processCentralAgent(Object object) {
        TransportMessage transportMessage = (TransportMessage)object;
        AcrPayload acrPayload = (AcrPayload)transportMessage.getPayload();
        AclMessage aclMessage = (AclMessage)acrPayload.getMessage();
        AcrObject acrObject = (AcrObject)aclMessage.getContent();
        Object object2 = acrObject.getObject();
        return object2;
    }

    public void someOtherRcvMsgMethod1(TransportMessage transportMessage) {
        if (this.trace.isLogging()) {
            this.trace.entry(262144L, (Object)this, "someOtherRcvMsgMethod");
        }
        this.debugTrace("Oh my.  Seems I've received a message at SOME OTHER ENTRY POINT (as expected): \n" + transportMessage);
        this.model1 = (Vector)this.processCentralAgent(transportMessage);
        if (this.trace.isLogging()) {
            this.trace.exit(262144L, (Object)this, "someOtherRcvMsgMethod");
        }
    }

    public void someOtherRcvMsgMethod2(TransportMessage transportMessage) {
        if (this.trace.isLogging()) {
            this.trace.entry(262144L, (Object)this, "someOtherRcvMsgMethod");
        }
        this.debugTrace("Oh my.  Seems I've received a message at SOME OTHER ENTRY POINT (as expected): \n" + transportMessage);
        this.model2 = (Vector)this.processCentralAgent(transportMessage);
        if (this.trace.isLogging()) {
            this.trace.exit(262144L, (Object)this, "someOtherRcvMsgMethod");
        }
    }

    public void rcvMsgForFooBar(TransportMessage transportMessage) {
        if (this.trace.isLogging()) {
            this.trace.entry(262144L, (Object)this, "rcvMsgForFooBar");
        }
        this.debugTrace("Crikey! JasKnn intercepted msg bound for FooBar: \n" + transportMessage);
        this.processDistrAgent1(transportMessage);
        if (this.trace.isLogging()) {
            this.trace.exit(262144L, (Object)this, "rcvMsgForFooBar");
        }
    }

    public void rcvMsgForBarBaz(TransportMessage transportMessage) {
        if (this.trace.isLogging()) {
            this.trace.entry(262144L, (Object)this, "rcvMsgForBarBaz");
        }
        this.debugTrace("Crikey! JasKnn intercepted msg bound for BarBaz: \n" + transportMessage);
        this.processDistrAgent2(transportMessage);
        if (this.trace.isLogging()) {
            this.trace.exit(262144L, (Object)this, "rcvMsgForBarBaz");
        }
    }

    protected void debugTrace(String string) {
        try {
            System.out.println("!!- " + ((Object)((Object)this)).getClass().getName() + ": " + string);
        }
        catch (Exception exception) {
            System.out.println("!!- " + ((Object)((Object)this)).getClass().getName() + ": " + "debugTrace(): Caught exception: " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

