/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleX;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.knn.AbleNaiveBayes;
import com.ibm.able.data.AbleField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class AbleNaiveBayesClassifierAgent
extends AbleDefaultAgent
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = AbleX.NlsMsg("DFLT_NAME_NaiveBayesAgent");
    private String trainDataFileName;
    private String testDataFileName;
    private int bufferSize = 0;
    private AbleImport imp1;
    private AbleImport imp2;
    private AbleFilter filt1;
    private AbleFilter filt2;
    private AbleNaiveBayes naiveBayes;
    private int m = 0;
    private int discretization = 10;

    public AbleNaiveBayesClassifierAgent() throws AbleException {
        this(defaultName);
    }

    public AbleNaiveBayesClassifierAgent(String string) throws AbleException {
        super(string);
        this.setDefaults();
    }

    protected void setDefaults() throws AbleException {
        this.setSleepTime(10L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public void init() throws AbleException {
        if (this.trainDataFileName == null || this.trainDataFileName.equals("") || this.testDataFileName == null || this.testDataFileName.equals("")) {
            if (this.trace.isLogging()) {
                if (this.trainDataFileName == null || this.trainDataFileName.equals("")) {
                    this.trace.text(524288L, (Object)this, "init()", "Naive Bayes Classifier Agent " + this.name + " not initialized due to lack of trainDataFileName.");
                }
                if (this.testDataFileName == null || this.testDataFileName.equals("")) {
                    this.trace.text(524288L, (Object)this, "init()", "Naive Bayes Classifier Agent " + this.name + " not initialized due to lack of testDataFileName.");
                }
            }
            return;
        }
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "init()", "Configuring Naive Bayes Classifier Agent " + this.name);
        }
        AbleDefaultAgent.removeBeans((AbleBeanContainer)this, (AbleBean[])new AbleBean[]{this.imp1, this.imp2, this.filt1, this.filt2, this.naiveBayes});
        this.imp1 = new AbleImport();
        this.addBean((AbleBean)this.imp1);
        this.imp1.setBufferSize(this.bufferSize);
        this.imp1.setDataFileName(this.trainDataFileName);
        this.imp1.init();
        this.imp2 = new AbleImport(Able.NlsMsg((String)"DFLT_NAME_TestImport"));
        this.addBean((AbleBean)this.imp2);
        this.imp2.setBufferSize(this.bufferSize);
        this.imp2.setDataFileName(this.testDataFileName);
        this.imp2.setComputeStatistics(false);
        this.imp2.init();
        this.filt1 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        this.filt2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
        this.addBean((AbleBean)this.filt1);
        this.addBean((AbleBean)this.filt2);
        this.naiveBayes = new AbleNaiveBayes();
        this.addBean((AbleBean)this.naiveBayes);
        this.naiveBayes.generateTranslateTemplates(this.filt1, this.filt2, this.imp1.getFieldList());
        int n = this.filt1.getNumInUnits();
        int n2 = n + 1;
        int n3 = this.calcNumClasses();
        long l = this.imp1.getNumRecords();
        this.naiveBayes.setM(this.m);
        this.naiveBayes.setDiscretization(this.discretization);
        this.naiveBayes.setNaiveBayesParameters(n2, n3, l);
        this.naiveBayes.init();
        new AbleBufferConnection((AbleBean)this.imp1, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.imp2, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.naiveBayes);
        new AbleBufferConnection((AbleBean)this.naiveBayes, (AbleBean)this.filt2);
        this.inputBuffer = this.filt1.getInputBuffer();
        this.outputBuffer = this.filt2.getOutputBuffer();
        this.imp1.setDataFlowEnabled(true);
        this.imp2.setDataFlowEnabled(false);
        this.filt1.setDataFlowEnabled(true);
        this.filt2.setDataFlowEnabled(true);
        this.naiveBayes.setDataFlowEnabled(true);
        int n4 = 0;
        while ((long)n4 < l) {
            this.process();
            ++n4;
        }
        this.setMode(this.naiveBayes.getNaiveBayesMode());
        super.init();
    }

    private int calcNumClasses() throws AbleException {
        if (this.imp1 == null) {
            return 0;
        }
        Vector vector = this.imp1.getFieldList("output");
        if (vector.size() == 0) {
            return 0;
        }
        AbleField ableField = (AbleField)vector.elementAt(0);
        return ableField.getMap().size();
    }

    public void reset() throws AbleException {
        this.setDefaults();
        if (this.imp1 != null) {
            this.imp1.reset();
        }
        if (this.imp2 != null) {
            this.imp2.reset();
        }
        if (this.naiveBayes != null) {
            this.naiveBayes.reset();
        }
        if (this.filt1 != null) {
            this.filt1.reset();
        }
        if (this.filt2 != null) {
            this.filt2.reset();
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) throws AbleException {
        super.handleAbleEvent(ableEvent);
    }

    public void setTrainDataFileName(String string) throws AbleException {
        if (this.imp1 != null) {
            String string2 = this.imp1.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp1.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp1.setDataFileName(string);
            }
        }
        this.trainDataFileName = string;
    }

    public String getTrainDataFileName() {
        return this.trainDataFileName;
    }

    public void setTestDataFileName(String string) throws AbleException {
        if (this.imp2 != null) {
            String string2 = this.imp2.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp2.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp2.setDataFileName(string);
            }
        }
        this.testDataFileName = string;
    }

    public String getTestDataFileName() {
        return this.testDataFileName;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AbleNaiveBayes getNaiveBayesBean() {
        return this.naiveBayes;
    }

    public AbleImport getNaiveBayesImp1() {
        return this.imp1;
    }

    public AbleImport getNaiveBayesImp2() {
        return this.imp2;
    }

    public AbleFilter getNaiveBayesFil1() {
        return this.filt1;
    }

    public AbleFilter getNaiveBayesFil2() {
        return this.filt2;
    }

    public void setM(int n) {
        block3: {
            try {
                this.m = n;
                if (this.naiveBayes != null) {
                    this.naiveBayes.setM(n);
                }
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block3;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
    }

    public int getM() {
        if (this.naiveBayes != null) {
            this.m = this.naiveBayes.getM();
            return this.m;
        }
        return this.m;
    }

    public void setDiscretization(int n) {
        block3: {
            try {
                this.discretization = n;
                if (this.naiveBayes != null) {
                    this.naiveBayes.setDiscretization(n);
                }
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block3;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
    }

    public int getDiscretization() {
        if (this.naiveBayes != null) {
            this.discretization = this.naiveBayes.getDiscretization();
            return this.discretization;
        }
        return this.discretization;
    }

    public long getNumRecords() {
        long l = 0L;
        if (this.naiveBayes != null) {
            l = this.naiveBayes.getNumRecords();
        }
        return l;
    }

    public int getNumClasses() {
        int n = 0;
        if (this.naiveBayes != null) {
            n = this.naiveBayes.getNumClasses();
        }
        return n;
    }

    public int getNumAttributes() {
        int n = 0;
        if (this.naiveBayes != null) {
            n = this.naiveBayes.getNumAttributes();
        }
        return n;
    }

    public void setMode(int n) throws AbleException {
        int n2 = this.getState();
        if (n2 == 1026 || n2 == 1020) {
            return;
        }
        if (n == 0) {
            this.imp1.setDataFlowEnabled(true);
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(false);
            this.naiveBayes.setNaiveBayesMode(0);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "Naive Bayes classifier agent using TRAIN mode");
            }
        } else if (n == 1) {
            if (this.imp2.getState() != 1026) {
                this.imp1.setDataFlowEnabled(false);
                this.imp2.setDataFlowEnabled(true);
                this.setDataFlowEnabled(false);
            }
            this.naiveBayes.setNaiveBayesMode(1);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "Naive Bayes classifier agent using TEST mode");
            }
        } else if (n == 2) {
            this.imp1.setDataFlowEnabled(false);
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(true);
            this.naiveBayes.setNaiveBayesMode(2);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "Naive Bayes classifier agent using RUN mode");
            }
        }
    }

    public int getMode() throws AbleException {
        if (this.naiveBayes == null) {
            return 0;
        }
        return this.naiveBayes.getNaiveBayesMode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.trainDataFileName = Able.getSerializablePath((String)this.trainDataFileName);
        this.testDataFileName = Able.getSerializablePath((String)this.testDataFileName);
        objectOutputStream.defaultWriteObject();
        this.trainDataFileName = Able.getLocalPath((String)this.trainDataFileName);
        this.testDataFileName = Able.getLocalPath((String)this.testDataFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.trainDataFileName = Able.getLocalPath((String)this.trainDataFileName);
        this.testDataFileName = Able.getLocalPath((String)this.testDataFileName);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public static void main(String[] stringArray) {
        try {
            AbleNaiveBayesClassifierAgent ableNaiveBayesClassifierAgent = new AbleNaiveBayesClassifierAgent();
            ableNaiveBayesClassifierAgent.setTrainDataFileName("C:/ableWS/able/com/ibm/able/beans/knn/data/animal.dfn");
            ableNaiveBayesClassifierAgent.setTestDataFileName("C:/ableWS/able/com/ibm/able/beans/knn/data/animal.dfn");
            ableNaiveBayesClassifierAgent.init();
            ableNaiveBayesClassifierAgent.setDataFlowEnabled(true);
            int n = 0;
            while ((long)n < ableNaiveBayesClassifierAgent.getNumRecords()) {
                ableNaiveBayesClassifierAgent.process();
                ++n;
            }
            System.out.println("error = " + ableNaiveBayesClassifierAgent.naiveBayes.getError());
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

