/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleX;
import com.ibm.able.beans.AbleAbstractImport;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.beans.filter.AbleTranslateTemplateProvider;
import com.ibm.able.beans.knn.AttributeValueClass;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleContinuousField;
import com.ibm.able.data.AbleDiscreteField;
import com.ibm.able.data.AbleField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AbleNaiveBayes
extends AbleObject
implements AbleTranslateTemplateProvider,
Serializable {
    public static final String defaultName = AbleX.NlsMsg("DFLT_NAME_NaiveBayes2");
    static final long serialVersionUID = 1999100100000000001L;
    public static final int PropertyMId = 9004;
    public static final String PropertyM = "mParam";
    public static final int PropertyDiscrId = 9005;
    public static final String PropertyDiscr = "Discretization";
    public double[] inNum;
    public double[] outNum;
    private int naiveBayesMode;
    public static final int TRAIN = 0;
    public static final int TEST = 1;
    public static final int RUN = 2;
    public static final String[] MODE_NAMES = new String[]{"Train", "Test", "Run"};
    private long numRecords = 0L;
    private int numAttributes = 0;
    private int numClasses = 0;
    private Vector table = null;
    private Vector allTable = null;
    private int m = 0;
    private int discretization = 10;
    private int numCorrectTestExamples = 0;
    private int numTestExamples = 0;
    private int currentTrainRecord = 0;
    private double error = -1.0;
    private double accuracy = -1.0;
    private int[] numAttributeValues = null;
    private int[] numRecPerClass = null;
    private double[] priorClassProb = null;
    private double[] currentTrainExample = null;
    private double[] currentTestExample = null;
    private double currentLearnedClass = 0.0;
    private double currentActualClass = 0.0;

    public double[] getInNum() {
        return this.inNum;
    }

    public double[] getOutNum() {
        return this.outNum;
    }

    public AbleNaiveBayes() throws AbleException {
        super(defaultName);
    }

    public AbleNaiveBayes(String string) throws AbleException {
        super(string);
        this.setState(1026);
    }

    public AbleNaiveBayes(String string, int n) throws AbleException {
        super(string);
        this.setDefaults();
    }

    protected void setDefaults() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public int getNaiveBayesMode() {
        return this.naiveBayesMode;
    }

    public void setNaiveBayesMode(int n) {
        this.naiveBayesMode = n;
    }

    public void setNaiveBayesParameters(int n, int n2, long l) {
        this.numAttributes = n;
        this.numClasses = n2;
        this.numRecords = l;
    }

    public void setM(int n) throws AbleException {
        int n2 = this.m;
        this.m = n;
        this.chgSupport.firePropertyChange(PropertyM, new Integer(n2), new Integer(n));
    }

    public int getM() {
        return this.m;
    }

    public void setDiscretization(int n) throws AbleException {
        int n2 = this.discretization;
        this.discretization = n;
        this.chgSupport.firePropertyChange(PropertyDiscr, new Integer(n2), new Integer(n));
    }

    public int getDiscretization() {
        return this.discretization;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public int getNumAttributes() {
        return this.numAttributes;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public long getNumTestExamples() {
        return this.numTestExamples;
    }

    public long getNumCorrectTestExamples() {
        return this.numCorrectTestExamples;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getError() {
        return this.error;
    }

    public double[] getCurrentTrainExample() {
        return this.currentTrainExample;
    }

    public double[] getCurrentTestExample() {
        return this.currentTestExample;
    }

    public double getCurrentLearnedClass() {
        return this.currentLearnedClass;
    }

    public double getCurrentActualClass() {
        return this.currentActualClass;
    }

    public void init() throws AbleException {
        this.reset();
        this.currentTrainRecord = 0;
        this.currentLearnedClass = 0.0;
        this.currentActualClass = 0.0;
        if (this.table == null) {
            this.table = new Vector();
        } else {
            this.table.removeAllElements();
        }
        this.inNum = new double[this.numAttributes];
        this.inputBuffer = this.inNum;
        this.outNum = new double[2];
        this.outputBuffer = this.outNum;
        this.currentTrainExample = new double[this.numAttributes];
        this.currentTestExample = new double[this.numAttributes];
        this.numAttributeValues = new int[this.numAttributes];
        this.numRecPerClass = new int[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.numRecPerClass[i] = 0;
        }
        this.priorClassProb = new double[this.numClasses];
        this.allTable = new Vector();
        super.init();
    }

    public void reset() throws AbleException {
        this.numCorrectTestExamples = 0;
        this.numTestExamples = 0;
        this.error = -1.0;
        this.accuracy = -1.0;
        this.setDefaults();
    }

    public int getMaxProbIndex(double[] dArray) {
        int n = 0;
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public AttributeValueClass getElement(Vector vector, int n, int n2, int n3) {
        AttributeValueClass attributeValueClass = null;
        for (int i = 0; i < vector.size(); ++i) {
            AttributeValueClass attributeValueClass2 = (AttributeValueClass)vector.elementAt(i);
            if (attributeValueClass2 == null || attributeValueClass2.getAttribute() != n || attributeValueClass2.getValue() != n2 || attributeValueClass2.getClasS() != n3) continue;
            attributeValueClass = attributeValueClass2;
            return attributeValueClass;
        }
        return attributeValueClass;
    }

    public double getClass(double[] dArray) throws AbleException {
        this.currentLearnedClass = 0.0;
        double[] dArray2 = new double[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            dArray2[i] = this.priorClassProb[i];
            for (int j = 0; j < this.numAttributes - 1; ++j) {
                int n = j + 1;
                int n2 = (int)dArray[j];
                AttributeValueClass attributeValueClass = this.getElement(this.allTable, n, n2, i + 1);
                if (attributeValueClass != null) {
                    int n3 = i;
                    dArray2[n3] = dArray2[n3] * attributeValueClass.getPosterior();
                    continue;
                }
                dArray2[i] = 0.0;
            }
        }
        this.currentLearnedClass = this.getMaxProbIndex(dArray2) + 1;
        return this.currentLearnedClass;
    }

    private int[] calcNumAttributeValues() throws AbleException {
        int[] nArray = new int[this.numAttributes];
        if (this.parent != null) {
            Vector vector = ((AbleAbstractImport)((AbleDefaultAgent)this.parent).getDataSource()).getFieldList();
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                AbleField ableField = (AbleField)vector.elementAt(i);
                if (ableField instanceof AbleCategoricalField) {
                    nArray[i] = ableField.getMap().size();
                    continue;
                }
                if (!(ableField instanceof AbleContinuousField)) continue;
                nArray[i] = this.discretization;
            }
        } else {
            return null;
        }
        return nArray;
    }

    public double[] calcPriorClassProb() throws AbleException {
        double[] dArray = new double[this.numClasses];
        Hashtable hashtable = null;
        if (this.parent != null) {
            Vector vector = ((AbleAbstractImport)((AbleDefaultAgent)this.parent).getDataSource()).getFieldList("output");
            if (vector.size() == 0) {
                return null;
            }
            AbleField ableField = (AbleField)vector.elementAt(0);
            hashtable = (Hashtable)ableField.getMap();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                dArray[Integer.valueOf((String)string).intValue() - 1] = 1.0 / (double)this.numClasses;
            }
        } else {
            return null;
        }
        return dArray;
    }

    public Vector setAllTable() throws AbleException {
        Vector<AttributeValueClass> vector = new Vector<AttributeValueClass>();
        if (this.parent != null) {
            Vector vector2 = ((AbleAbstractImport)((AbleDefaultAgent)this.parent).getDataSource()).getFieldList("output");
            if (vector2.size() == 0) {
                return null;
            }
            AbleField ableField = (AbleField)vector2.elementAt(vector2.size() - 1);
            Hashtable hashtable = (Hashtable)ableField.getMap();
            for (int i = 0; i < vector2.size() - 1; ++i) {
                AttributeValueClass attributeValueClass;
                int n;
                int n2;
                Object object;
                Object object2;
                Object object3;
                AbleField ableField2 = (AbleField)vector2.elementAt(i);
                if (ableField2 instanceof AbleCategoricalField) {
                    Hashtable hashtable2 = (Hashtable)ableField2.getMap();
                    object3 = hashtable2.elements();
                    while (object3.hasMoreElements()) {
                        object2 = (String)object3.nextElement();
                        object = hashtable.elements();
                        while (object.hasMoreElements()) {
                            int n3;
                            String string = (String)object.nextElement();
                            n2 = i + 1;
                            n = Integer.valueOf((String)object2);
                            attributeValueClass = new AttributeValueClass(n2, n, n3 = Integer.valueOf(string).intValue());
                            if (this.table.contains(attributeValueClass)) {
                                AttributeValueClass attributeValueClass2 = this.getElement(this.table, n2, n, n3);
                                attributeValueClass.setCount(attributeValueClass2.getCount());
                            }
                            vector.addElement(attributeValueClass);
                        }
                    }
                    continue;
                }
                if (!(ableField2 instanceof AbleContinuousField)) continue;
                for (int j = 0; j < this.discretization; ++j) {
                    object3 = String.valueOf(j + 1);
                    object2 = hashtable.elements();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        int n4 = i + 1;
                        n2 = Integer.valueOf((String)object3);
                        AttributeValueClass attributeValueClass3 = new AttributeValueClass(n4, n2, n = Integer.valueOf((String)object).intValue());
                        if (this.table.contains(attributeValueClass3)) {
                            attributeValueClass = this.getElement(this.table, n4, n2, n);
                            attributeValueClass3.setCount(attributeValueClass.getCount());
                        }
                        vector.addElement(attributeValueClass3);
                    }
                }
            }
        } else {
            return null;
        }
        return vector;
    }

    public void calcPriorProb() throws AbleException {
        for (int i = 0; i < this.allTable.size(); ++i) {
            AttributeValueClass attributeValueClass = (AttributeValueClass)this.allTable.elementAt(i);
            int n = attributeValueClass.getAttribute();
            double d = 1.0 / (double)this.numAttributeValues[n - 1];
            attributeValueClass.setPrior(d);
        }
    }

    public int getNumInstances(int n) {
        int n2 = 0;
        for (int i = 0; i < this.table.size(); ++i) {
            AttributeValueClass attributeValueClass = (AttributeValueClass)this.allTable.elementAt(i);
            if (attributeValueClass.getClasS() != n) continue;
            n2 += attributeValueClass.getCount();
        }
        return n2;
    }

    public void calcPosteriorProb() throws AbleException {
        for (int i = 0; i < this.allTable.size(); ++i) {
            AttributeValueClass attributeValueClass = (AttributeValueClass)this.allTable.elementAt(i);
            int n = attributeValueClass.getClasS();
            int n2 = attributeValueClass.getCount();
            double d = attributeValueClass.getPrior();
            int n3 = this.numRecPerClass[n - 1];
            double d2 = 0.0;
            if (n3 + this.m != 0) {
                d2 = ((double)n2 + (double)this.m * d) / (double)(n3 + this.m);
            }
            attributeValueClass.setPosterior(d2);
        }
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        if (this.naiveBayesMode == 0) {
            this.currentTrainExample = (double[])this.inputBuffer;
            int n = (int)this.currentTrainExample[this.currentTrainExample.length - 1];
            int n2 = n - 1;
            this.numRecPerClass[n2] = this.numRecPerClass[n2] + 1;
            for (int i = 0; i < this.numAttributes - 1; ++i) {
                AttributeValueClass attributeValueClass = new AttributeValueClass(i + 1, (int)this.currentTrainExample[i], (int)this.currentTrainExample[this.currentTrainExample.length - 1]);
                if (this.table.contains(attributeValueClass)) {
                    ((AttributeValueClass)this.table.elementAt(this.table.indexOf(attributeValueClass))).incrementCount();
                    continue;
                }
                attributeValueClass.incrementCount();
                this.table.addElement(attributeValueClass);
            }
            ++this.currentTrainRecord;
            if (this.numRecords == (long)this.currentTrainRecord) {
                this.numAttributeValues = this.calcNumAttributeValues();
                this.priorClassProb = this.calcPriorClassProb();
                this.allTable = this.setAllTable();
                this.calcPriorProb();
                this.calcPosteriorProb();
                this.naiveBayesMode = 1;
            }
        } else if (this.naiveBayesMode == 1) {
            this.currentTestExample = (double[])this.inputBuffer;
            this.currentLearnedClass = this.getClass(this.currentTestExample);
            this.currentActualClass = this.currentTestExample[this.numAttributes - 1];
            this.outNum[0] = this.currentLearnedClass;
            this.outNum[1] = this.currentActualClass;
            ++this.numTestExamples;
            if (this.currentLearnedClass == this.currentActualClass) {
                ++this.numCorrectTestExamples;
            }
            this.accuracy = 1.0 * (double)this.numCorrectTestExamples / (double)this.numTestExamples;
            this.error = 1.0 - this.accuracy;
        } else if (this.naiveBayesMode == 2) {
            this.currentTestExample = (double[])this.inputBuffer;
            this.currentLearnedClass = this.getClass(this.currentTestExample);
            this.currentActualClass = 0.0;
            this.outNum[0] = this.currentLearnedClass;
            this.outNum[1] = this.currentActualClass;
            ++this.numTestExamples;
        }
        this.dataChanged(this.outputBuffer);
    }

    public void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(this.getInputFilter(ableField));
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            AbleTranslateTemplate ableTranslateTemplate = this.getOutputFilter(ableField);
            ableFilter2.addTemplateRec(ableTranslateTemplate);
            AbleTranslateTemplate ableTranslateTemplate2 = (AbleTranslateTemplate)ableTranslateTemplate.clone();
            ableTranslateTemplate2.setUsage(1);
            ableTranslateTemplate2.setName(ableTranslateTemplate.getName() + "_target");
            ableFilter2.addTemplateRec(ableTranslateTemplate2);
        }
    }

    private AbleTranslateTemplate getInputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate;
        if (ableField instanceof AbleCategoricalField) {
            ableTranslateTemplate = new AbleTranslateTemplate(ableField.getName(), 0, 1, 2, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, (Hashtable)ableField.getMap(), "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else if (ableField instanceof AbleDiscreteField) {
            ableTranslateTemplate = new AbleTranslateTemplate(ableField.getName(), 0, 1, 2, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, (Hashtable)ableField.getMap(), "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else if (ableField instanceof AbleContinuousField) {
            ableTranslateTemplate = ableField.getInputTranslateTemplate();
            AbleContinuousField ableContinuousField = (AbleContinuousField)ableField;
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(38, new double[]{ableContinuousField.getMin(), ableContinuousField.getMax(), this.discretization});
            ableTranslateTemplate.setPreOperator(ableTranslateOperator);
            AbleTranslateOperator ableTranslateOperator2 = new AbleTranslateOperator(37, new double[]{1.0});
            ableTranslateTemplate.setPostOperator(ableTranslateOperator2);
        } else {
            ableTranslateTemplate = ableField.getInputTranslateTemplate();
        }
        if (ableField.getUsageString().equalsIgnoreCase("ignore")) {
            ableTranslateTemplate.setUsage(2);
        } else if (ableField.getUsageString().equalsIgnoreCase("output")) {
            ableTranslateTemplate.setUsage(1);
        }
        return ableTranslateTemplate;
    }

    private AbleTranslateTemplate getOutputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate = ableField.getOutputTranslateTemplate();
        if (ableField instanceof AbleCategoricalField || ableField instanceof AbleDiscreteField) {
            ableTranslateTemplate.setInLength(1);
            ableTranslateTemplate.setInType(1);
            ableTranslateTemplate.setPreOperator(new AbleTranslateOperator(24, null));
        }
        return ableTranslateTemplate;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

