/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.beans.filter.AbleTranslateTemplateProvider;
import com.ibm.able.beans.knn.AbleKnnClassifierAgent;
import com.ibm.able.beans.knn.JasKnnDistributedAgent;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleContinuousField;
import com.ibm.able.data.AbleDiscreteField;
import com.ibm.able.data.AbleField;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

class AbleKnnDistributed
extends AbleObject
implements AbleTranslateTemplateProvider,
Serializable {
    public static final String defaultName = "AbleKnnDistributed";
    static final long serialVersionUID = 1999100100000000001L;
    public static final int PropertyKId = 9001;
    public static final String PropertyK = "K";
    public double[] inNum;
    public double[] outNum;
    private int k = 1;
    private long numRecords = 0L;
    private int numAttributes = 0;
    private int numClasses = 0;
    private Vector model = null;
    private int numCorrectTestExamples = 0;
    private int numTestExamples = 0;
    private double error = -1.0;
    private double accuracy = -1.0;
    private int knnMode;
    public static final int TRAIN = 0;
    public static final int TEST = 1;
    public static final int RUN = 2;
    public static final String[] MODE_NAMES = new String[]{"Train", "Test", "Run"};
    private double[] currentTrainExample = null;
    private double[] currentTestExample = null;
    private double currentLearnedClass = 0.0;
    private double currentActualClass = 0.0;

    public double[] getInNum() {
        return this.inNum;
    }

    public double[] Num() {
        return this.outNum;
    }

    public AbleKnnDistributed() throws AbleException {
        super(defaultName);
    }

    public AbleKnnDistributed(String string) throws AbleException {
        super(string);
        this.setState(1026);
    }

    public AbleKnnDistributed(String string, int n) throws AbleException {
        super(string);
        this.setK(n);
        this.setDefaults();
    }

    protected void setDefaults() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public int getKnnMode() {
        return this.knnMode;
    }

    public void setKnnMode(int n) {
        this.knnMode = n;
    }

    public void setModelParameters(long l, int n, int n2) {
        this.numRecords = l;
        this.numAttributes = n;
        this.numClasses = n2;
    }

    public void setK(int n) throws AbleException {
        int n2 = this.k;
        this.k = n;
        this.chgSupport.firePropertyChange(PropertyK, new Integer(n2), new Integer(n));
    }

    public int getK() {
        return this.k;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public int getNumAttributes() {
        return this.numAttributes;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public long getNumTestExamples() {
        return this.numTestExamples;
    }

    public long getNumCorrectTestExamples() {
        return this.numCorrectTestExamples;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getError() {
        return this.error;
    }

    public double[] getCurrentTrainExample() {
        return this.currentTrainExample;
    }

    public double[] getCurrentTestExample() {
        return this.currentTestExample;
    }

    public double getCurrentLearnedClass() {
        return this.currentLearnedClass;
    }

    public double getCurrentActualClass() {
        return this.currentActualClass;
    }

    public Vector getModel() {
        return this.model;
    }

    public void init() throws AbleException {
        if (this.model == null) {
            this.model = new Vector();
        } else {
            this.model.removeAllElements();
        }
        if (this.trace.isLogging()) {
            String string = this.k + " " + this.numAttributes + " " + this.numClasses + " " + this.numRecords;
            this.trace.text(524288L, (Object)this, "init()", this.name + " agent, k-NN parameters = " + string);
        }
        this.inNum = new double[this.numAttributes];
        this.inputBuffer = this.inNum;
        this.outNum = new double[2];
        this.outputBuffer = this.outNum;
        this.currentTrainExample = new double[this.numAttributes];
        this.currentTestExample = new double[this.numAttributes];
        super.init();
    }

    public void reset() throws AbleException {
        this.numCorrectTestExamples = 0;
        this.numTestExamples = 0;
        this.error = -1.0;
        this.accuracy = -1.0;
        this.setDefaults();
    }

    public int getMinDistanceIndex(Vector vector) {
        int n = 0;
        double d = (Double)vector.elementAt(0);
        for (int i = 1; i < vector.size(); ++i) {
            if (!(d > (Double)vector.elementAt(i))) continue;
            d = (Double)vector.elementAt(i);
            n = i;
        }
        return n;
    }

    public Vector getKNN(double[] dArray) throws AbleException {
        Vector vector = new Vector();
        try {
            int n;
            Vector<Double> vector2 = new Vector<Double>();
            for (n = 0; n < this.model.size(); ++n) {
                vector2.addElement(new Double(this.computeDistance(dArray, (double[])this.model.elementAt(n))));
            }
            for (n = 0; n < this.k; ++n) {
                int n2 = this.getMinDistanceIndex(vector2);
                vector.addElement(this.model.elementAt(n2));
            }
        }
        catch (AbleException ableException) {
            // empty catch block
        }
        return vector;
    }

    public Hashtable calculateUniqueClassValues() throws AbleException {
        Hashtable hashtable;
        block5: {
            hashtable = new Hashtable();
            try {
                Vector vector;
                if (this.parent != null) {
                    vector = ((AbleKnnClassifierAgent)this.parent).getKnnImp1().getFieldList("output");
                    if (vector.size() == 0) {
                        return null;
                    }
                } else {
                    throw new AbleException("Bean has no parent.");
                }
                AbleField ableField = (AbleField)vector.elementAt(0);
                hashtable = (Hashtable)ableField.getMap();
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block5;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
        return hashtable;
    }

    public double computeDistance(double[] dArray, double[] dArray2) throws AbleException {
        double d;
        block6: {
            d = 0.0;
            try {
                if (this.parent != null) {
                    Vector vector = ((JasKnnDistributedAgent)this.parent).getKnnImp1().getFieldList();
                    if (vector.size() == 0) {
                        return 0.0;
                    }
                    for (int i = 0; i < dArray.length - 1; ++i) {
                        AbleField ableField = (AbleField)vector.elementAt(i);
                        if (ableField instanceof AbleContinuousField) {
                            d += Math.abs(dArray[i] - dArray2[i]);
                            continue;
                        }
                        if (dArray[i] == dArray2[i]) continue;
                        d += 1.0;
                    }
                    break block6;
                }
                throw new AbleException("Bean has no parent.");
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block6;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
        return d;
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        System.arraycopy((double[])this.inputBuffer, 0, this.currentTrainExample, 0, this.currentTrainExample.length);
        this.model.addElement(this.currentTrainExample.clone());
        this.dataChanged(this.outputBuffer);
    }

    public void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(this.getInputFilter(ableField));
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            AbleTranslateTemplate ableTranslateTemplate = this.getOutputFilter(ableField);
            ableFilter2.addTemplateRec(ableTranslateTemplate);
            AbleTranslateTemplate ableTranslateTemplate2 = (AbleTranslateTemplate)ableTranslateTemplate.clone();
            ableTranslateTemplate2.setUsage(1);
            ableTranslateTemplate2.setName(ableTranslateTemplate.getName() + "_target");
            ableFilter2.addTemplateRec(ableTranslateTemplate2);
        }
    }

    private AbleTranslateTemplate getInputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate;
        if (ableField instanceof AbleCategoricalField) {
            ableTranslateTemplate = new AbleTranslateTemplate(ableField.getName(), 0, 1, 2, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, (Hashtable)ableField.getMap(), "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else {
            ableTranslateTemplate = ableField instanceof AbleDiscreteField ? new AbleTranslateTemplate(ableField.getName(), 0, 1, 1, 1, 1, 1) : ableField.getInputTranslateTemplate();
        }
        if (ableField.getUsageString().equalsIgnoreCase("ignore")) {
            ableTranslateTemplate.setUsage(2);
        } else if (ableField.getUsageString().equalsIgnoreCase("output")) {
            ableTranslateTemplate.setUsage(1);
        }
        return ableTranslateTemplate;
    }

    private AbleTranslateTemplate getOutputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate = ableField.getOutputTranslateTemplate();
        if (ableField instanceof AbleCategoricalField) {
            ableTranslateTemplate.setInLength(1);
            ableTranslateTemplate.setInType(1);
            ableTranslateTemplate.setPreOperator(new AbleTranslateOperator(24, null));
        }
        return ableTranslateTemplate;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

