/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.beans.filter.AbleTranslateTemplateProvider;
import com.ibm.able.beans.knn.JasKnnCentralAgent;
import com.ibm.able.beans.knn.JasKnnDistributedAgent;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleContinuousField;
import com.ibm.able.data.AbleDiscreteField;
import com.ibm.able.data.AbleField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.Locator;

class AbleKnnCentral
extends AbleObject
implements AbleTranslateTemplateProvider,
Serializable {
    public static final String defaultName = "AbleKnnCentral";
    static final long serialVersionUID = 1999100100000000001L;
    public static final int PropertyKId = 9001;
    public static final String PropertyK = "K";
    public double[] inNum;
    public double[] outNum;
    private int k = 1;
    private long numRecords = 0L;
    private int numAttributes = 0;
    private int numClasses = 0;
    private Vector model = null;
    private int numCorrectTestExamples = 0;
    private int numTestExamples = 0;
    private double error = -1.0;
    private double accuracy = -1.0;
    private int knnMode;
    public static final int TRAIN = 0;
    public static final int TEST = 1;
    public static final int RUN = 2;
    public static final String[] MODE_NAMES = new String[]{"Train", "Test", "Run"};
    private double[] currentTrainExample = null;
    private double[] currentTestExample = null;
    private double currentLearnedClass = 0.0;
    private double currentActualClass = 0.0;

    public double[] getInNum() {
        return this.inNum;
    }

    public double[] Num() {
        return this.outNum;
    }

    public AbleKnnCentral() throws AbleException {
        super(defaultName);
    }

    public AbleKnnCentral(String string) throws AbleException {
        super(string);
        this.setState(1026);
    }

    public AbleKnnCentral(String string, int n) throws AbleException {
        super(string);
        this.setK(n);
        this.setDefaults();
    }

    protected void setDefaults() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public int getKnnMode() {
        return this.knnMode;
    }

    public void setKnnMode(int n) {
        this.knnMode = n;
    }

    public void setModelParameters(long l, int n, int n2) {
        this.numRecords = l;
        this.numAttributes = n;
        this.numClasses = n2;
    }

    public void setK(int n) throws AbleException {
        int n2 = this.k;
        this.k = n;
        this.chgSupport.firePropertyChange(PropertyK, new Integer(n2), new Integer(n));
    }

    public int getK() {
        return this.k;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public int getNumAttributes() {
        return this.numAttributes;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public long getNumTestExamples() {
        return this.numTestExamples;
    }

    public long getNumCorrectTestExamples() {
        return this.numCorrectTestExamples;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getError() {
        return this.error;
    }

    public double[] getCurrentTrainExample() {
        return this.currentTrainExample;
    }

    public double[] getCurrentTestExample() {
        return this.currentTestExample;
    }

    public double getCurrentLearnedClass() {
        return this.currentLearnedClass;
    }

    public double getCurrentActualClass() {
        return this.currentActualClass;
    }

    public void init() throws AbleException {
        this.error = -1.0;
        this.accuracy = -1.0;
        this.numTestExamples = 0;
        this.numCorrectTestExamples = 0;
        this.currentLearnedClass = 0.0;
        this.currentActualClass = 0.0;
        this.knnMode = 1;
        if (this.model == null) {
            this.model = new Vector();
        } else {
            this.model.removeAllElements();
        }
        this.inNum = new double[this.numAttributes];
        this.inputBuffer = this.inNum;
        this.outNum = new double[2];
        this.outputBuffer = this.outNum;
        this.currentTrainExample = new double[this.numAttributes];
        this.currentTestExample = new double[this.numAttributes];
        super.init();
    }

    public void reset() throws AbleException {
        this.numCorrectTestExamples = 0;
        this.numTestExamples = 0;
        this.error = -1.0;
        this.accuracy = -1.0;
        this.setDefaults();
    }

    private Hashtable calculateUniqueClassValues() throws AbleException {
        Hashtable hashtable;
        block5: {
            hashtable = new Hashtable();
            try {
                Vector vector;
                if (this.parent != null) {
                    vector = ((JasKnnCentralAgent)this.parent).getKnnImp2().getFieldList("output");
                    if (vector.size() == 0) {
                        return null;
                    }
                } else {
                    throw new AbleException("Bean has no parent.");
                }
                AbleField ableField = (AbleField)vector.elementAt(0);
                hashtable = (Hashtable)ableField.getMap();
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block5;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
        return hashtable;
    }

    private double computeDistance(double[] dArray, double[] dArray2) throws AbleException {
        double d;
        block6: {
            d = 0.0;
            try {
                if (this.parent != null) {
                    Vector vector = ((JasKnnCentralAgent)this.parent).getKnnImp2().getFieldList();
                    if (vector.size() == 0) {
                        return 0.0;
                    }
                    for (int i = 0; i < dArray.length - 1; ++i) {
                        AbleField ableField = (AbleField)vector.elementAt(i);
                        if (ableField instanceof AbleContinuousField) {
                            d += Math.abs(dArray[i] - dArray2[i]);
                            continue;
                        }
                        if (dArray[i] == dArray2[i]) continue;
                        d += 1.0;
                    }
                    break block6;
                }
                throw new AbleException("Bean has no parent.");
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block6;
                this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
            }
        }
        return d;
    }

    private int getMinDistanceIndex(Vector vector) {
        int n = 0;
        double d = (Double)vector.elementAt(0);
        for (int i = 1; i < vector.size(); ++i) {
            if (!(d > (Double)vector.elementAt(i))) continue;
            d = (Double)vector.elementAt(i);
            n = i;
        }
        return n;
    }

    private double getMajorityClass(Hashtable hashtable) {
        double d = 0.0;
        int n = -1;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = (Integer)hashtable.get(string);
            if (n >= n2) continue;
            n = n2;
            d = Double.valueOf(string);
        }
        return d;
    }

    private double getClass(double[] dArray) throws AbleException {
        try {
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Vector<Double> vector = new Vector<Double>();
            Hashtable hashtable2 = this.calculateUniqueClassValues();
            this.currentLearnedClass = 0.0;
            for (int i = 0; i < this.model.size(); ++i) {
                double d = this.computeDistance(dArray, (double[])this.model.elementAt(i));
                vector.addElement(new Double(d));
            }
            Enumeration enumeration = hashtable2.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(new String(string), new Integer(0));
            }
            for (int i = 0; i < this.k; ++i) {
                int n = this.getMinDistanceIndex(vector);
                double d = ((double[])this.model.elementAt(n))[this.numAttributes - 1];
                Enumeration enumeration2 = hashtable2.elements();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    Integer n2 = (Integer)hashtable.get(string);
                    int n3 = Integer.valueOf(string);
                    if ((double)n3 != d) continue;
                    int n4 = n2;
                    hashtable.put(string, new Integer(n4 + 1));
                }
            }
            this.currentLearnedClass = this.getMajorityClass(hashtable);
        }
        catch (AbleException ableException) {
            // empty catch block
        }
        return this.currentLearnedClass;
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        if (this.knnMode == 1) {
            block9: {
                System.arraycopy((double[])this.inputBuffer, 0, this.currentTestExample, 0, this.currentTestExample.length);
                try {
                    if (this.parent != null) {
                        int n;
                        JasKnnCentralAgent jasKnnCentralAgent = (JasKnnCentralAgent)this.parent;
                        JasKnnDistributedAgent jasKnnDistributedAgent = jasKnnCentralAgent.getLclJasKnnAgent1a();
                        JasKnnDistributedAgent jasKnnDistributedAgent2 = jasKnnCentralAgent.getLclJasKnnAgent2a();
                        AgentName agentName = jasKnnCentralAgent.getLclAgentName1();
                        AgentName agentName2 = jasKnnCentralAgent.getLclAgentName2();
                        Locator locator = jasKnnCentralAgent.getLclAbleDistrLocator1();
                        Locator locator2 = jasKnnCentralAgent.getLclAbleDistrLocator2();
                        Locator locator3 = jasKnnCentralAgent.getLclAbleMasterLocator1();
                        Locator locator4 = jasKnnCentralAgent.getLclAbleMasterLocator2();
                        jasKnnCentralAgent.sendTo(locator, agentName, this.currentTestExample);
                        jasKnnCentralAgent.sendTo(locator2, agentName2, this.currentTestExample);
                        Vector vector = jasKnnCentralAgent.getKnnModel1();
                        Vector vector2 = jasKnnCentralAgent.getKnnModel2();
                        for (n = 0; n < vector.size(); ++n) {
                            this.model.addElement(vector.elementAt(n));
                        }
                        for (n = 0; n < vector2.size(); ++n) {
                            this.model.addElement(vector2.elementAt(n));
                        }
                        break block9;
                    }
                    throw new AbleException("Able Knn Central Bean has no parent.");
                }
                catch (AbleException ableException) {
                    if (!this.trace.isLogging()) break block9;
                    this.trace.exception(262144L, (Object)this, "process", (Throwable)ableException);
                }
            }
            this.currentLearnedClass = this.getClass(this.currentTestExample);
            this.currentActualClass = this.currentTestExample[this.numAttributes - 1];
            this.outNum[0] = this.currentLearnedClass;
            this.outNum[1] = this.currentActualClass;
            ++this.numTestExamples;
            if (this.currentLearnedClass == this.currentActualClass) {
                ++this.numCorrectTestExamples;
            }
            this.accuracy = 1.0 * (double)this.numCorrectTestExamples / (double)this.numTestExamples;
            this.error = 1.0 - this.accuracy;
        } else if (this.knnMode == 2) {
            System.arraycopy((double[])this.inputBuffer, 0, this.currentTestExample, 0, this.currentTestExample.length);
            this.currentLearnedClass = this.getClass(this.currentTestExample);
            this.currentActualClass = 0.0;
            this.outNum[0] = this.currentLearnedClass;
            this.outNum[1] = this.currentActualClass;
            ++this.numTestExamples;
        }
        this.dataChanged(this.outputBuffer);
    }

    public void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(this.getInputFilter(ableField));
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            AbleTranslateTemplate ableTranslateTemplate = this.getOutputFilter(ableField);
            ableFilter2.addTemplateRec(ableTranslateTemplate);
            AbleTranslateTemplate ableTranslateTemplate2 = (AbleTranslateTemplate)ableTranslateTemplate.clone();
            ableTranslateTemplate2.setUsage(1);
            ableTranslateTemplate2.setName(ableTranslateTemplate.getName() + "_target");
            ableFilter2.addTemplateRec(ableTranslateTemplate2);
        }
    }

    private AbleTranslateTemplate getInputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate;
        if (ableField instanceof AbleCategoricalField) {
            ableTranslateTemplate = new AbleTranslateTemplate(ableField.getName(), 0, 1, 2, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, (Hashtable)ableField.getMap(), "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else {
            ableTranslateTemplate = ableField instanceof AbleDiscreteField ? new AbleTranslateTemplate(ableField.getName(), 0, 1, 1, 1, 1, 1) : ableField.getInputTranslateTemplate();
        }
        if (ableField.getUsageString().equalsIgnoreCase("ignore")) {
            ableTranslateTemplate.setUsage(2);
        } else if (ableField.getUsageString().equalsIgnoreCase("output")) {
            ableTranslateTemplate.setUsage(1);
        }
        return ableTranslateTemplate;
    }

    private AbleTranslateTemplate getOutputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate = ableField.getOutputTranslateTemplate();
        if (ableField instanceof AbleCategoricalField) {
            ableTranslateTemplate.setInLength(1);
            ableTranslateTemplate.setInType(1);
            ableTranslateTemplate.setPreOperator(new AbleTranslateOperator(24, null));
        }
        return ableTranslateTemplate;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

