/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleX;
import com.ibm.able.beans.AbleAbstractImport;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.beans.filter.AbleTranslateTemplateProvider;
import com.ibm.able.beans.knn.NodeAttrValClass;
import com.ibm.able.beans.knn.TreeNode;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleContinuousField;
import com.ibm.able.data.AbleDiscreteField;
import com.ibm.able.data.AbleField;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AbleDecisionTree
extends AbleObject
implements AbleTranslateTemplateProvider,
Serializable {
    public static final String defaultName = AbleX.NlsMsg("DFLT_NAME_DecisionTree2");
    static final long serialVersionUID = 1999100100000000001L;
    public static final int PropertyMetricId = 9002;
    public static final String PropertyMetric = "Metric";
    public static final int PropertyDiscrId = 9003;
    public static final String PropertyDiscr = "Discretization";
    static final short MIN_EXAMPLES_NODE = 3;
    public double[] inNum;
    public double[] outNum;
    private int decisionTreeMode;
    public static final int TRAIN = 0;
    public static final int TEST = 1;
    public static final int RUN = 2;
    public static final String[] MODE_NAMES = new String[]{"Train", "Test", "Run"};
    private long numRecords = 0L;
    private int numAttributes = 0;
    private int numClasses = 0;
    private Vector table = null;
    private TreeNode root = null;
    boolean[] testedAttributes;
    private int metric = 0;
    private int discretization = 10;
    private int numCorrectTestExamples = 0;
    private int numTestExamples = 0;
    private int currentTrainRecord = 0;
    private double error = -1.0;
    private double accuracy = -1.0;
    private int[] numAttributeValues = null;
    private Vector currentLevel = null;
    private Vector nextLevel = null;
    private Vector tree = null;
    private int nodeIndex = 0;
    private double[] currentTrainExample = null;
    private double[] currentTestExample = null;
    private double currentLearnedClass = 0.0;
    private double currentActualClass = 0.0;

    public double[] getInNum() {
        return this.inNum;
    }

    public double[] getOutNum() {
        return this.outNum;
    }

    public AbleDecisionTree() throws AbleException {
        super(defaultName);
    }

    public AbleDecisionTree(String string) throws AbleException {
        super(string);
        this.setState(1026);
    }

    public AbleDecisionTree(String string, int n, int n2) throws AbleException {
        super(string);
        this.setMetric(n);
        this.setDiscretization(n2);
        this.setDefaults();
    }

    protected void setDefaults() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public int getDecisionTreeMode() {
        return this.decisionTreeMode;
    }

    public void setDecisionTreeMode(int n) {
        this.decisionTreeMode = n;
    }

    public void setDecisionTreeParameters(int n, int n2, long l) {
        this.numAttributes = n;
        this.numClasses = n2;
        this.numRecords = l;
    }

    public void setMetric(int n) throws AbleException {
        int n2 = this.metric;
        this.metric = n;
        this.chgSupport.firePropertyChange(PropertyMetric, new Integer(n2), new Integer(n));
    }

    public int getMetric() {
        return this.metric;
    }

    public void setDiscretization(int n) throws AbleException {
        int n2 = this.discretization;
        this.discretization = n;
        this.chgSupport.firePropertyChange(PropertyDiscr, new Integer(n2), new Integer(n));
    }

    public int getDiscretization() {
        return this.discretization;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public int getNumAttributes() {
        return this.numAttributes;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public long getNumTestExamples() {
        return this.numTestExamples;
    }

    public long getNumCorrectTestExamples() {
        return this.numCorrectTestExamples;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getError() {
        return this.error;
    }

    public double[] getCurrentTrainExample() {
        return this.currentTrainExample;
    }

    public double[] getCurrentTestExample() {
        return this.currentTestExample;
    }

    public double getCurrentLearnedClass() {
        return this.currentLearnedClass;
    }

    public double getCurrentActualClass() {
        return this.currentActualClass;
    }

    public double getCurrentTrainRecord() {
        return this.currentTrainRecord;
    }

    public void init() throws AbleException {
        this.reset();
        this.currentTrainRecord = 0;
        this.currentLearnedClass = 0.0;
        this.currentActualClass = 0.0;
        if (this.table == null) {
            this.table = new Vector();
        } else {
            this.table.removeAllElements();
        }
        if (this.currentLevel == null) {
            this.currentLevel = new Vector();
        } else {
            this.currentLevel.removeAllElements();
        }
        if (this.nextLevel == null) {
            this.nextLevel = new Vector();
        } else {
            this.nextLevel.removeAllElements();
        }
        if (this.tree == null) {
            this.tree = new Vector();
        } else {
            this.tree.removeAllElements();
        }
        if (this.trace.isLogging()) {
            String string = this.metric + " " + this.discretization + " " + this.numAttributes + " " + this.numClasses + " " + this.numRecords;
            this.trace.text(524288L, (Object)this, "init()", this.name + " agent, decision tree parameters = " + string);
        }
        this.inNum = new double[this.numAttributes];
        this.inputBuffer = this.inNum;
        this.outNum = new double[2];
        this.outputBuffer = this.outNum;
        this.currentTrainExample = new double[this.numAttributes];
        this.currentTestExample = new double[this.numAttributes];
        this.numAttributeValues = this.calcNumAttributeValues();
        this.testedAttributes = new boolean[this.numAttributes];
        for (int i = 0; i < this.numAttributes; ++i) {
            this.testedAttributes[i] = false;
        }
        this.root = new TreeNode();
        this.root.classDistribution = new int[this.numClasses];
        this.currentLevel.addElement(this.root);
        this.tree.addElement(this.root);
        super.init();
    }

    public void reset() throws AbleException {
        this.numCorrectTestExamples = 0;
        this.numTestExamples = 0;
        this.error = -1.0;
        this.accuracy = -1.0;
        this.setDefaults();
    }

    public void resetTable() throws AbleException {
        this.table.removeAllElements();
    }

    private int[] calcNumAttributeValues() throws AbleException {
        int[] nArray = new int[this.numAttributes];
        if (this.parent != null) {
            Vector vector = ((AbleAbstractImport)((AbleDefaultAgent)this.parent).getDataSource()).getFieldList();
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                AbleField ableField = (AbleField)vector.elementAt(i);
                if (ableField instanceof AbleCategoricalField) {
                    nArray[i] = ableField.getMap().size();
                    continue;
                }
                if (!(ableField instanceof AbleContinuousField)) continue;
                nArray[i] = this.discretization;
            }
        } else {
            return null;
        }
        return nArray;
    }

    private int getNumInstances(TreeNode treeNode, int n, int n2, Vector vector) {
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            NodeAttrValClass nodeAttrValClass = (NodeAttrValClass)vector.elementAt(i);
            if (nodeAttrValClass.getNode() != treeNode || nodeAttrValClass.getAttribute() != n || nodeAttrValClass.getValue() != n2) continue;
            n3 += nodeAttrValClass.getCount();
        }
        return n3;
    }

    private int getNumInstances(TreeNode treeNode, int n, int n2, int n3, Vector vector) {
        int n4 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            NodeAttrValClass nodeAttrValClass = (NodeAttrValClass)vector.elementAt(i);
            if (nodeAttrValClass.getNode() != treeNode || nodeAttrValClass.getAttribute() != n || nodeAttrValClass.getValue() != n2 || nodeAttrValClass.getClasS() != n3) continue;
            n4 += nodeAttrValClass.getCount();
        }
        return n4;
    }

    private int selectBestAttribute(TreeNode treeNode) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.numAttributes - 1; ++i) {
            if (this.testedAttributes[i]) continue;
            switch (this.metric) {
                case 0: {
                    d2 = this.gainRatio(treeNode, i, treeNode.classDistribution, this.table);
                    break;
                }
                case 1: {
                    d2 = this.chiSquare();
                    break;
                }
                case 2: {
                    d2 = this.laplace();
                    break;
                }
                case 3: {
                    d2 = this.gini();
                    break;
                }
                case 4: {
                    d2 = this.relief();
                    break;
                }
                case 5: {
                    d2 = this.contextInfo();
                    break;
                }
                case 6: {
                    d2 = this.intraInterDist();
                }
            }
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        if (d == 0.0) {
            return -1;
        }
        return n;
    }

    private int sampleSize(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    private void expandNode(TreeNode treeNode, int[] nArray) {
        int n;
        ++this.nodeIndex;
        treeNode.index = this.nodeIndex;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.numClasses; ++n) {
            if (nArray[n] <= nArray[n2]) continue;
            n2 = n;
        }
        n3 = nArray[n2];
        treeNode.noClasses = this.numClasses;
        treeNode.size = this.sampleSize(nArray);
        treeNode.majClass = n2;
        if (this.sampleSize(nArray) < 3 || this.sampleSize(nArray) == n3) {
            treeNode.type = 0;
        }
        if (treeNode.type != 0) {
            treeNode.selectAttribute = this.selectBestAttribute(treeNode);
            if (treeNode.selectAttribute == -1) {
                treeNode.type = 0;
            }
        }
        if (treeNode.type != 0) {
            treeNode.branch = new TreeNode[this.numAttributeValues[treeNode.selectAttribute]];
            for (n = 0; n < this.numAttributeValues[treeNode.selectAttribute]; ++n) {
                treeNode.branch[n] = new TreeNode();
                treeNode.branch[n].type = 1;
                this.tree.addElement(treeNode.branch[n]);
                treeNode.branch[n].classDistribution = new int[this.numClasses];
            }
            for (n = 0; n < this.numAttributeValues[treeNode.selectAttribute]; ++n) {
                this.nextLevel.addElement(treeNode.branch[n]);
            }
        }
    }

    private TreeNode getTreeNode(TreeNode treeNode) {
        for (int i = 0; i < this.tree.size(); ++i) {
            if (((TreeNode)this.tree.elementAt(i)).getIndex() != treeNode.getIndex()) continue;
            return (TreeNode)this.tree.elementAt(i);
        }
        return null;
    }

    private void generateLevel(Vector vector) {
        TreeNode treeNode;
        int n;
        for (n = 0; n < this.currentLevel.size(); ++n) {
            treeNode = (TreeNode)this.currentLevel.elementAt(n);
            this.expandNode(treeNode, treeNode.classDistribution);
        }
        for (n = 0; n < this.currentLevel.size(); ++n) {
            treeNode = (TreeNode)this.currentLevel.elementAt(n);
            if (treeNode.type != 1) continue;
            this.testedAttributes[treeNode.selectAttribute] = true;
        }
        if (this.nextLevel != null && this.nextLevel.size() != 0) {
            this.currentLevel.removeAllElements();
            this.currentLevel = (Vector)this.nextLevel.clone();
            this.nextLevel.removeAllElements();
        }
    }

    private double gainRatio(TreeNode treeNode, int n, int[] nArray, Vector vector) {
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.sampleSize(nArray);
        for (n2 = 0; n2 < this.numClasses; ++n2) {
            d -= (double)nArray[n2] / d4 * this.log2((double)nArray[n2] / d4);
        }
        for (n2 = 0; n2 < this.numAttributeValues[n]; ++n2) {
            double d5 = this.getNumInstances(treeNode, n + 1, n2 + 1, vector);
            if (d5 == 0.0) continue;
            double d6 = 0.0;
            for (int i = 0; i < this.numClasses; ++i) {
                d6 -= (double)this.getNumInstances(treeNode, n + 1, n2 + 1, i + 1, vector) / d5 * this.log2((double)this.getNumInstances(treeNode, n + 1, n2 + 1, i + 1, vector) / d5);
            }
            d2 += d5 / d4 * d6;
        }
        for (n2 = 0; n2 < this.numAttributeValues[n]; ++n2) {
            d3 -= (double)this.getNumInstances(treeNode, n + 1, n2 + 1, vector) / d4 * this.log2((double)this.getNumInstances(treeNode, n + 1, n2 + 1, vector) / d4);
        }
        if (d3 != 0.0) {
            return (d - d2) / d3;
        }
        return d - d2;
    }

    private float chiSquare() {
        return 1.0f;
    }

    private float gini() {
        return 1.0f;
    }

    private float laplace() {
        return 1.0f;
    }

    private float relief() {
        return 1.0f;
    }

    private float contextInfo() {
        return 1.0f;
    }

    private float intraInterDist() {
        return 1.0f;
    }

    private double log2(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return (float)(Math.log(d) / 0.6931471805599453);
    }

    private double getClass(double[] dArray, TreeNode treeNode) {
        switch (treeNode.type) {
            case 0: {
                return (short)treeNode.majClass + 1;
            }
            case 1: {
                if (dArray[treeNode.selectAttribute] - 1.0 >= (double)treeNode.branch.length) {
                    System.out.println("assignClass(example, node.branch[example[node.selectFeat]])");
                    System.out.println("index Error!");
                    System.out.println("example[node.selectFeat] = " + dArray[treeNode.selectAttribute]);
                    return (short)treeNode.majClass;
                }
                return this.getClass(dArray, treeNode.branch[(int)dArray[treeNode.selectAttribute] - 1]);
            }
        }
        return 0.0;
    }

    private boolean containsNode(Vector vector, TreeNode treeNode) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (((TreeNode)vector.elementAt(i)).getIndex() != treeNode.getIndex()) continue;
            bl = true;
        }
        return bl;
    }

    private TreeNode findNodeInTree(double[] dArray, TreeNode treeNode) {
        TreeNode treeNode2 = null;
        if (treeNode != null) {
            TreeNode treeNode3 = new TreeNode();
            treeNode3 = (TreeNode)treeNode.clone();
            while (treeNode3 != null && !this.containsNode(this.currentLevel, treeNode3)) {
                treeNode2 = (TreeNode)treeNode3.clone();
                if (treeNode3.branch != null) {
                    treeNode3 = treeNode3.branch[(int)dArray[treeNode3.selectAttribute] - 1];
                    continue;
                }
                treeNode3 = null;
            }
        }
        return treeNode2;
    }

    private boolean treeBuilt() {
        boolean bl = true;
        if (this.currentLevel != null) {
            for (int i = 0; i < this.currentLevel.size(); ++i) {
                if (((TreeNode)this.currentLevel.elementAt((int)i)).type == 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        if (this.decisionTreeMode == 0) {
            this.currentTrainExample = (double[])this.inputBuffer;
            int n = (int)this.currentTrainExample[this.currentTrainExample.length - 1];
            TreeNode treeNode = this.findNodeInTree(this.currentTrainExample, this.root);
            if (treeNode != null && treeNode.type != 0) {
                TreeNode treeNode2 = this.getTreeNode(treeNode);
                for (int i = 0; i < this.numAttributeValues[treeNode2.selectAttribute]; ++i) {
                    if (this.currentTrainExample[treeNode2.selectAttribute] != (double)(i + 1)) continue;
                    int n2 = n - 1;
                    treeNode2.branch[i].classDistribution[n2] = treeNode2.branch[i].classDistribution[n2] + 1;
                }
            } else if (treeNode == null) {
                int n3 = n - 1;
                this.root.classDistribution[n3] = this.root.classDistribution[n3] + 1;
            }
            if (treeNode != null && treeNode.type != 0) {
                for (int i = 0; i < this.numAttributes - 1; ++i) {
                    if (this.testedAttributes[i]) continue;
                    TreeNode treeNode3 = this.getTreeNode(treeNode);
                    TreeNode treeNode4 = null;
                    treeNode4 = treeNode3.branch[(int)this.currentTrainExample[treeNode3.selectAttribute] - 1];
                    NodeAttrValClass nodeAttrValClass = new NodeAttrValClass(treeNode4, i + 1, (int)this.currentTrainExample[i], (int)this.currentTrainExample[this.currentTrainExample.length - 1]);
                    if (this.table.contains(nodeAttrValClass)) {
                        ((NodeAttrValClass)this.table.elementAt(this.table.indexOf(nodeAttrValClass))).incrementCount();
                        continue;
                    }
                    nodeAttrValClass.incrementCount();
                    this.table.addElement(nodeAttrValClass);
                }
            } else if (treeNode == null) {
                for (int i = 0; i < this.numAttributes - 1; ++i) {
                    NodeAttrValClass nodeAttrValClass = new NodeAttrValClass(this.root, i + 1, (int)this.currentTrainExample[i], (int)this.currentTrainExample[this.currentTrainExample.length - 1]);
                    if (this.table.contains(nodeAttrValClass)) {
                        ((NodeAttrValClass)this.table.elementAt(this.table.indexOf(nodeAttrValClass))).incrementCount();
                        continue;
                    }
                    nodeAttrValClass.incrementCount();
                    this.table.addElement(nodeAttrValClass);
                }
            }
            ++this.currentTrainRecord;
            if (this.numRecords == (long)this.currentTrainRecord) {
                this.generateLevel(this.table);
                if (this.treeBuilt()) {
                    this.decisionTreeMode = 1;
                } else {
                    this.resetTable();
                    this.currentTrainRecord = 0;
                }
            }
        } else if (this.decisionTreeMode == 1) {
            this.currentTestExample = (double[])this.inputBuffer;
            this.currentLearnedClass = this.getClass(this.currentTestExample, this.root);
            this.currentActualClass = this.currentTestExample[this.numAttributes - 1];
            this.outNum[0] = this.currentLearnedClass;
            this.outNum[1] = this.currentActualClass;
            ++this.numTestExamples;
            if (this.currentLearnedClass == this.currentActualClass) {
                ++this.numCorrectTestExamples;
            }
            this.accuracy = 1.0 * (double)this.numCorrectTestExamples / (double)this.numTestExamples;
            this.error = 1.0 - this.accuracy;
        } else if (this.decisionTreeMode == 2) {
            this.currentTestExample = (double[])this.inputBuffer;
            this.currentLearnedClass = this.getClass(this.currentTestExample, this.root);
            this.currentActualClass = 0.0;
            this.outNum[0] = this.currentLearnedClass;
            this.outNum[1] = this.currentActualClass;
            ++this.numTestExamples;
        }
        this.dataChanged(this.outputBuffer);
    }

    public void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(this.getInputFilter(ableField));
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            AbleTranslateTemplate ableTranslateTemplate = this.getOutputFilter(ableField);
            ableFilter2.addTemplateRec(ableTranslateTemplate);
            AbleTranslateTemplate ableTranslateTemplate2 = (AbleTranslateTemplate)ableTranslateTemplate.clone();
            ableTranslateTemplate2.setUsage(1);
            ableTranslateTemplate2.setName(ableTranslateTemplate.getName() + "_target");
            ableFilter2.addTemplateRec(ableTranslateTemplate2);
        }
    }

    private AbleTranslateTemplate getInputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate;
        if (ableField instanceof AbleCategoricalField) {
            ableTranslateTemplate = new AbleTranslateTemplate(ableField.getName(), 0, 1, 2, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, (Hashtable)ableField.getMap(), "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else if (ableField instanceof AbleDiscreteField) {
            ableTranslateTemplate = new AbleTranslateTemplate(ableField.getName(), 0, 1, 2, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, (Hashtable)ableField.getMap(), "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else if (ableField instanceof AbleContinuousField) {
            ableTranslateTemplate = ableField.getInputTranslateTemplate();
            AbleContinuousField ableContinuousField = (AbleContinuousField)ableField;
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(38, new double[]{ableContinuousField.getMin(), ableContinuousField.getMax(), this.discretization});
            ableTranslateTemplate.setPreOperator(ableTranslateOperator);
            AbleTranslateOperator ableTranslateOperator2 = new AbleTranslateOperator(37, new double[]{1.0});
            ableTranslateTemplate.setPostOperator(ableTranslateOperator2);
        } else {
            ableTranslateTemplate = ableField.getInputTranslateTemplate();
        }
        if (ableField.getUsageString().equalsIgnoreCase("ignore")) {
            ableTranslateTemplate.setUsage(2);
        } else if (ableField.getUsageString().equalsIgnoreCase("output")) {
            ableTranslateTemplate.setUsage(1);
        }
        return ableTranslateTemplate;
    }

    private AbleTranslateTemplate getOutputFilter(AbleField ableField) {
        AbleTranslateTemplate ableTranslateTemplate = ableField.getOutputTranslateTemplate();
        if (ableField instanceof AbleCategoricalField || ableField instanceof AbleDiscreteField) {
            ableTranslateTemplate.setInLength(1);
            ableTranslateTemplate.setInType(1);
            ableTranslateTemplate.setPreOperator(new AbleTranslateOperator(24, null));
        }
        return ableTranslateTemplate;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

