/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.filter;

import com.ibm.able.beans.filter.AbleFilter;
import java.io.Serializable;
import java.util.Hashtable;

public class AbleTranslateOperator
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1999100100000000001L;
    private int operCode;
    private int numItems = 0;
    private double[] opData;
    private Hashtable dict;
    private boolean caseSensitive;
    private String defaultOutSymbol;
    private double VectorSum;

    public AbleTranslateOperator() {
    }

    public AbleTranslateOperator(int n, double[] dArray) {
        this.operCode = n;
        this.opData = dArray;
        if (this.opData != null) {
            this.numItems = this.opData.length;
        }
    }

    public AbleTranslateOperator(int n, Hashtable hashtable, String string, boolean bl) {
        this.operCode = n;
        this.dict = hashtable;
        this.numItems = this.dict.size();
        this.defaultOutSymbol = string;
        this.caseSensitive = bl;
    }

    public AbleTranslateOperator(AbleTranslateOperator ableTranslateOperator) {
        AbleTranslateOperator ableTranslateOperator2 = (AbleTranslateOperator)ableTranslateOperator.clone();
        this.operCode = ableTranslateOperator2.operCode;
        this.dict = ableTranslateOperator2.dict;
        this.numItems = ableTranslateOperator2.numItems;
        this.defaultOutSymbol = ableTranslateOperator2.defaultOutSymbol;
        this.caseSensitive = ableTranslateOperator2.caseSensitive;
        this.opData = ableTranslateOperator2.opData;
    }

    public Object clone() {
        try {
            AbleTranslateOperator ableTranslateOperator = (AbleTranslateOperator)super.clone();
            ableTranslateOperator.operCode = this.operCode;
            ableTranslateOperator.dict = this.dict == null ? null : (Hashtable)this.dict.clone();
            ableTranslateOperator.numItems = this.numItems;
            ableTranslateOperator.defaultOutSymbol = this.defaultOutSymbol == null ? null : new String(this.defaultOutSymbol);
            ableTranslateOperator.caseSensitive = this.caseSensitive;
            if (this.opData == null) {
                this.opData = null;
            } else {
                ableTranslateOperator.opData = (double[])this.opData.clone();
            }
            return ableTranslateOperator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static int lookupCode(String string) {
        String[] stringArray = AbleFilter.operatorTypeStrings;
        if (string == stringArray[20]) {
            return 20;
        }
        if (string == stringArray[25]) {
            return 25;
        }
        if (string == stringArray[33]) {
            return 33;
        }
        if (string == stringArray[30]) {
            return 30;
        }
        if (string == stringArray[34]) {
            return 34;
        }
        if (string == stringArray[0]) {
            return 0;
        }
        if (string == stringArray[1]) {
            return 1;
        }
        if (string == stringArray[2]) {
            return 2;
        }
        if (string == stringArray[3]) {
            return 3;
        }
        if (string == stringArray[4]) {
            return 4;
        }
        if (string == stringArray[5]) {
            return 5;
        }
        if (string == stringArray[6]) {
            return 6;
        }
        if (string == stringArray[7]) {
            return 7;
        }
        if (string == stringArray[8]) {
            return 8;
        }
        if (string == stringArray[9]) {
            return 9;
        }
        if (string == stringArray[10]) {
            return 10;
        }
        if (string == stringArray[11]) {
            return 11;
        }
        if (string == stringArray[12]) {
            return 12;
        }
        if (string == stringArray[40]) {
            return 40;
        }
        if (string == stringArray[41]) {
            return 41;
        }
        if (string == stringArray[13]) {
            return 13;
        }
        if (string == stringArray[14]) {
            return 14;
        }
        if (string == stringArray[15]) {
            return 15;
        }
        if (string == stringArray[16]) {
            return 16;
        }
        if (string == stringArray[17]) {
            return 17;
        }
        if (string == stringArray[18]) {
            return 18;
        }
        if (string == stringArray[19]) {
            return 19;
        }
        if (string == stringArray[21]) {
            return 21;
        }
        if (string == stringArray[22]) {
            return 22;
        }
        if (string == stringArray[23]) {
            return 23;
        }
        if (string == stringArray[24]) {
            return 24;
        }
        if (string == stringArray[26]) {
            return 26;
        }
        if (string == stringArray[27]) {
            return 27;
        }
        if (string == stringArray[29]) {
            return 29;
        }
        if (string == stringArray[28]) {
            return 28;
        }
        if (string == stringArray[31]) {
            return 31;
        }
        if (string == stringArray[32]) {
            return 32;
        }
        if (string == stringArray[35]) {
            return 35;
        }
        if (string == stringArray[36]) {
            return 36;
        }
        if (string == stringArray[37]) {
            return 37;
        }
        if (string == stringArray[38]) {
            return 38;
        }
        return 20;
    }

    public int getOperCode() {
        return this.operCode;
    }

    public String getOperString() {
        return AbleFilter.operatorTypeStrings[this.operCode];
    }

    public int getNumItems() {
        return this.numItems;
    }

    public double[] getOpData() {
        return this.opData;
    }

    public Hashtable getDict() {
        return this.dict;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public String getDefaultOutSymbol() {
        return this.defaultOutSymbol;
    }

    public void setOperCode(int n) {
        this.operCode = n;
    }

    public void setOperCode(String string) {
        this.operCode = AbleTranslateOperator.lookupCode(string);
    }

    public void setNumItems(int n) {
        this.numItems = n;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setDefaultOutSymbol(String string) {
        this.defaultOutSymbol = string;
    }

    void clearDict() {
        this.dict = new Hashtable();
    }

    public double executeOperator(double d) {
        double d2 = 0.0;
        if (this.operCode == 20) {
            d2 = d;
            return 0.0;
        }
        block0 : switch (this.operCode) {
            case 0: {
                d2 = Math.abs(d);
                break;
            }
            case 1: {
                if (d > 1.0 || d < -1.0) {
                    d2 = 0.0;
                    break;
                }
                d2 = Math.acos(d);
                break;
            }
            case 2: {
                if (d > 1.0 || d < -1.0) {
                    d2 = 0.0;
                    break;
                }
                d2 = Math.asin(d);
                break;
            }
            case 3: {
                d2 = Math.atan(d);
                break;
            }
            case 4: {
                d2 = (long)d & (long)this.opData[0];
                break;
            }
            case 5: {
                d2 = (long)d | (long)this.opData[0];
                break;
            }
            case 6: {
                d2 = (long)d ^ (long)this.opData[0];
                break;
            }
            case 39: {
                d2 = (long)d ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 7: {
                d2 = Math.ceil(d);
                break;
            }
            case 8: {
                d2 = Math.cos(d);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                if (this.opData[0] == 0.0) break;
                d2 = (long)(d / this.opData[0]);
                break;
            }
            case 11: {
                d2 = Math.exp(d);
                break;
            }
            case 12: {
                d2 = Math.pow(10.0, d);
                break;
            }
            case 40: {
                d2 = Math.pow(d, this.opData[0]);
                break;
            }
            case 41: {
                d2 = Math.pow(this.opData[0], d);
                break;
            }
            case 13: {
                d2 = Math.floor(d);
                break;
            }
            case 14: {
                if (d <= 0.0) break;
                d2 = Math.log(d);
                break;
            }
            case 15: {
                if (d <= 0.0) break;
                d2 = Math.log(d) / Math.log(10.0);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                d2 = (long)d % (long)this.opData[0];
                break;
            }
            case 21: {
                this.VectorSum += d;
                d2 = d;
                break;
            }
            case 22: {
                this.VectorSum += d * d;
                d2 = d;
                break;
            }
            case 23: {
                if (Math.abs(d) > this.VectorSum) {
                    this.VectorSum = Math.abs(d);
                }
                d2 = d;
                break;
            }
            case 24: {
                d2 = Math.round(d);
                break;
            }
            case 25: {
                double d3 = 1.0;
                if (d <= this.opData[0]) {
                    d2 = this.opData[3];
                    break;
                }
                if (d >= this.opData[2]) {
                    d2 = this.opData[5];
                    break;
                }
                if (d > this.opData[0] && d < this.opData[1]) {
                    double d4 = this.opData[1] - this.opData[0];
                    double d5 = this.opData[4] - this.opData[3];
                    if (d4 != 0.0) {
                        d3 = d5 / d4;
                    }
                    d2 = this.opData[3] + (d - this.opData[0]) * d3;
                    break;
                }
                if (!(d >= this.opData[1]) || !(d < this.opData[2])) break;
                double d6 = this.opData[2] - this.opData[1];
                double d7 = this.opData[5] - this.opData[4];
                if (d6 != 0.0) {
                    d3 = d7 / d6;
                }
                d2 = this.opData[4] + (d - this.opData[1]) * d3;
                break;
            }
            case 26: {
                d2 = Math.sin(d);
                break;
            }
            case 27: {
                break;
            }
            case 29: {
                d2 = d * d;
                break;
            }
            case 28: {
                if (d < 0.0) break;
                d2 = Math.sqrt(d);
                break;
            }
            case 31: {
                d2 = Math.tan(d);
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                d2 = d;
                for (int n = 0; n < this.numItems - 2; n = (int)((short)(n + 3))) {
                    if (!(d > this.opData[n]) || !(d <= this.opData[n + 1])) continue;
                    d2 = this.opData[n + 2];
                    break block0;
                }
                break;
            }
            case 35: {
                d2 = (long)d;
                break;
            }
            case 37: {
                d2 = d + this.opData[0];
                break;
            }
            case 38: {
                if (this.opData[1] == 0.0) break;
                double d8 = this.opData[1];
                double d9 = this.opData[0];
                double d10 = this.opData[2];
                double d11 = (d8 - d9) / d10;
                double d12 = d11 > 0.0 ? (d - d9) / d11 : 0.0;
                if (d12 == d10) {
                    d12 -= 1.0;
                }
                d2 = (int)d12;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return d2;
    }

    public String executeSymOperator(String string) {
        String string2 = string;
        String string3 = null;
        switch (this.operCode) {
            case 30: 
            case 34: {
                string3 = this.getDefaultOutSymbol();
                if (this.getCaseSensitive()) {
                    if (!this.dict.containsKey(string)) break;
                    string3 = (String)this.dict.get(string);
                    break;
                }
                if (!this.dict.containsKey(string2.toUpperCase())) break;
                string3 = (String)this.dict.get(string2.toUpperCase());
                break;
            }
            case 36: {
                string3 = string2.toUpperCase();
                break;
            }
            case 16: {
                string3 = string2.toLowerCase();
            }
        }
        return string3;
    }

    static String lookupOperString(int n) {
        if (n >= 0 && n < 42) {
            return AbleFilter.operatorTypeStrings[n];
        }
        return AbleFilter.NULLSTR;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

