/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.filter;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleDoubleVariable;
import com.ibm.able.data.AbleField;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleStringVariable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AbleFilter
extends AbleObject
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    static final String XLTVERSION = "V3R1M00594";
    static final String XLTPREVER = "V2R2M01292";
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_Filter");
    static final String NULLSTR = Able.NlsMsg((String)"NULL");
    public static final int NUMUSAGETYPES = 3;
    public static final int NUMLOGICALTYPES = 6;
    public static final int NUMOPERATORTYPES = 42;
    public static final int NUMSTATUSSTRINGS = 10;
    public static final int ADDTOEND = 0;
    static int PREOP = 0;
    static int CONVTABLE = 1;
    static int POSTOP = 2;
    public static final int Able_FILT_OPERATOR_ERROR = 1000;
    public static final int Able_FILT_INVALID_INDEX = 1001;
    public static final int Able_FILT_INVALID_SYMBOLIC_INPUT_INDEX = 1002;
    public static final int Able_FILT_NOTANUMBER = 1003;
    public static final int Able_FILT_INVALID_NUMERIC_INPUT_INDEX = 1004;
    public static final int Able_FILT_READ_IO = 1005;
    public static final int Able_FILT_WRITE_IO = 1006;
    public static final int SYMBOLIC = 0;
    public static final int NUMERIC = 1;
    public static final int XINPUT = 0;
    public static final int XOUTPUT = 1;
    public static final int XIGNORE = 2;
    public static final int XEDIT = 0;
    public static final int XINBUFPOS = 1;
    public static final int XOUTPUFPOS = 2;
    public static final int XDIALOG = 3;
    boolean TestMode = false;
    public static final int XBINCODE = 0;
    public static final int XNUMBER = 1;
    public static final int XSYMBOL = 2;
    public static final int XTHERMCODE = 3;
    public static final int XONEOFNCODE = 4;
    public static final int XVECTOR = 5;
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int BITAND = 4;
    public static final int BITOR = 5;
    public static final int BITXOR = 6;
    public static final int CEIL = 7;
    public static final int COS = 8;
    public static final int COSH = 9;
    public static final int DIV = 10;
    public static final int EXP = 11;
    public static final int EXP10 = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int LOWCASE = 16;
    public static final int MAXUV = 17;
    public static final int MINUV = 18;
    public static final int MODULO = 19;
    public static final int NONE = 20;
    public static final int NORM1 = 21;
    public static final int NORM2 = 22;
    public static final int NORM3 = 23;
    public static final int ROUND = 24;
    public static final int SCALE = 25;
    public static final int SIN = 26;
    public static final int SINH = 27;
    public static final int SQRT = 28;
    public static final int SQUARE = 29;
    public static final int TABLE = 30;
    public static final int TAN = 31;
    public static final int TANH = 32;
    public static final int THRESHOLD = 33;
    public static final int TRANSLATE = 34;
    public static final int TRUNC = 35;
    public static final int UPCASE = 36;
    public static final int ADD = 37;
    public static final int DISCRETIZE = 38;
    public static final int BITCOMP = 39;
    public static final int POW = 40;
    public static final int POWERN = 41;
    static final String[] dataTypeStrings = new String[]{"BinaryCode", "Number", "Symbol", "ThermCode", "OneOfNCode", "Vector"};
    static final String[] shortDataTypeStrings = new String[]{"BinCode", "Number", "Symbol", "Therm", "OneOfN", "Vector"};
    static final String[] operatorTypeStrings = new String[]{"Abs", "Acos", "Asin", "Atan", "Bit-AND", "Bit-OR", "Bit-XOR", "Ceiling", "Cos", "Cosh", "Div", "Exp", "Exp10", "Floor", "Log", "Log10", "Lowercase", "Max", "Min", "Modulo", "None", "Norm-L1", "Norm-L2", "Norm-Max", "Round", "Scale", "Sin", "Sinh", "Squareroot", "Square", "Table", "Tan", "Tanh", "Threshold", "Translate", "Truncate", "Uppercase", "Add", "Discretize", "Bit-COMP", "Power", "PowerN"};
    static Vector implementedOperators = new Vector();
    static final String[] usageTypeStrings;
    static final String[] statusStrings;
    public static final int[] typeList;
    public static final int[] binCodeOperList;
    public static final int[] numberOperList;
    public static final int[] symbolOperList;
    public static final int[] thermCodeOperList;
    public static final int[] oneOfNCodeOperList;
    public static final int[] oneOfNCodePostOperList;
    public static final int[] vectorOperList;
    double[] tmpInNum;
    double[] tmpOutNum;
    double[] inNum;
    double[] outNum;
    String[] tmpInSym;
    String[] tmpOutSym;
    String[] inSym;
    String[] outSym;
    String version;
    int totalInUnits;
    int totalOutUnits;
    int numInFields;
    int numSymInUnits;
    int numInUnits;
    int numOutFields;
    int numSymOutUnits;
    int numOutUnits;
    Vector table = new Vector();
    int tokenInx = 0;
    protected Object altInputBuffer = null;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$D;

    public AbleFilter() throws AbleException {
        this(defaultName);
    }

    public AbleFilter(String string) throws AbleException {
        super(string);
        this.reset();
    }

    public static void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(ableField.getInputTranslateTemplate());
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            ableFilter2.addTemplateRec(ableField.getOutputTranslateTemplate());
        }
    }

    public void reset() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(true);
    }

    String[] getTmpInSym() {
        return this.tmpInSym;
    }

    String getTmpInSym(int n) {
        return this.tmpInSym[n];
    }

    String[] getTmpOutSym() {
        return this.tmpOutSym;
    }

    String getTmpOutSym(int n) {
        return this.tmpOutSym[n];
    }

    double[] getTmpInNum() {
        return this.tmpInNum;
    }

    double getTmpInNum(int n) {
        return this.tmpInNum[n];
    }

    double[] getTmpOutNum() {
        return this.tmpOutNum;
    }

    double getTmpOutNum(int n) {
        return this.tmpOutNum[n];
    }

    double[] getInNum() {
        return this.inNum;
    }

    double[] getOutNum() {
        return this.outNum;
    }

    public String getVersion() {
        return this.version;
    }

    public int getTotalInUnits() {
        return this.totalInUnits;
    }

    public int getTotalOutUnits() {
        return this.totalOutUnits;
    }

    public int getNumInFields() {
        return this.numInFields;
    }

    public int getNumSymInUnits() {
        return this.numSymInUnits;
    }

    public int getNumInUnits() {
        return this.numInUnits;
    }

    public int getNumOutFields() {
        return this.numOutFields;
    }

    public int getNumSymOutUnits() {
        return this.numSymOutUnits;
    }

    public int getNumOutUnits() {
        return this.numOutUnits;
    }

    public int getNumNumericInUnits() {
        return this.totalInUnits - this.numSymInUnits;
    }

    public int getNumNumericOutUnits() {
        return this.totalOutUnits - this.numSymOutUnits;
    }

    public Vector getTable() {
        return this.table;
    }

    public AbleTranslateTemplate getTemplateRec(int n) {
        return (AbleTranslateTemplate)this.table.elementAt(n);
    }

    public AbleTranslateTemplate getTemplateRec(String string) {
        for (int i = 0; i < this.table.size(); ++i) {
            AbleTranslateTemplate ableTranslateTemplate = (AbleTranslateTemplate)this.table.elementAt(i);
            if (!ableTranslateTemplate.getName().equals(string)) continue;
            return ableTranslateTemplate;
        }
        return null;
    }

    String[] getInSym() {
        return this.inSym;
    }

    String[] getOutSym() {
        return this.outSym;
    }

    int getTokenInx() {
        return this.tokenInx;
    }

    void setTmpInSym(int n, String string) {
        this.tmpInSym[n] = string;
    }

    void setTmpInSym(String[] stringArray) {
        this.tmpInSym = stringArray;
    }

    void setTmpOutSym(int n, String string) {
        this.tmpOutSym[n] = string;
    }

    void setVersion(String string) {
        this.version = string;
    }

    void clearTable() {
        this.table.removeAllElements();
        this.update();
    }

    double getNextNumber() {
        double d = 0.0;
        d = this.inNum != null ? this.inNum[this.tokenInx++] : Double.valueOf(this.inSym[this.tokenInx++]);
        return d;
    }

    void putNextSymbol(int n) {
    }

    void putNextNumber(int n, int n2) {
    }

    int getNumFields() {
        return this.numInFields + this.numOutFields;
    }

    public void addTemplateRec(AbleTranslateTemplate ableTranslateTemplate) {
        this.table.addElement(ableTranslateTemplate);
        this.update();
        ableTranslateTemplate.setFilter(this);
    }

    public void addTemplateRecs(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            AbleTranslateTemplate ableTranslateTemplate = (AbleTranslateTemplate)vector.elementAt(i);
            ableTranslateTemplate.setFilter(this);
        }
        this.table = vector;
        this.update();
    }

    public void insertTemplateRec(AbleTranslateTemplate ableTranslateTemplate, int n) {
        if (n < 0 || n > this.table.size()) {
            this.table.addElement(ableTranslateTemplate);
        } else {
            this.table.insertElementAt(ableTranslateTemplate, n);
        }
        this.update();
        ableTranslateTemplate.setFilter(this);
    }

    public void removeTemplateRec(int n) {
        this.table.removeElementAt(n);
        this.update();
    }

    public void removeAllTemplateRecs() {
        for (int i = this.table.size() - 1; i >= 0; --i) {
            this.table.removeElementAt(i);
        }
        this.update();
    }

    String[] getDataTypes() {
        return dataTypeStrings;
    }

    static AbleTranslateOperator getDefaultOperRec(String string) {
        AbleTranslateOperator ableTranslateOperator = null;
        int n = AbleTranslateOperator.lookupCode(string);
        switch (n) {
            case 7: 
            case 10: 
            case 13: 
            case 19: 
            case 24: 
            case 37: {
                ableTranslateOperator = new AbleTranslateOperator(n, new double[]{1.0});
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                ableTranslateOperator = new AbleTranslateOperator(n, new double[]{255.0});
                break;
            }
            case 25: {
                ableTranslateOperator = new AbleTranslateOperator(n, new double[]{0.0, 0.5, 1.0, 0.0, 0.5, 1.0});
                break;
            }
            case 33: {
                ableTranslateOperator = new AbleTranslateOperator(n, new double[0]);
                break;
            }
            case 30: 
            case 34: {
                ableTranslateOperator = new AbleTranslateOperator(n, new Hashtable(), "0", true);
                break;
            }
            case 38: {
                ableTranslateOperator = new AbleTranslateOperator(n, new double[]{0.0, 100.0, 10.0});
            }
        }
        return ableTranslateOperator;
    }

    public String getFieldNames() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.table.size(); ++i) {
            stringBuffer.append(((AbleTranslateTemplate)this.table.elementAt(i)).getName() + " ");
        }
        return stringBuffer.toString().trim();
    }

    public String[] getFieldNamesArray() {
        String[] stringArray = new String[this.table.size()];
        for (int i = 0; i < this.table.size(); ++i) {
            stringArray[i] = ((AbleTranslateTemplate)this.table.elementAt(i)).getName();
        }
        return stringArray;
    }

    int[] getIndexByOutBufPos() {
        int n = this.table.size();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = this.numInFields;
        int n4 = this.numInFields + this.numOutFields;
        for (int i = 0; i < n; ++i) {
            if (((AbleTranslateTemplate)this.table.elementAt(i)).getUsage() == 0) {
                nArray[n2++] = i;
                continue;
            }
            if (((AbleTranslateTemplate)this.table.elementAt(i)).getUsage() == 1) {
                nArray[n3++] = i;
                continue;
            }
            nArray[n4++] = i;
        }
        return nArray;
    }

    String getNextSymbol() {
        if (this.inSym.length < this.tokenInx) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
            this.logger.text(4L, (Object)this, "getNextSymbol", arrayIndexOutOfBoundsException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "getNextSymbol", (Throwable)arrayIndexOutOfBoundsException);
            }
            return null;
        }
        return this.inSym[this.tokenInx++];
    }

    public String[] getStatusInfo() {
        String[] stringArray = new String[3];
        int n = this.table.size() - (this.numInFields + this.numOutFields);
        int n2 = this.totalInUnits - this.numSymInUnits;
        int n3 = this.totalOutUnits - this.numSymOutUnits;
        stringArray[0] = statusStrings[0] + String.valueOf(this.table.size()) + " " + statusStrings[1] + String.valueOf(this.numInFields) + " " + statusStrings[2] + String.valueOf(this.numOutFields) + " " + statusStrings[3] + String.valueOf(n);
        stringArray[1] = statusStrings[4] + String.valueOf(this.totalInUnits) + " " + statusStrings[5] + String.valueOf(n2) + " " + statusStrings[6] + String.valueOf(this.numSymInUnits);
        stringArray[2] = statusStrings[7] + String.valueOf(this.totalOutUnits) + " " + statusStrings[8] + String.valueOf(n3) + " " + statusStrings[9] + String.valueOf(this.numSymOutUnits);
        return stringArray;
    }

    public static String[] getValidOpers(String string) {
        int n = 0;
        int[] nArray = null;
        String[] stringArray = null;
        int n2 = AbleTranslateTemplate.lookupType(string);
        switch (n2) {
            case 0: {
                nArray = binCodeOperList;
                break;
            }
            case 1: {
                nArray = numberOperList;
                break;
            }
            case 2: {
                nArray = symbolOperList;
                break;
            }
            case 3: {
                nArray = thermCodeOperList;
                break;
            }
            case 4: {
                nArray = oneOfNCodeOperList;
                break;
            }
            case 5: {
                nArray = vectorOperList;
                break;
            }
            default: {
                if (!Able.TraceLog.isLogging()) break;
                Able.TraceLog.text(262144L, (Object)"com.ibm.able.AbleFilter", "getValidOpers", "Source dataType <" + string + "> unknown.");
            }
        }
        n = nArray.length;
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = operatorTypeStrings[nArray[i]];
        }
        return stringArray;
    }

    public String[] getValidTypes(String string) {
        int n;
        int n2 = 0;
        int[] nArray = new int[6];
        String[] stringArray = null;
        int n3 = AbleTranslateTemplate.lookupType(string);
        switch (n3) {
            case 0: 
            case 3: 
            case 4: {
                n2 = 6;
                for (n = 0; n < n2; ++n) {
                    nArray[n] = typeList[n];
                }
                break;
            }
            case 1: 
            case 2: {
                n2 = 5;
                for (n = 0; n < n2; ++n) {
                    nArray[n] = typeList[n];
                }
                break;
            }
            case 5: {
                n2 = 4;
                for (n = 0; n < n2; ++n) {
                    nArray[n] = typeList[n];
                }
                nArray[3] = 5;
                break;
            }
            default: {
                if (!this.trace.isLogging()) break;
                this.trace.text(262144L, (Object)this, "getValidTypes", "Source dataType <" + string + "> unknown.");
            }
        }
        stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = dataTypeStrings[nArray[n]];
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void process() throws AbleException {
        AbleTranslateTemplate ableTranslateTemplate;
        block16: {
            boolean bl;
            block17: {
                ableTranslateTemplate = null;
                if (this.changed) {
                    this.update();
                }
                bl = this.trace.isLogging();
                if (this.altInputBuffer == null) break block17;
                if (this.altInputBuffer.getClass() == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleFilter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                    this.inSym = (String[])this.altInputBuffer;
                    break block16;
                } else if (this.altInputBuffer.getClass() == (array$D == null ? (array$D = AbleFilter.class$("[D")) : array$D)) {
                    this.inNum = (double[])this.altInputBuffer;
                    break block16;
                } else {
                    String string = Able.NlsMsg((String)"Ex_BuffUnsupportedType", (Object[])new Object[]{this.altInputBuffer.getClass()});
                    if (bl) {
                        this.trace.text(262144L, (Object)this, "process()", string);
                    }
                    throw new AbleException(string);
                }
            }
            this.processBufferConnections();
            if (this.inputBuffer.getClass() == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleFilter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                this.inSym = (String[])this.inputBuffer;
            } else if (this.inputBuffer.getClass() == (array$D == null ? (array$D = AbleFilter.class$("[D")) : array$D)) {
                this.inNum = (double[])this.inputBuffer;
            } else {
                String string = Able.NlsMsg((String)"Ex_BuffUnsupportedType", (Object[])new Object[]{this.inputBuffer.getClass()});
                if (bl) {
                    this.trace.text(262144L, (Object)this, "process()", string);
                }
                throw new AbleException(string);
            }
        }
        if (this.numSymInUnits != 0) {
            // empty if block
        }
        this.tokenInx = 0;
        for (int i = 0; i < this.table.size(); ++i) {
            ableTranslateTemplate = (AbleTranslateTemplate)this.table.elementAt(i);
            if (ableTranslateTemplate.getUsage() == 2) {
                ableTranslateTemplate.ignore();
                continue;
            }
            ableTranslateTemplate.process();
        }
        if (this.numSymOutUnits == 0) {
            this.outputBuffer = this.tmpOutNum;
        } else {
            this.writeOutputToBuffer();
        }
        this.dataChanged(this.outputBuffer);
    }

    public Object process(Object stringArray) throws AbleException {
        Object object;
        boolean bl = this.trace.isLogging();
        String[] stringArray2 = stringArray;
        if (stringArray instanceof Object[]) {
            object = stringArray;
            String[] stringArray3 = new String[((Object[])object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                if (object2 instanceof String) {
                    stringArray3[i] = (String)object2;
                    continue;
                }
                if (object2 instanceof AbleStringLiteral) {
                    stringArray3[i] = ((AbleStringLiteral)object2).getStringValue();
                    continue;
                }
                if (object2 instanceof AbleStringVariable) {
                    stringArray3[i] = ((AbleStringVariable)object2).getStringValue();
                    continue;
                }
                if (object2 instanceof AbleDoubleLiteral) {
                    stringArray3[i] = ((AbleDoubleLiteral)object2).getStringValue();
                    continue;
                }
                if (!(object2 instanceof AbleDoubleVariable)) continue;
                stringArray3[i] = ((AbleDoubleVariable)object2).getStringValue();
            }
            stringArray2 = stringArray3;
        } else if (stringArray instanceof Vector) {
            object = (Vector)stringArray;
            String[] stringArray4 = new String[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Object e = ((Vector)object).get(i);
                if (e instanceof String) {
                    stringArray4[i] = (String)e;
                    continue;
                }
                if (e instanceof AbleStringLiteral) {
                    stringArray4[i] = ((AbleStringLiteral)e).getStringValue();
                    continue;
                }
                if (e instanceof AbleStringVariable) {
                    stringArray4[i] = ((AbleStringVariable)e).getStringValue();
                    continue;
                }
                if (e instanceof AbleDoubleLiteral) {
                    stringArray4[i] = ((AbleDoubleLiteral)e).getStringValue();
                    continue;
                }
                if (!(e instanceof AbleDoubleVariable)) continue;
                stringArray4[i] = ((AbleDoubleVariable)e).getStringValue();
            }
            stringArray2 = stringArray4;
        } else if (stringArray instanceof String[] || stringArray instanceof double[]) {
            stringArray2 = stringArray;
        } else {
            String string = Able.NlsMsg((String)"Ex_RsProcessArgWrongType");
            if (bl) {
                this.trace.text(262144L, (Object)this, "process(Object)", string);
            }
            throw new AbleException(string);
        }
        this.altInputBuffer = stringArray2;
        try {
            this.process();
            this.altInputBuffer = null;
        }
        catch (AbleException ableException) {
            this.altInputBuffer = null;
            throw ableException;
        }
        object = null;
        if (this.outputBuffer instanceof String[]) {
            object = ((String[])this.outputBuffer).clone();
        }
        if (this.outputBuffer instanceof double[]) {
            object = ((double[])this.outputBuffer).clone();
        }
        return object;
    }

    public String[] testTemplate(int n, String[] stringArray) {
        return null;
    }

    public void update() {
        block26: {
            AbleTranslateTemplate ableTranslateTemplate;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            this.numInUnits = 0;
            this.numInFields = 0;
            this.numOutUnits = 0;
            this.numOutFields = 0;
            this.totalInUnits = 0;
            this.totalOutUnits = 0;
            this.numSymInUnits = 0;
            this.numSymOutUnits = 0;
            for (int i = 0; i < this.table.size(); ++i) {
                ableTranslateTemplate = (AbleTranslateTemplate)this.table.elementAt(i);
                ableTranslateTemplate.setInBufPos(n);
                n += ableTranslateTemplate.getInLength() * ableTranslateTemplate.getNumRepeats();
                switch (ableTranslateTemplate.getUsage()) {
                    case 0: {
                        ableTranslateTemplate.setOutBufPos(n2);
                        n2 += ableTranslateTemplate.getOutLength() * ableTranslateTemplate.getNumRepeats();
                        this.numInUnits += ableTranslateTemplate.getOutLength() * ableTranslateTemplate.getNumRepeats();
                        ++this.numInFields;
                        if (ableTranslateTemplate.getInType() == 2) {
                            ableTranslateTemplate.setTmpInBufPos(n3);
                            n3 += ableTranslateTemplate.getNumRepeats();
                        } else {
                            ableTranslateTemplate.setTmpInBufPos(n4);
                            n4 += ableTranslateTemplate.getInLength() * ableTranslateTemplate.getNumRepeats();
                        }
                        if (ableTranslateTemplate.getOutType() == 2) {
                            ableTranslateTemplate.setTmpOutBufPos(n5);
                            n5 += ableTranslateTemplate.getNumRepeats();
                            this.numSymOutUnits += ableTranslateTemplate.getNumRepeats();
                            break;
                        }
                        ableTranslateTemplate.setTmpOutBufPos(n6);
                        n6 += ableTranslateTemplate.getOutLength() * ableTranslateTemplate.getNumRepeats();
                        break;
                    }
                    case 1: {
                        this.numOutUnits += ableTranslateTemplate.getOutLength() * ableTranslateTemplate.getNumRepeats();
                        ++this.numOutFields;
                        if (ableTranslateTemplate.getInType() == 2) {
                            ableTranslateTemplate.setTmpInBufPos(n3);
                            n3 += ableTranslateTemplate.getNumRepeats();
                            break;
                        }
                        ableTranslateTemplate.setTmpInBufPos(n4);
                        n4 += ableTranslateTemplate.getInLength() * ableTranslateTemplate.getNumRepeats();
                        break;
                    }
                }
                this.totalInUnits += ableTranslateTemplate.getInLength() * ableTranslateTemplate.getNumRepeats();
                if (ableTranslateTemplate.getInType() != 2) continue;
                this.numSymInUnits += ableTranslateTemplate.getNumRepeats();
            }
            this.totalOutUnits = this.numInUnits + this.numOutUnits;
            for (int i = 0; i < this.table.size(); ++i) {
                ableTranslateTemplate = (AbleTranslateTemplate)this.table.elementAt(i);
                if (ableTranslateTemplate.getUsage() != 1) continue;
                ableTranslateTemplate.setOutBufPos(n2);
                n2 += ableTranslateTemplate.getOutLength() * ableTranslateTemplate.getNumRepeats();
                if (ableTranslateTemplate.getOutType() == 2) {
                    ableTranslateTemplate.setTmpOutBufPos(n5);
                    n5 += ableTranslateTemplate.getNumRepeats();
                    this.numSymOutUnits += ableTranslateTemplate.getNumRepeats();
                    continue;
                }
                ableTranslateTemplate.setTmpOutBufPos(n6);
                n6 += ableTranslateTemplate.getOutLength() * ableTranslateTemplate.getNumRepeats();
            }
            if (this.numSymInUnits == 0) {
                this.inSym = null;
                if (this.inputBuffer instanceof double[] && ((double[])this.inputBuffer).length == this.totalInUnits) {
                    this.inNum = (double[])this.inputBuffer;
                } else {
                    this.inNum = new double[this.totalInUnits];
                    this.inputBuffer = this.inNum;
                }
                this.tmpInNum = new double[this.totalInUnits];
                this.tmpInSym = null;
            } else {
                this.inNum = null;
                if (this.inputBuffer instanceof String[] && ((String[])this.inputBuffer).length == this.totalInUnits) {
                    this.inSym = (String[])this.inputBuffer;
                } else {
                    this.inputBuffer = this.inSym = new String[this.totalInUnits];
                }
                this.tmpInNum = new double[this.totalInUnits];
                this.tmpInSym = new String[this.totalInUnits];
            }
            if (this.numSymOutUnits == 0) {
                this.outSym = null;
                if (this.outputBuffer instanceof double[] && ((double[])this.outputBuffer).length == this.totalOutUnits) {
                    this.outNum = (double[])this.outputBuffer;
                } else {
                    this.outNum = new double[this.totalOutUnits];
                    this.outputBuffer = this.outNum;
                }
                this.tmpOutNum = this.outNum;
                this.tmpOutSym = null;
            } else {
                this.outNum = null;
                if (this.outputBuffer instanceof String[] && ((String[])this.outputBuffer).length == this.totalOutUnits) {
                    this.outSym = (String[])this.outputBuffer;
                } else {
                    this.outputBuffer = this.outSym = new String[this.totalOutUnits];
                }
                this.tmpOutNum = new double[this.totalOutUnits];
                this.tmpOutSym = new String[this.totalOutUnits];
            }
            this.changed = false;
            try {
                if (this.getState() == 1026) {
                    this.init();
                }
            }
            catch (AbleException ableException) {
                if (!this.trace.isLogging()) break block26;
                this.trace.exception(262144L, (Object)this, "update", (Throwable)ableException);
            }
        }
    }

    void writeOutputToBuffer() {
        int n = this.table.size();
        int n2 = 0;
        int n3 = 0;
        if (this.numSymOutUnits != 0) {
            int[] nArray = this.getIndexByOutBufPos();
            for (int i = 0; i < n; ++i) {
                AbleTranslateTemplate ableTranslateTemplate = (AbleTranslateTemplate)this.table.elementAt(nArray[i]);
                if (ableTranslateTemplate.getUsage() == 2) continue;
                n3 = ableTranslateTemplate.getTmpOutBufPos();
                for (int j = 0; j < ableTranslateTemplate.getNumRepeats(); ++j) {
                    for (int k = 0; k < ableTranslateTemplate.getOutLength(); ++k) {
                        if (ableTranslateTemplate.getOutType() == 2) {
                            this.outSym[n2++] = this.tmpOutSym[n3++];
                            continue;
                        }
                        this.outSym[n2++] = String.valueOf(this.tmpOutNum[n3++]);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.table.size(); ++i) {
                AbleTranslateTemplate ableTranslateTemplate = (AbleTranslateTemplate)this.table.elementAt(i);
                if (ableTranslateTemplate.getUsage() == 2) continue;
                n3 = ableTranslateTemplate.getTmpOutBufPos();
                int n4 = ableTranslateTemplate.getNumRepeats();
                int n5 = ableTranslateTemplate.getOutLength();
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n5; ++k) {
                        this.outNum[n2++] = this.tmpOutNum[n3++];
                    }
                }
            }
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        implementedOperators.addElement("Abs");
        implementedOperators.addElement("Acos");
        implementedOperators.addElement("Asin");
        implementedOperators.addElement("Atan");
        implementedOperators.addElement("Bit-AND");
        implementedOperators.addElement("Bit-OR");
        implementedOperators.addElement("Bit-XOR");
        implementedOperators.addElement("Ceiling");
        implementedOperators.addElement("Cos");
        implementedOperators.addElement("Div");
        implementedOperators.addElement("Exp");
        implementedOperators.addElement("Exp10");
        implementedOperators.addElement("Floor");
        implementedOperators.addElement("Log");
        implementedOperators.addElement("Log10");
        implementedOperators.addElement("Lowercase");
        implementedOperators.addElement("Max");
        implementedOperators.addElement("Min");
        implementedOperators.addElement("Modulo");
        implementedOperators.addElement("None");
        implementedOperators.addElement("Round");
        implementedOperators.addElement("Scale");
        implementedOperators.addElement("Sin");
        implementedOperators.addElement("Squareroot");
        implementedOperators.addElement("Square");
        implementedOperators.addElement("Table");
        implementedOperators.addElement("Tan");
        implementedOperators.addElement("Threshold");
        implementedOperators.addElement("Translate");
        implementedOperators.addElement("Truncate");
        implementedOperators.addElement("Uppercase");
        implementedOperators.addElement("Add");
        implementedOperators.addElement("Discretize");
        implementedOperators.addElement("Bit-COMP");
        implementedOperators.addElement("Power");
        implementedOperators.addElement("PowerN");
        usageTypeStrings = new String[]{"Input", "Output", "Ignore"};
        statusStrings = new String[]{"Fields:", "In:", "Out:", "Ignore:", "InBuf:", "Num:", "Sym:", "OutBuf:", "Num:", "Sym:"};
        typeList = new int[]{0, 4, 3, 1, 2, 5};
        binCodeOperList = new int[]{20, 0, 24, 25, 33, 35, 19, 10, 4, 5, 6, 39};
        numberOperList = new int[]{20, 0, 37, 10, 7, 13, 19, 24, 25, 33, 35, 38, 11, 12, 14, 15, 40, 41, 29, 28, 26, 8, 31, 2, 1, 3, 27, 9, 32, 4, 5, 6, 39};
        symbolOperList = new int[]{20, 16, 34, 36};
        thermCodeOperList = new int[]{20, 0, 10, 19, 24, 25, 33, 35, 4, 5, 6, 39};
        oneOfNCodeOperList = new int[]{20, 0, 10, 19, 24, 25, 33, 35, 17, 18, 4, 5, 6, 39};
        oneOfNCodePostOperList = new int[]{20, 0, 10, 19, 24, 25, 33, 35, 4, 5, 6, 39};
        vectorOperList = new int[]{20, 0, 10, 7, 13, 19, 24, 25, 33, 35, 11, 12, 14, 15, 40, 41, 29, 28, 26, 8, 31, 2, 1, 3, 27, 9, 32, 4, 5, 6, 39, 21, 22, 23};
    }
}

