/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.decisiontree;

import com.ibm.able.beans.decisiontree.Data;
import com.ibm.able.beans.decisiontree.EvaluationMetric;
import com.ibm.able.beans.decisiontree.TreeNode;

public class TreeStructure {
    static final short MIN_EXAMPLES_NODE = 3;
    TreeNode root;
    Data data;
    boolean[] testedFeats;

    TreeStructure(Data data) {
        this.data = data;
    }

    public TreeNode buildTree() {
        this.testedFeats = new boolean[this.data.noFeats];
        for (int i = 0; i < this.data.noFeats; ++i) {
            this.testedFeats[i] = false;
        }
        this.root = this.generateTree(0, this.data.noTrainExamples);
        return this.root;
    }

    public TreeNode generateTree(int n, int n2) {
        int n3;
        int[] nArray = new int[this.data.noClasses];
        for (n3 = 0; n3 < this.data.noClasses; ++n3) {
            nArray[n3] = 0;
        }
        for (int i = n; i < n2; ++i) {
            short s = this.data.valsTrainClass[i];
            nArray[s] = nArray[s] + 1;
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.data.noClasses; ++n3) {
            if (nArray[n3] <= nArray[n4]) continue;
            n4 = n3;
        }
        int n5 = nArray[n4];
        int n6 = n2 - n;
        TreeNode treeNode = new TreeNode(n4, n5, n6, n6 - n5);
        if (n6 < 3 || n6 == n5) {
            treeNode.type = 0;
            return treeNode;
        }
        EvaluationMetric evaluationMetric = new EvaluationMetric(this.data);
        treeNode.selectFeat = evaluationMetric.selectBestFeat(n, n2, this.testedFeats);
        if (treeNode.selectFeat == -1) {
            treeNode.type = 0;
            return treeNode;
        }
        int n7 = this.data.countNominal[treeNode.selectFeat];
        int[] nArray2 = this.divideSample(n, n2, treeNode.selectFeat, n7);
        this.testedFeats[treeNode.selectFeat] = true;
        treeNode.branch = new TreeNode[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            if (nArray2[n3] < nArray2[n3 + 1]) {
                treeNode.branch[n3] = this.generateTree(nArray2[n3], nArray2[n3 + 1]);
                continue;
            }
            treeNode.branch[n3] = new TreeNode(n4, n5, 0, 0);
            treeNode.branch[n3].type = 0;
        }
        this.testedFeats[treeNode.selectFeat] = false;
        treeNode.noErrors = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            treeNode.noErrors += treeNode.branch[n3].noErrors;
        }
        if (treeNode.noErrors >= n6 - n5) {
            treeNode.type = 0;
            treeNode.noErrors = n6 - n5;
        }
        return treeNode;
    }

    public int[] divideSample(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n4 + 1];
        nArray[0] = n;
        for (int i = 1; i <= n4; ++i) {
            int n5;
            for (int j = n5 = nArray[i - 1]; j < n2; ++j) {
                if (this.data.valsTrainNominal[j][n3] != i - 1) continue;
                if (j != n5) {
                    short[] sArray = this.data.valsTrainNominal[n5];
                    this.data.valsTrainNominal[n5] = this.data.valsTrainNominal[j];
                    this.data.valsTrainNominal[j] = sArray;
                    short s = this.data.valsTrainClass[n5];
                    this.data.valsTrainClass[n5] = this.data.valsTrainClass[j];
                    this.data.valsTrainClass[j] = s;
                }
                ++n5;
            }
            nArray[i] = n5;
        }
        return nArray;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 2000.";
    }
}

