/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.decisiontree;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.decisiontree.Data;
import com.ibm.able.beans.decisiontree.DecisionTree;
import com.ibm.able.beans.decisiontree.Discretize;
import com.ibm.able.beans.decisiontree.TreeNode;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleField;
import java.io.Serializable;
import java.util.Vector;

public class AbleDecisionTree
extends AbleObject
implements Serializable {
    static final long serialVersionUID = 2000100100000000001L;
    public static final String Built = "built";
    public static final short TRAIN = 0;
    public static final short TEST = 1;
    public static final short RUN = 2;
    private DecisionTree decisionTree = new DecisionTree();
    private Data DATA;
    private Discretize DC;
    private int discretizationInterval = 10;
    private char[] typeFeat;
    private int noTrainExamples;
    private short noClasses;
    private short noFeats;
    private short noNominals;
    private short noReals;
    private String[] namesClass;
    private String[] namesNominal;
    private String[] namesReal;
    private short[] countNominal;
    private String[][] namesValsNominal;
    private short[] valsTrainClass;
    private short[][] valsTrainNominal;
    private float[][] valsTrainReal;
    private short[] valsTestClass;
    private short[][] valsTestNominal;
    private float[][] valsTestReal;
    protected int netMode;
    protected int currentExample;
    protected boolean decisionTreeBuilt = false;
    protected double[] outBuffer = new double[2];
    private int totalPredClass;
    private int correctPredClass;
    private int incorrectPredClass;
    private int predictClassIndex = -1;
    private String predictClass = null;

    public AbleDecisionTree() throws AbleException {
        this(Able.NlsMsg((String)"DFLT_NAME_DecisionTree"));
    }

    public AbleDecisionTree(String string) throws AbleException {
        super(string);
        this.outputBuffer = this.outBuffer;
        this.reset();
    }

    public void init() throws AbleException {
        this.initFromImport();
        this.netMode = 0;
        this.currentExample = 0;
        this.resetStatistics();
        this.setDecisionTreeBuilt(false);
        this.DATA = new Data();
        this.copyInfo();
        this.setState(1022);
    }

    public void reset() throws AbleException {
        this.currentExample = 0;
        this.setDecisionTreeBuilt(false);
        this.DATA = new Data();
        this.copyInfo();
        this.resetStatistics();
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(true);
    }

    public void resetStatistics() throws AbleException {
        this.totalPredClass = 0;
        this.correctPredClass = 0;
        this.incorrectPredClass = 0;
    }

    protected void initFromImport() throws AbleException {
        boolean bl = false;
        int n = 0;
        try {
            Object object;
            if (this.parent == null) {
                throw new AbleException(Able.NlsMsg((String)"Ex_BeanDecisionTreeWithoutParent"));
            }
            AbleDataSource ableDataSource = ((AbleAgent)this.parent).getDataSource();
            if (ableDataSource == null) {
                throw new AbleException(Able.NlsMsg((String)"Ex_BeanDecisionTreeWithoutDataSource"));
            }
            if (!((AbleImport)ableDataSource).isReady()) {
                throw new AbleException("Ex_BeanDecisionTreeDataSourceNotReady", (Object)new Object[]{((AbleObject)ableDataSource).getName()});
            }
            this.noTrainExamples = (int)ableDataSource.getNumRecords();
            Vector vector = ableDataSource.getFieldList();
            if (vector == null) {
                throw new AbleException("Ex_BeanDecisionTreeDataSourceNotReady", (Object)new Object[]{((AbleObject)ableDataSource).getName()});
            }
            this.noFeats = (short)(vector.size() - 1);
            this.inputBuffer = ableDataSource.isAllNumericData() ? (Object)new double[this.noFeats + 1] : new String[this.noFeats + 1];
            this.typeFeat = new char[this.noFeats + 1];
            this.dimensionArrays(vector);
            this.noNominals = 0;
            this.noReals = 0;
            for (int i = 0; i < this.noFeats + 1; ++i) {
                Object object2;
                object = (AbleField)vector.elementAt(i);
                if (object.getUsage() == 1 && !bl) {
                    bl = true;
                    this.typeFeat[i] = 111;
                    this.noClasses = (short)object.getNormalizedSize();
                    this.namesClass = new String[this.noClasses];
                    if (!(object instanceof AbleCategoricalField)) {
                        object2 = Able.NlsMsg((String)"Ex_BeanDecisionTreeClassNotCategorical", (Object[])new Object[]{object.getDataTypeString()});
                        throw new AbleException((String)object2);
                    }
                    object2 = ((AbleCategoricalField)object).getValueList();
                    for (n = 0; n < ((Vector)object2).size(); ++n) {
                        this.namesClass[n] = (String)((Vector)object2).elementAt(n);
                    }
                    continue;
                }
                if (object.getDataTypeString().equalsIgnoreCase(AbleData.DataType((int)12))) {
                    this.typeFeat[i] = 100;
                    this.countNominal[this.noNominals] = (short)object.getNormalizedSize();
                    this.namesNominal[this.noNominals] = object.getName();
                    this.namesValsNominal[this.noNominals] = new String[this.countNominal[this.noNominals]];
                    object2 = ((AbleCategoricalField)object).getValueList();
                    for (n = 0; n < ((Vector)object2).size(); ++n) {
                        this.namesValsNominal[this.noNominals][n] = (String)((Vector)object2).elementAt(n);
                    }
                    this.noNominals = (short)(this.noNominals + 1);
                    continue;
                }
                if (!object.getDataTypeString().equalsIgnoreCase(AbleData.DataType((int)13)) && !object.getDataTypeString().equalsIgnoreCase(AbleData.DataType((int)14))) continue;
                this.typeFeat[i] = 99;
                this.namesReal[this.noReals] = object.getName();
                this.noReals = (short)(this.noReals + 1);
            }
            if (!bl) {
                object = new AbleException("Ex_BeanDecisionTreeNoClassField", (Object)new Object[]{((AbleObject)ableDataSource).getName()});
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, "", (Throwable)object);
                }
                throw object;
            }
        }
        catch (AbleException ableException) {
            throw ableException;
        }
        catch (Exception exception) {
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void dimensionArrays(Vector vector) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < this.noFeats + 1; ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            if (ableField.getUsage() == 1 && !bl && ableField instanceof AbleCategoricalField) {
                bl = true;
                continue;
            }
            if (ableField.getDataTypeString().equalsIgnoreCase(AbleData.DataType((int)12))) {
                int n4 = ableField.getNormalizedSize();
                if (n < n4) {
                    n = n4;
                }
                ++n2;
                continue;
            }
            if (!ableField.getDataTypeString().equalsIgnoreCase(AbleData.DataType((int)13)) && !ableField.getDataTypeString().equalsIgnoreCase(AbleData.DataType((int)14))) continue;
            ++n3;
        }
        this.countNominal = new short[n2];
        this.namesNominal = new String[n2];
        this.namesReal = new String[n3];
        this.namesValsNominal = new String[n2][];
        this.valsTrainClass = new short[this.noTrainExamples];
        this.valsTrainNominal = new short[this.noTrainExamples][n2];
        this.valsTrainReal = new float[this.noTrainExamples][n3];
        this.valsTestClass = new short[1];
        this.valsTestNominal = new short[1][n2];
        this.valsTestReal = new float[1][n3];
    }

    protected void copyInfo() throws AbleException {
        this.DATA.setTypeFeat(this.typeFeat);
        this.DATA.setNoTrainExamples(this.noTrainExamples);
        this.DATA.setNoClasses(this.noClasses);
        this.DATA.setNoFeats(this.noFeats);
        this.DATA.setNoNominals(this.noNominals);
        this.DATA.setNoReals(this.noReals);
        this.DATA.setNamesClass(this.namesClass);
        this.DATA.setNamesNominal(this.namesNominal);
        this.DATA.setNamesReal(this.namesReal);
        this.DATA.setCountNominal(this.countNominal);
        this.DATA.setNamesValsNominal(this.namesValsNominal);
    }

    protected void copyTrainData() throws AbleException {
        this.DATA.setValsTrainClass(this.valsTrainClass);
        this.DATA.setValsTrainNominal(this.valsTrainNominal);
        this.DATA.setValsTrainReal(this.valsTrainReal);
    }

    protected void copyTestData() throws AbleException {
        this.DATA.setValsTestNominal(this.valsTestNominal);
        this.DATA.setValsTestReal(this.valsTestReal);
        if (this.netMode == 1) {
            this.DATA.setValsTestClass(this.valsTestClass);
        }
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        this.readInputs();
        if (this.netMode == 0) {
            if (this.currentExample == this.noTrainExamples) {
                if (!this.decisionTreeBuilt) {
                    this.copyTrainData();
                    this.DC = new Discretize(this.DATA);
                    if (this.DATA.noReals > 0) {
                        this.DC.createFixedIntervals((short)this.discretizationInterval);
                    }
                    this.decisionTree.buildHypothesis(this.DATA);
                    this.setDecisionTreeBuilt(true);
                } else {
                    this.currentExample %= this.noTrainExamples;
                    throw new AbleException(Able.NlsMsg((String)"Ex_BeanDecisionTreeAlreadyBuilt", (Object[])new Object[]{this.name}));
                }
            }
            this.currentExample %= this.noTrainExamples;
        } else {
            if (!this.decisionTreeBuilt) {
                throw new AbleException(Able.NlsMsg((String)"Ex_BeanDecisionTreeNotBuilt", (Object[])new Object[]{this.name}));
            }
            this.copyTestData();
            short[] sArray = this.DC.discretizeOneExample(this.valsTestNominal[0], this.noNominals, this.valsTestReal[0], this.noReals);
            this.predictClassIndex = this.decisionTree.classifyOneExample(this.DATA, sArray);
            this.predictClass = new String(this.namesClass[this.predictClassIndex]);
            this.outBuffer[0] = this.predictClassIndex;
            this.dataChanged(this.outputBuffer);
            if (this.netMode == 1) {
                ++this.totalPredClass;
                if (this.predictClass.equals(this.namesClass[this.valsTestClass[0]])) {
                    ++this.correctPredClass;
                } else {
                    ++this.incorrectPredClass;
                }
            }
        }
    }

    private void readInputs() throws AbleException {
        if (this.parent == null) {
            return;
        }
        if (this.inputBuffer == null) {
            throw new AbleException(Able.NlsMsg((String)"Ex_BeanNullInputBuffer"));
        }
        int n = 0;
        int n2 = 0;
        String[] stringArray = this.getInputBufferAsStringArray();
        block5: for (int i = 0; i < this.noFeats + 1; ++i) {
            String string = stringArray[i];
            switch (this.typeFeat[i]) {
                case 'c': {
                    if (this.netMode == 0) {
                        this.valsTrainReal[this.currentExample][n2] = new Float(string).floatValue();
                    } else {
                        this.valsTestReal[0][n2] = new Float(string).floatValue();
                    }
                    ++n2;
                    continue block5;
                }
                case 'd': {
                    int n3;
                    for (n3 = 0; n3 < this.countNominal[n] && !this.namesValsNominal[n][n3].equals(string); ++n3) {
                    }
                    if (n3 == this.countNominal[n]) {
                        throw new AbleException("Ex_BeanDecisionTreeUnknownValue", (Object)new Object[]{string, this.namesNominal[n], this.toString(this.namesValsNominal[n], this.countNominal[n])});
                    }
                    if (this.netMode == 0) {
                        this.valsTrainNominal[this.currentExample][n] = (short)n3;
                    } else {
                        this.valsTestNominal[0][n] = (short)n3;
                    }
                    ++n;
                    continue block5;
                }
                case 'o': {
                    int n3;
                    for (n3 = 0; n3 < this.noClasses && !this.namesClass[n3].equals(string); ++n3) {
                    }
                    if (n3 == this.noClasses) {
                        throw new AbleException("Ex_BeanDecisionTreeUnknownClass", (Object)new Object[]{string, this.namesClass.toString()});
                    }
                    if (this.netMode == 0) {
                        this.valsTrainClass[this.currentExample] = (short)n3;
                    } else if (this.netMode == 1) {
                        this.valsTestClass[0] = (short)n3;
                    }
                    this.outBuffer[1] = n3;
                }
            }
        }
        if (this.netMode == 0) {
            ++this.currentExample;
        }
    }

    private String toString(String[] stringArray) {
        return this.toString(stringArray, stringArray.length);
    }

    private String toString(String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer = stringArray.length > 0 ? stringBuffer.append(stringArray[0]) : stringBuffer.append("null");
        for (int i = 1; i < n; ++i) {
            stringBuffer = stringBuffer.append(", ");
            stringBuffer = stringBuffer.append(stringArray[i]);
        }
        return (stringBuffer + "]").toString();
    }

    public void processTimerEvent() throws AbleException {
    }

    public void handleAbleEvent(AbleEvent ableEvent) {
    }

    public void setNetMode(int n) throws AbleException {
        int n2 = this.netMode;
        this.netMode = n;
        this.firePropertyChange("netMode", new Integer(n2), new Integer(n));
    }

    public int getNetMode() {
        return this.netMode;
    }

    public double getPercentCorrect() {
        return 100.0 * (double)this.correctPredClass / (double)this.totalPredClass;
    }

    public int getTotalPredClass() {
        return this.totalPredClass;
    }

    public int getCorrectPredClass() {
        return this.correctPredClass;
    }

    public int getIncorrectPredClass() {
        return this.incorrectPredClass;
    }

    public short[] getValsTrainClass() {
        return this.valsTrainClass;
    }

    public short[] getValsTestClass() {
        return this.valsTestClass;
    }

    public String getPredictClass() {
        return this.predictClass;
    }

    public int getPredictClassIndex() {
        return this.predictClassIndex;
    }

    public int getCurrentExample() {
        return this.currentExample;
    }

    public void setDiscretizationInterval(int n) {
        this.discretizationInterval = n;
    }

    public int getDiscretizationInterval() {
        return this.discretizationInterval;
    }

    public void setDecisionTreeBuilt(boolean bl) throws AbleException {
        boolean bl2 = this.decisionTreeBuilt;
        this.decisionTreeBuilt = bl;
        this.firePropertyChange(Built, new Boolean(bl2), new Boolean(bl));
    }

    public boolean isDecisionTreeBuilt() {
        return this.decisionTreeBuilt;
    }

    public boolean getDecisionTreeBuilt() {
        return this.decisionTreeBuilt;
    }

    public String getDecisionTreeAsString() {
        if (this.decisionTreeBuilt) {
            StringBuffer stringBuffer = new StringBuffer();
            this.showTree(this.decisionTree.getRoot(), 0, stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }

    private void showTree(TreeNode treeNode, int n, StringBuffer stringBuffer) {
        int n2;
        int n3 = n;
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append("\t");
        }
        if (treeNode.type == 0) {
            stringBuffer.append(Able.LS);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(Able.NlsMsg((String)"Inf_BeanDecisionTreeClass", (Object[])new Object[]{this.namesClass[treeNode.majClass], Integer.toString(treeNode.countClass), Integer.toString(treeNode.size)}));
        } else if (this.DATA != null) {
            ++n3;
            for (n2 = 0; n2 < this.DATA.countNominal[treeNode.selectFeat]; ++n2) {
                stringBuffer.append(Able.LS);
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(Able.NlsMsg((String)"Inf_BeanDecisionTreeNode", (Object[])new Object[]{Integer.toString(n3), Integer.toString(n2), this.DATA.namesNominal[treeNode.selectFeat], this.DATA.namesValsNominal[treeNode.selectFeat][n2]}));
                this.showTree(treeNode.branch[n2], n3, stringBuffer);
            }
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 2000.";
    }
}

