/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.bayes;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.bayes.NaiveBayes;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleField;
import java.util.Vector;

public class AbleNaiveBayes
extends AbleObject {
    protected NaiveBayes NB;
    protected int[][] data;
    protected int[] labels;
    protected int[] nvals;
    protected int nlabels;
    protected int nfeatures;
    protected int nvalues;
    protected int ninst;
    protected int numInputs;
    protected int numOutputs;
    protected int[] inNum;
    protected double[] outNum;
    protected int netMode;
    protected int netNumRecs;
    protected int netRecInx;

    public AbleNaiveBayes() throws AbleException {
        super(Able.NlsMsg((String)"DFLT_NAME_NaiveBayes"));
        this.NB = new NaiveBayes();
    }

    public AbleNaiveBayes(String string) throws AbleException {
        super(string);
        this.NB = new NaiveBayes();
    }

    public AbleNaiveBayes(int n, int n2, int[] nArray, int n3, double[] dArray, double[][][] dArray2) throws AbleException {
        this.NB.initializeNB(n, n2, nArray, n3, dArray, dArray2);
    }

    public int getNetMode() {
        return this.netMode;
    }

    public int getNetNumRecs() {
        return this.netNumRecs;
    }

    public int getNetRecInx() {
        return this.netRecInx;
    }

    public void setNetMode(int n) {
        this.netMode = n;
    }

    private void readInputs() throws AbleException {
        AbleDataSource ableDataSource;
        if (this.parent != null && (ableDataSource = ((AbleAgent)this.parent).getDataSource()) != null) {
            this.netNumRecs = (int)ableDataSource.getNumRecords();
        }
        this.netRecInx %= this.netNumRecs;
        int n = 0;
        if (this.inputBuffer == null) {
            this.logger.message(4L, (Object)this, "readInputs()", "EX_VARIABLE_IS_NULL", new Object[]{"inputBuffer", this.name});
            throw new AbleException("EX_VARIABLE_IS_NULL", (Object)new Object[]{"inputBuffer", this.name});
        }
        double[] dArray = (double[])this.inputBuffer;
        for (n = 0; n < this.numInputs; ++n) {
            this.inNum[n] = (int)dArray[n];
            this.data[0][n] = this.inNum[n];
        }
        this.inNum[this.numInputs] = (int)dArray[dArray.length - 1];
        this.labels[0] = (int)((double[])this.inputBuffer)[this.numInputs];
        this.outNum[1] = this.inNum[this.numInputs];
        ++this.netRecInx;
    }

    public void init() throws AbleException {
        this.initFromImport();
        this.netMode = 0;
        this.numInputs = this.nfeatures;
        this.numOutputs = 1;
        this.inNum = new int[this.nfeatures + 1];
        this.inputBuffer = new double[this.nfeatures + 1];
        this.outNum = new double[this.numOutputs * 2];
        this.outputBuffer = this.outNum;
        this.setState(1022);
        this.setDataFlowEnabled(true);
    }

    public void reset() {
    }

    public void process() throws AbleException {
        int n = -1;
        this.processBufferConnections();
        this.readInputs();
        if (this.netMode == 0) {
            this.NB.buildHypothesis(this.data, this.labels, this.ninst, this.nlabels, this.nfeatures, this.nvals);
        } else {
            n = this.NB.classifyExample(this.inNum, null);
        }
        this.outNum[0] = n;
        this.dataChanged(this.outputBuffer);
    }

    public void processTimerEvent() {
    }

    protected void initFromImport() throws AbleException {
        int n;
        int n2 = 0;
        int n3 = -1;
        this.nlabels = -1;
        if (this.parent == null) {
            String string = Able.NlsMsg((String)"Ex_BeanNBWithoutParent");
            this.logger.text(4L, (Object)this, "initFromImport()", string);
            throw new AbleException(string);
        }
        AbleDataSource ableDataSource = ((AbleAgent)this.parent).getDataSource();
        if (ableDataSource == null) {
            String string = Able.NlsMsg((String)"Ex_BeanNBWithoutDataSource");
            this.logger.text(4L, (Object)this, "initFromImport()", string);
            throw new AbleException(string);
        }
        Vector vector = ableDataSource.getFieldList();
        this.netNumRecs = (int)ableDataSource.getNumRecords();
        for (n = 0; n < vector.size(); ++n) {
            AbleField ableField = (AbleField)vector.elementAt(n);
            if (ableField.getUsageString().equalsIgnoreCase(AbleData.UsageTypeString((int)1))) {
                ++n2;
                this.nlabels = ableField.getNormalizedSize();
                continue;
            }
            int n4 = ableField.getNormalizedSize();
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (n2 == 0) {
            String string = Able.NlsMsg((String)"Ex_BeanNBNoClassField", (Object[])new Object[]{ableDataSource.getName()});
            this.logger.text(4L, (Object)this, "initFromImport()", string);
            throw new AbleException(string);
        }
        if (n2 > 1) {
            String string = Able.NlsMsg((String)"Ex_BeanNBOnlyOneClassField", (Object[])new Object[]{Integer.toString(this.nlabels)});
            this.logger.text(4L, (Object)this, "initFromImport()", string);
            throw new AbleException(string);
        }
        this.nfeatures = vector.size() - 1;
        this.nvalues = n3;
        this.ninst = 1;
        this.data = new int[this.ninst][this.nfeatures];
        this.labels = new int[this.ninst];
        this.nvals = new int[this.nfeatures];
        for (n = 0; n < this.nfeatures; ++n) {
            this.nvals[n] = this.nvalues;
        }
    }

    public int getNClasses() {
        return this.NB.getNClasses();
    }

    public int getNFeatures() {
        return this.NB.getNFeatures();
    }

    public int[] getNFValues() {
        return this.NB.getNFValues();
    }

    public double[] getEqSampleSize() {
        return this.NB.getEqSampleSize();
    }

    public double[][][] getCPT() {
        return this.NB.getCPT();
    }

    public double[] getClassPriors() {
        return this.NB.getClassPriors();
    }

    public double getAvgLikelihood() {
        return this.NB.getAvgLikelihood();
    }

    public double getAvgLogLikelihood() {
        return this.NB.getAvgLogLikelihood();
    }

    public double getAccuracy() {
        return this.NB.getAccuracy();
    }

    public double[] getClassProb() {
        return this.NB.getClassProb();
    }

    public int[][] getConfusionMatrix() {
        return this.NB.getConfusionMatrix();
    }

    public void setNClasses(int n) {
        this.NB.setNClasses(n);
    }

    public void setNFeatures(int n, int[] nArray) {
        this.NB.setNFeatures(n, nArray);
    }

    public void setClassPriors(double[] dArray) {
        this.NB.setClassPriors(dArray);
    }
}

