/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.autotune.AutotuneConfigurationMetric;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneServiceLevelMetric;
import com.ibm.able.autotune.AutotuneTuningControlMetric;
import com.ibm.able.autotune.AutotuneWorkloadMetric;
import com.ibm.able.autotune.BaseAutotuneAdaptor;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.data.AbleContinuousVariable;
import com.ibm.able.data.AbleDoubleVariable;
import com.ibm.able.data.AbleVariable;
import java.io.File;

public class TestAutotuneAdaptor
extends BaseAutotuneAdaptor {
    static final long serialVersionUID = 1999100100000000001L;
    private static final String DefaultFileName = Able.ProductDirectory + File.separator + "examples" + File.separator + "testAdaptor";
    private static final String[] configMetricNames = new String[]{"MaximumBatchProcesses", "MaximumInteractiveProcesses"};
    private static final String[] workloadMetricNames = new String[]{"CountBatchProcesses", "CountInteractiveProcesses", "CountBatchTransactionsPerSecond", "CountInteractiveTransactionsPerSecond", "PercentInteractiveCPUUsed", "PercentTotalCPUUsed", "InteractiveResponseTime"};
    private static final String[] tuningMetricNames = new String[]{"MaximumBatchProcessPriority", "MinimumBatchProcessPriority", "MaximumBatchProcessPriorityReduction"};
    private double serviceLevelTarget = 1.0;
    private String serviceLevelMetricName = "InteractiveResponseTimeTarget";
    private AbleImport importBean = null;
    static /* synthetic */ Class class$java$lang$String;

    public TestAutotuneAdaptor() throws AbleException {
        super("TestAdaptor");
        this.defineMetrics();
        this.reset();
    }

    public void defineMetrics() throws AbleException {
        try {
            int n;
            for (n = 0; n < configMetricNames.length; ++n) {
                this.metrics.addMetric(new AutotuneConfigurationMetric(configMetricNames[n], (AbleVariable)new AbleDoubleVariable(configMetricNames[n], 0.0)));
            }
            for (n = 0; n < workloadMetricNames.length; ++n) {
                this.metrics.addMetric(new AutotuneWorkloadMetric(workloadMetricNames[n], (AbleVariable)new AbleDoubleVariable(workloadMetricNames[n], 0.0)));
            }
            for (n = 0; n < tuningMetricNames.length; ++n) {
                this.metrics.addMetric(new AutotuneTuningControlMetric(tuningMetricNames[n], (AbleVariable)new AbleContinuousVariable(tuningMetricNames[n], 0.0, 1000.0), new AbleUserDefinedFunction("say", (Object)this, "say", new Class[]{class$java$lang$String == null ? TestAutotuneAdaptor.class$("java.lang.String") : class$java$lang$String})));
            }
            this.metrics.addMetric(new AutotuneServiceLevelMetric(this.serviceLevelMetricName, (AbleVariable)new AbleDoubleVariable(this.serviceLevelMetricName, 0.0), new AbleUserDefinedFunction("getInteractiveResponseTime", (Object)this, "getInteractiveResponseTimeTarget", null)));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("Error: can't define sensor or effector associated with metric " + noSuchMethodException.toString());
        }
    }

    public void init() throws AbleException {
        if (this.importBean == null) {
            this.setImportBean(new AbleImport());
        }
        int n = this.importBean.getNumberOfOutputFields();
        this.outputBuffer = new double[n];
        if (this.isAbleEventPostingEnabled() || this.isAbleEventProcessingEnabled() || this.isTimerEventProcessingEnabled()) {
            this.startEnabledEventProcessing();
        } else {
            this.setState(1022);
        }
    }

    public void reset() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setDataFlowEnabled(true);
        this.setAbleEventProcessingEnabled(0);
    }

    public void setDataFileName(String string) throws AbleException {
        if (this.importBean != null) {
            this.importBean.setDataFileName(string);
        }
    }

    public String getDataFileName() {
        if (this.importBean != null) {
            return this.importBean.getDataFileName();
        }
        return "";
    }

    public AbleImport getImportBean() {
        return this.importBean;
    }

    public void setImportBean(AbleImport ableImport) throws AbleException {
        if (this.importBean != null) {
            this.removeBean((AbleBean)this.importBean);
        }
        this.importBean = ableImport;
        if (this.importBean == null) {
            return;
        }
        this.addBean((AbleBean)this.importBean);
        String string = this.importBean.getDataFileName();
        if (string == null || string.equals("")) {
            this.importBean.setDataFileName(DefaultFileName);
        }
    }

    public void process() throws AbleException {
        this.importBean.process();
        this.dataChanged(this);
    }

    public void processOutputBuffer() throws AbleException {
        double[] dArray = (double[])this.importBean.getOutputBuffer();
        int n = 0;
        AutotuneMetric autotuneMetric = this.metrics.getMetric(this.serviceLevelMetricName);
        autotuneMetric.setNumericValue(dArray[n++]);
        AutotuneMetric[] autotuneMetricArray = this.metrics.getMetrics(configMetricNames);
        for (int i = 0; i < autotuneMetricArray.length; ++i) {
            autotuneMetricArray[i].setNumericValue(dArray[n++]);
        }
        AutotuneMetric[] autotuneMetricArray2 = this.metrics.getMetrics(workloadMetricNames);
        for (int i = 0; i < autotuneMetricArray2.length; ++i) {
            autotuneMetricArray2[i].setNumericValue(dArray[n++]);
        }
        AutotuneMetric[] autotuneMetricArray3 = this.metrics.getMetrics(tuningMetricNames);
        for (int i = 0; i < autotuneMetricArray3.length; ++i) {
            autotuneMetricArray3[i].setNumericValue(dArray[n++]);
        }
        this.setOutputBuffer(dArray);
    }

    public void say(String string) {
        System.out.println("say(): " + string);
    }

    public double getInteractiveResponseTimeTarget() {
        return this.serviceLevelTarget;
    }

    public void setInteractiveResponseTimeTarget(double d) {
        this.serviceLevelTarget = d;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

