/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.agents.AbleNeuralPredictionAgent;
import com.ibm.able.autotune.AutotuneAdaptor;
import com.ibm.able.autotune.AutotuneAgent;
import com.ibm.able.autotune.AutotuneController;
import com.ibm.able.autotune.AutotuneServiceLevelMetric;
import com.ibm.able.autotune.AutotuneTuningControlMetric;
import com.ibm.able.autotune.BaseAutotuneController;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleLiteral;
import java.io.Serializable;

public class Neural2WayLoadBalanceController
extends BaseAutotuneController
implements AutotuneController {
    public static final int MODEL_CONTROL_INDEX = 1;
    public static final int CONTROLLER_CONTROL_INDEX = 1;
    protected int modelControlIndex = 1;
    protected int controllerControlIndex = 1;
    protected AutotuneAdaptor adaptor;
    protected AbleNeuralPredictionAgent controller;
    protected AbleNeuralPredictionAgent model;
    public static final String DefaultModelDataSetFileName = "mq1model.dfn";
    protected String modelDataSetFileName = "mq1model.dfn";
    public static final String DefaultControllerDataSetFileName = "mq1controller.dfn";
    protected String controllerDataSetFileName;
    protected double[] controls;
    protected double lastError = 9999.0;
    protected double error = 0.0;
    protected double changeInError = 0.0;
    protected double force = 0.0;
    protected double modelControlError = 0.0;
    protected AutotuneServiceLevelMetric serviceLevelMetricA = null;
    protected AutotuneServiceLevelMetric serviceLevelMetricB = null;
    protected AutotuneTuningControlMetric loadBalanceTuningControlMetric = null;
    private static String serviceLevelMetricAName = "Mgr1MeanQLength";
    private static String serviceLevelMetricBName = "Mgr2MeanQLength";
    private static String loadBalanceTuningControlMetricName = "Mgr1Value";
    static /* synthetic */ Class class$com$ibm$able$autotune$Neural2WayLoadBalanceController;

    public Neural2WayLoadBalanceController() throws AbleException {
        super((class$com$ibm$able$autotune$Neural2WayLoadBalanceController == null ? (class$com$ibm$able$autotune$Neural2WayLoadBalanceController = Neural2WayLoadBalanceController.class$("com.ibm.able.autotune.Neural2WayLoadBalanceController")) : class$com$ibm$able$autotune$Neural2WayLoadBalanceController).getName());
    }

    public void setModelDataSetFileName(String string) {
        this.modelDataSetFileName = string;
    }

    public String getModelDataSetFileName() {
        return this.modelDataSetFileName;
    }

    public void setControllerDataSetFileName(String string) {
        this.controllerDataSetFileName = string;
    }

    public String getControllerDataSetFileName() {
        return this.controllerDataSetFileName;
    }

    public void setServiceLevelMetricA(AutotuneServiceLevelMetric autotuneServiceLevelMetric) {
        this.serviceLevelMetricA = autotuneServiceLevelMetric;
    }

    public AutotuneServiceLevelMetric getServiceLevelMetricA() {
        return this.serviceLevelMetricA;
    }

    public void setServiceLevelMetricB(AutotuneServiceLevelMetric autotuneServiceLevelMetric) {
        this.serviceLevelMetricB = autotuneServiceLevelMetric;
    }

    public AutotuneServiceLevelMetric getServiceLevelMetricB() {
        return this.serviceLevelMetricB;
    }

    public void setLoadBalanceTuningControlMetric(AutotuneTuningControlMetric autotuneTuningControlMetric) {
        this.loadBalanceTuningControlMetric = autotuneTuningControlMetric;
    }

    public AutotuneTuningControlMetric getLoadBalanceTuningControlMetric() {
        return this.loadBalanceTuningControlMetric;
    }

    public double getLastError() {
        return this.lastError;
    }

    public double getError() {
        return this.error;
    }

    public double getChangeInError() {
        return this.changeInError;
    }

    public double getForce() {
        return this.force;
    }

    public double getModelControlError() {
        return this.modelControlError;
    }

    public void init() throws AbleException {
        Serializable serializable;
        if (this.selectedMetrics.isEmpty() && this.parent instanceof AutotuneAgent) {
            this.selectedMetrics = ((AutotuneAgent)this.parent).getMetrics();
        }
        this.setDataFlowEnabled(false);
        this.removeAllBeans();
        if (this.parent instanceof AutotuneAgent) {
            serializable = (AutotuneAgent)this.parent;
            if (this.serviceLevelMetricA == null) {
                this.serviceLevelMetricA = (AutotuneServiceLevelMetric)((AutotuneAgent)serializable).getMetric(serviceLevelMetricAName);
            }
            if (this.serviceLevelMetricB == null) {
                this.serviceLevelMetricB = (AutotuneServiceLevelMetric)((AutotuneAgent)serializable).getMetric(serviceLevelMetricBName);
            }
            if (this.loadBalanceTuningControlMetric == null) {
                this.loadBalanceTuningControlMetric = (AutotuneTuningControlMetric)((AutotuneAgent)serializable).getMetric(loadBalanceTuningControlMetricName);
            }
        }
        this.controller = new AbleNeuralPredictionAgent("Controller");
        this.controller.setDataFileName(this.controllerDataSetFileName);
        this.controller.setBufferSize(1);
        this.controller.setNetArch("10 0 0");
        this.controller.init();
        this.addBean((AbleBean)this.controller);
        this.model = new AbleNeuralPredictionAgent("Model");
        this.model.setDataFileName(this.modelDataSetFileName);
        this.model.setBufferSize(100);
        this.model.setNetArch("10 0 0");
        this.model.init();
        this.addBean((AbleBean)this.model);
        serializable = (AbleFilter)this.controller.getBean(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        AbleFilter ableFilter = (AbleFilter)this.controller.getBean(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
        AbleTranslateTemplate ableTranslateTemplate = ((AbleFilter)serializable).getTemplateRec(this.loadBalanceTuningControlMetric.getName());
        if (ableTranslateTemplate == null && this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, "computeControlActions", "Error:  Mismatch between loadBalance Metric name and dfn field name!");
        }
        AbleTranslateOperator ableTranslateOperator = ableTranslateTemplate.getPreOperator();
        AbleTranslateTemplate ableTranslateTemplate2 = ((AbleFilter)serializable).getTemplateRec("predicted");
        AbleTranslateOperator ableTranslateOperator2 = new AbleTranslateOperator(20, null);
        ableTranslateTemplate2.setPreOperator(ableTranslateOperator2);
        double[] dArray = ableTranslateOperator.getOpData();
        double[] dArray2 = new double[]{dArray[3], dArray[4], dArray[5], dArray[0], dArray[1], dArray[2]};
        AbleTranslateOperator ableTranslateOperator3 = new AbleTranslateOperator(25, dArray2);
        AbleTranslateTemplate ableTranslateTemplate3 = ableFilter.getTemplateRec("predicted");
        ableTranslateTemplate3.setPreOperator(ableTranslateOperator3);
        this.outputBuffer = this.controller.getOutputBuffer();
        this.setDataFlowEnabled(true);
        this.setState(1021);
    }

    public void process() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Neural controller : process()");
        }
        this.computeErrors();
        this.backPropThroughModel();
        this.trainController();
        this.computeControlActions();
        this.setControlActions();
        this.dataChanged(this);
    }

    public void setAdaptor(AutotuneAdaptor autotuneAdaptor) {
        this.adaptor = autotuneAdaptor;
    }

    public AutotuneAdaptor getAdaptor() {
        return this.adaptor;
    }

    protected void backPropThroughModel() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "backPropThroughModel", "Neural controller : backPropThroughModel()");
        }
        this.model.setMode(1);
        this.model.setExplicitErrorMode(true);
        this.model.setTolerance(0.0);
        double[] dArray = (double[])this.model.getInputBuffer();
        double[] dArray2 = this.getModelInputData();
        if (dArray.length != dArray2.length) {
            String string = Able.NlsMsg((String)"Ex_AuModelBufferMetricCount", (Object[])new Object[]{Integer.toString(dArray.length), Integer.toString(dArray2.length)});
            throw new AbleException(string);
        }
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = dArray2[i];
        }
        dArray[dArray.length - 1] = this.error;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "backPropThroughModel", "Basic Neural Controller --> backprop through model");
        }
        this.model.process();
        double[] dArray3 = this.model.getNetwork().getError();
        double d = dArray3[1];
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "backPropThroughModel", "Basic Neural Controller --> model control error = " + d);
        }
    }

    protected void trainController() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "trainController", "Neural controller : trainController()");
        }
        this.controller.setMode(0);
        this.controller.setExplicitErrorMode(true);
        this.controller.setTolerance(0.0);
        double[] dArray = (double[])this.controller.getInputBuffer();
        double[] dArray2 = this.getControllerInputData();
        if (dArray.length != dArray2.length) {
            String string = Able.NlsMsg((String)"Ex_AuControllerBufferMetricCount", (Object[])new Object[]{Integer.toString(dArray.length), Integer.toString(dArray2.length)});
            throw new AbleException(string);
        }
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = dArray2[i];
        }
        dArray[1] = this.modelControlError;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "trainController", "Basic Neural Controller --> adapting controller ");
        }
        this.controller.process();
    }

    public void computeErrors() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeErrors", "Neural controller : computeErrors()");
        }
        AbleLiteral ableLiteral = this.serviceLevelMetricA.getValue();
        AbleLiteral ableLiteral2 = this.serviceLevelMetricB.getValue();
        if (ableLiteral == null || ableLiteral2 == null) {
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, "computeErrors", "Neural 2Way Controller Error: Service Level Metric values are null!");
            }
            return;
        }
        double d = this.serviceLevelMetricA.getNumericValue();
        double d2 = this.serviceLevelMetricB.getNumericValue();
        this.error = d2 - d;
        if (this.lastError == 9999.0) {
            this.lastError = this.error;
        }
        this.changeInError = this.error - this.lastError;
        this.lastError = this.error;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeErrors", "Neural Controller error=" + this.error + " changeInError=" + this.changeInError);
        }
    }

    private double[] getModelInputData() throws AbleDataException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "getModelInputData", "Neural controller: getModelInputData()");
        }
        String[] stringArray = null;
        AbleFilter ableFilter = (AbleFilter)this.model.getBean(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        stringArray = ableFilter.getFieldNamesArray();
        return this.selectedMetrics.getMetricValues(stringArray);
    }

    private double[] getControllerInputData() throws AbleDataException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "getControllerInputData", "Neural controller: getControllerInputData()");
        }
        String[] stringArray = null;
        AbleFilter ableFilter = (AbleFilter)this.controller.getBean(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        stringArray = ableFilter.getFieldNamesArray();
        return this.selectedMetrics.getMetricValues(stringArray);
    }

    public void computeControlActions() throws AbleException {
        double d;
        double d2;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Neural controller : computeControlActions()");
        }
        this.controller.setMode(2);
        System.out.println("Basic Neural Controller --> using controller network");
        this.controller.process();
        double[] dArray = (double[])this.controller.getOutputBuffer();
        this.controls = dArray;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Basic Neural Controller --> New control values = " + this.controls);
        }
        this.outputBuffer = this.controller.getOutputBuffer();
        this.force = this.controls[0];
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Neural 2Way Load Balance Controller output, force (delta)= " + this.force);
        }
        if ((d2 = (d = this.loadBalanceTuningControlMetric.getNumericValue()) + this.force) < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 100.0) {
            d2 = 100.0;
        }
        this.loadBalanceTuningControlMetric.setNumericValue(d2);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "neural controller old/new =" + d + ", " + d2);
        }
    }

    public void setControlActions() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "setControlActions", "Neural controller : setControlActions()");
        }
        this.adaptor.setTuningControl(this.loadBalanceTuningControlMetric);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

