/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleException;
import com.ibm.able.autotune.AutotuneAgent;
import com.ibm.able.autotune.AutotuneServiceLevelMetric;
import com.ibm.able.autotune.AutotuneTuningControlMetric;
import com.ibm.able.autotune.BaseAutotuneController;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.rules.AbleRuleSet;

public class Fuzzy2WayLoadBalanceController
extends BaseAutotuneController {
    public static final String DefaultRuleSetFileName = "FuzzyControllerCox.arl";
    protected String ruleSetFileName = "FuzzyControllerCox.arl";
    protected AbleRuleSet fuzzyController = null;
    Object[] lclInpBuffer = null;
    Object[] lclOutBuffer = null;
    protected double lastError = 9999.0;
    protected double error = 0.0;
    protected double changeInError = 0.0;
    protected double force = 0.0;
    protected AutotuneServiceLevelMetric serviceLevelMetricA = null;
    protected AutotuneServiceLevelMetric serviceLevelMetricB = null;
    protected AutotuneTuningControlMetric loadBalanceTuningControlMetric = null;
    private static String serviceLevelMetricAName = "Mgr1MeanQLength";
    private static String serviceLevelMetricBName = "Mgr2MeanQLength";
    private static String loadBalanceTuningControlMetricName = "Mgr1Value";
    static /* synthetic */ Class class$com$ibm$able$autotune$Fuzzy2WayLoadBalanceController;

    public Fuzzy2WayLoadBalanceController() throws AbleException {
        super((class$com$ibm$able$autotune$Fuzzy2WayLoadBalanceController == null ? (class$com$ibm$able$autotune$Fuzzy2WayLoadBalanceController = Fuzzy2WayLoadBalanceController.class$("com.ibm.able.autotune.Fuzzy2WayLoadBalanceController")) : class$com$ibm$able$autotune$Fuzzy2WayLoadBalanceController).getName());
    }

    public void setRuleSetFileName(String string) {
        this.ruleSetFileName = string;
    }

    public String getRuleSetFileName() {
        return this.ruleSetFileName;
    }

    public void setServiceLevelMetricA(AutotuneServiceLevelMetric autotuneServiceLevelMetric) {
        this.serviceLevelMetricA = autotuneServiceLevelMetric;
    }

    public AutotuneServiceLevelMetric getServiceLevelMetricA() {
        return this.serviceLevelMetricA;
    }

    public void setServiceLevelMetricB(AutotuneServiceLevelMetric autotuneServiceLevelMetric) {
        this.serviceLevelMetricB = autotuneServiceLevelMetric;
    }

    public AutotuneServiceLevelMetric getServiceLevelMetricB() {
        return this.serviceLevelMetricB;
    }

    public void setLoadBalanceTuningControlMetric(AutotuneTuningControlMetric autotuneTuningControlMetric) {
        this.loadBalanceTuningControlMetric = autotuneTuningControlMetric;
    }

    public AutotuneTuningControlMetric getLoadBalanceTuningControlMetric() {
        return this.loadBalanceTuningControlMetric;
    }

    public double getLastError() {
        return this.lastError;
    }

    public double getError() {
        return this.error;
    }

    public double getChangeInError() {
        return this.changeInError;
    }

    public double getForce() {
        return this.force;
    }

    public void init() throws AbleException {
        Object object;
        if (this.selectedMetrics.isEmpty() && this.parent instanceof AutotuneAgent) {
            this.selectedMetrics = ((AutotuneAgent)this.parent).getMetrics();
        }
        try {
            this.fuzzyController = new AbleRuleSet();
            this.fuzzyController.setDataFlowEnabled(true);
            this.fuzzyController.parseFromARL(this.ruleSetFileName);
            object = (Object[])this.fuzzyController.getInputBuffer();
            object[0] = new Double(0.0);
            object[1] = new Double(0.0);
            this.lclOutBuffer = (Object[])this.fuzzyController.getOutputBuffer();
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "init", exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init", (Throwable)exception);
                this.trace.text(262144L, (Object)this, "init", "Fuzzy Controller caught init() exception: " + exception);
            }
            if (exception instanceof AbleException) {
                throw (AbleException)((Object)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (this.parent instanceof AutotuneAgent) {
            object = (AutotuneAgent)this.parent;
            if (this.serviceLevelMetricA == null) {
                this.serviceLevelMetricA = (AutotuneServiceLevelMetric)((AutotuneAgent)object).getMetric(serviceLevelMetricAName);
            }
            if (this.serviceLevelMetricB == null) {
                this.serviceLevelMetricB = (AutotuneServiceLevelMetric)((AutotuneAgent)object).getMetric(serviceLevelMetricBName);
            }
            if (this.loadBalanceTuningControlMetric == null) {
                this.loadBalanceTuningControlMetric = (AutotuneTuningControlMetric)((AutotuneAgent)object).getMetric(loadBalanceTuningControlMetricName);
            }
        }
        this.startEnabledEventProcessing();
        this.setState(1021);
    }

    public void computeErrors() throws AbleException {
        AbleLiteral ableLiteral = this.serviceLevelMetricA.getValue();
        AbleLiteral ableLiteral2 = this.serviceLevelMetricB.getValue();
        if (ableLiteral == null || ableLiteral2 == null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "computeErrors", "Fuzzy 2Way Controller Error: Service Level Metric values are null!");
            }
            return;
        }
        double d = this.serviceLevelMetricA.getNumericValue();
        double d2 = this.serviceLevelMetricB.getNumericValue();
        this.error = d2 - d;
        if (this.lastError == 9999.0) {
            this.lastError = this.error;
        }
        this.changeInError = this.error - this.lastError;
        this.lastError = this.error;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeErrors", "Fuzzy Controller error=" + this.error + " changeInError=" + this.changeInError);
        }
        this.lclInpBuffer[0] = String.valueOf(this.error);
        this.lclInpBuffer[1] = String.valueOf(this.changeInError);
    }

    public void computeControlActions() throws AbleException {
        double d;
        double d2;
        this.fuzzyController.process();
        this.force = (Double)this.lclOutBuffer[0];
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Fuzzy Controller output, force (delta)= " + this.force);
        }
        if ((d2 = (d = this.loadBalanceTuningControlMetric.getNumericValue()) + this.force) < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 100.0) {
            d2 = 100.0;
        }
        this.loadBalanceTuningControlMetric.setNumericValue(d2);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "fuzzy controller old/new =" + d + ", " + d2);
        }
    }

    public void setControlActions() throws AbleException {
        this.adaptor.setTuningControl(this.loadBalanceTuningControlMetric);
    }

    public void process() throws AbleException {
        this.computeErrors();
        this.computeControlActions();
        this.setControlActions();
        this.dataChanged(this);
    }

    public void processTimerEvent() throws AbleException {
        this.process();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

