/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.agents.AbleNeuralPredictionAgent;
import com.ibm.able.autotune.AutotuneAdaptor;
import com.ibm.able.autotune.AutotuneController;
import com.ibm.able.autotune.AutotuneServiceLevelMetric;
import com.ibm.able.autotune.BaseAutotuneController;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.data.AbleDataException;

public class BasicNeuralAutotuneController
extends BaseAutotuneController
implements AutotuneController {
    protected AutotuneAdaptor adaptor;
    protected AbleNeuralPredictionAgent controller;
    protected AbleNeuralPredictionAgent model;
    protected String modelDataSetFileName;
    protected String controllerDataSetFileName;
    protected double[] controls;
    protected double desiredPerf;
    protected double error;
    protected double actualPerf;
    static final String controllerName = "Controller";
    static final String modelName = "Model";
    static /* synthetic */ Class class$com$ibm$able$autotune$BasicNeuralAutotuneController;

    public BasicNeuralAutotuneController() throws AbleException {
        super((class$com$ibm$able$autotune$BasicNeuralAutotuneController == null ? (class$com$ibm$able$autotune$BasicNeuralAutotuneController = BasicNeuralAutotuneController.class$("com.ibm.able.autotune.BasicNeuralAutotuneController")) : class$com$ibm$able$autotune$BasicNeuralAutotuneController).getName());
    }

    public void setModelDataSetFileName(String string) {
        this.modelDataSetFileName = string;
    }

    public String getModelDataSetFileName() {
        return this.modelDataSetFileName;
    }

    public void setControllerDataSetFileName(String string) {
        this.controllerDataSetFileName = string;
    }

    public String getControllerDataSetFileName() {
        return this.controllerDataSetFileName;
    }

    public void init() throws AbleException {
        this.setState(1021);
        this.setDataFlowEnabled(false);
        this.removeAllBeans();
        this.controller = new AbleNeuralPredictionAgent(controllerName);
        this.controller.setDataFileName(this.controllerDataSetFileName);
        this.controller.setBufferSize(1);
        this.controller.setNetArch("40 0 0");
        this.controller.init();
        this.addBean((AbleBean)this.controller);
        this.model = new AbleNeuralPredictionAgent(modelName);
        this.model.setDataFileName(this.modelDataSetFileName);
        this.model.setBufferSize(100);
        this.model.setNetArch("40 0 0");
        this.model.init();
        this.addBean((AbleBean)this.model);
        AbleFilter ableFilter = (AbleFilter)this.controller.getBean(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        AbleFilter ableFilter2 = (AbleFilter)this.controller.getBean(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
        AbleTranslateTemplate ableTranslateTemplate = ableFilter.getTemplateRec("cur_control");
        AbleTranslateOperator ableTranslateOperator = ableTranslateTemplate.getPreOperator();
        AbleTranslateTemplate ableTranslateTemplate2 = ableFilter.getTemplateRec("predicted");
        AbleTranslateOperator ableTranslateOperator2 = new AbleTranslateOperator(20, null);
        ableTranslateTemplate2.setPreOperator(ableTranslateOperator2);
        double[] dArray = ableTranslateOperator.getOpData();
        double[] dArray2 = new double[]{dArray[3], dArray[4], dArray[5], dArray[0], dArray[1], dArray[2]};
        AbleTranslateOperator ableTranslateOperator3 = new AbleTranslateOperator(25, dArray2);
        AbleTranslateTemplate ableTranslateTemplate3 = ableFilter2.getTemplateRec("predicted");
        ableTranslateTemplate3.setPreOperator(ableTranslateOperator3);
        this.outputBuffer = this.controller.getOutputBuffer();
        this.setDataFlowEnabled(true);
    }

    public void process() throws AbleException {
        this.computeErrors();
        this.backPropThroughModel();
        this.trainController();
        this.computeControlActions();
        this.setControlActions();
        this.dataChanged(this);
    }

    public void setAdaptor(AutotuneAdaptor autotuneAdaptor) {
        this.adaptor = autotuneAdaptor;
    }

    public AutotuneAdaptor getAdaptor() {
        return this.adaptor;
    }

    protected void backPropThroughModel() throws AbleException {
        double d;
        this.model.setMode(1);
        this.model.setExplicitErrorMode(true);
        this.model.setTolerance(0.0);
        double[] dArray = (double[])this.model.getInputBuffer();
        double[] dArray2 = this.getModelInputData();
        if (dArray.length != dArray2.length) {
            String string = Able.NlsMsg((String)"Ex_AuModelBufferMetricCount", (Object[])new Object[]{Integer.toString(dArray.length), Integer.toString(dArray2.length)});
            throw new AbleException(string);
        }
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = dArray2[i];
        }
        AutotuneServiceLevelMetric autotuneServiceLevelMetric = (AutotuneServiceLevelMetric)this.selectedMetrics.getMetric("error");
        dArray[dArray.length - 1] = d = autotuneServiceLevelMetric.getNumericValue();
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "backPropThroughModel", "Basic Neural Controller --> backprop through model");
        }
        this.model.process();
    }

    protected void trainController() throws AbleException {
        this.controller.setMode(0);
        this.controller.setExplicitErrorMode(true);
        this.controller.setTolerance(0.0);
        double[] dArray = (double[])this.controller.getInputBuffer();
        double[] dArray2 = this.getControllerInputData();
        if (dArray.length != dArray2.length) {
            String string = Able.NlsMsg((String)"Ex_AuControllerBufferMetricCount", (Object[])new Object[]{Integer.toString(dArray.length), Integer.toString(dArray2.length)});
            throw new AbleException(string);
        }
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = dArray2[i];
        }
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "trainController", "Basic Neural Controller --> adapting controller ");
        }
        this.controller.process();
    }

    public void computeErrors() throws AbleException {
        super.computeErrors();
    }

    private double[] getModelInputData() throws AbleDataException {
        String[] stringArray = null;
        AbleFilter ableFilter = (AbleFilter)this.model.getBean(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        stringArray = ableFilter.getFieldNamesArray();
        return this.selectedMetrics.getMetricValues(stringArray);
    }

    private double[] getControllerInputData() throws AbleDataException {
        String[] stringArray = null;
        AbleFilter ableFilter = (AbleFilter)this.controller.getBean(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        stringArray = ableFilter.getFieldNamesArray();
        return this.selectedMetrics.getMetricValues(stringArray);
    }

    public void computeControlActions() throws AbleException {
        this.controller.setMode(2);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Basic Neural Controller --> using controller network");
        }
        this.controller.process();
        double[] dArray = (double[])this.controller.getOutputBuffer();
        this.controls = dArray;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "computeControlActions", "Basic Neural Controller --> New control values = " + this.controls);
        }
        this.outputBuffer = this.controller.getOutputBuffer();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

