/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneMetricOperator;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleLiteral;
import java.io.Serializable;

public class AutotuneMetricTarget
implements Serializable {
    protected AutotuneMetric metric;
    protected AbleLiteral targetValue;
    protected AutotuneMetricOperator targetOperator;

    public AutotuneMetricTarget(AutotuneMetric autotuneMetric) {
        this.metric = autotuneMetric;
    }

    public AutotuneMetricTarget(AutotuneMetric autotuneMetric, int n, AbleLiteral ableLiteral) {
        this.metric = autotuneMetric;
        this.targetOperator = new AutotuneMetricOperator();
        this.targetOperator.setOperation(n);
        this.targetValue = ableLiteral;
    }

    public void setTargetValue(AbleLiteral ableLiteral) {
        this.targetValue = ableLiteral;
    }

    public AbleLiteral getTargetValue() {
        return this.targetValue;
    }

    public boolean test() throws AbleDataException {
        return this.targetOperator.test(this.targetValue, this.metric.getValue());
    }

    public double computeDelta() throws AbleDataException {
        return this.targetOperator.computeDelta(this.targetValue, this.metric.getValue());
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

