/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AutotuneMetricOperator
implements Serializable {
    public static final int EQUALS = 0;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int GREATER_THAN_EQUALS = 3;
    public static final int LESS_THAN_EQUALS = 4;
    public static final int BETWEEN = 5;
    public static final int IS = 6;
    public static final int DELTA_TA = 7;
    public static final int DELTA_AT = 8;
    public static final int DELTA_ABS = 9;
    protected int operation;
    protected boolean truth = false;
    protected double delta = 0.0;

    boolean test(AbleLiteral ableLiteral, AbleLiteral ableLiteral2) throws AbleDataException {
        this.truth = false;
        switch (this.operation) {
            case 0: {
                this.truth = ableLiteral2.cmpEq((AbleRd)ableLiteral);
                break;
            }
            case 1: {
                this.truth = ableLiteral2.cmpGt((AbleRd)ableLiteral);
                break;
            }
            case 2: {
                this.truth = ableLiteral2.cmpLt((AbleRd)ableLiteral);
                break;
            }
            case 3: {
                this.truth = ableLiteral2.cmpGtEq((AbleRd)ableLiteral);
                break;
            }
            case 4: {
                this.truth = ableLiteral2.cmpLtEq((AbleRd)ableLiteral);
                break;
            }
            default: {
                if (!Able.TraceLog.isLogging()) break;
                Able.TraceLog.text(262144L, (Object)this, "", "Operator " + AutotuneMetricOperator.toString(this.operation) + " is not yet implemented.");
            }
        }
        return this.truth;
    }

    public double computeDelta(AbleLiteral ableLiteral, AbleLiteral ableLiteral2) throws AbleDataException {
        this.delta = 0.0;
        switch (this.operation) {
            case 8: {
                this.delta = ableLiteral2.getNumericValue() - ableLiteral.getNumericValue();
                break;
            }
            case 7: {
                this.delta = ableLiteral.getNumericValue() - ableLiteral2.getNumericValue();
                break;
            }
            case 9: {
                this.delta = Math.abs(ableLiteral2.getNumericValue() - ableLiteral.getNumericValue());
            }
        }
        return this.delta;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    private static String toString(int n) {
        switch (n) {
            case 0: {
                return "=";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return "<";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return ">= && <=";
            }
            case 6: {
                return "is";
            }
            case 7: {
                return "target - actual";
            }
            case 8: {
                return "actual - target";
            }
            case 9: {
                return "abs(target - actual)";
            }
        }
        return "unknown";
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

