/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleException;
import com.ibm.able.autotune.AutotuneAdaptor;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneMetricCollection;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AutotuneMetricManager
implements Serializable {
    AutotuneMetricCollection allMetrics = new AutotuneMetricCollection();
    AutotuneMetricCollection loggingMetrics = new AutotuneMetricCollection();

    public void init(Vector vector) throws AbleException {
        this.allMetrics.removeAll();
        for (int i = 0; i < vector.size(); ++i) {
            this.addAdaptorMetrics((AutotuneAdaptor)vector.elementAt(i));
        }
    }

    public void addMetric(AutotuneMetric autotuneMetric) {
        this.allMetrics.addMetric(autotuneMetric);
    }

    public void removeMetric(AutotuneMetric autotuneMetric) {
        this.allMetrics.removeMetric(autotuneMetric);
    }

    public Hashtable getAllMetrics() {
        return this.allMetrics.getMetrics();
    }

    public AutotuneMetric getMetric(String string) {
        return this.allMetrics.getMetric(string);
    }

    public Vector getWorkloadMetrics() {
        return this.allMetrics.getWorkloadMetrics();
    }

    public Vector getConfigurationMetrics() {
        return this.allMetrics.getConfigurationMetrics();
    }

    public Vector getServiceLevelMetrics() {
        return this.allMetrics.getServiceLevelMetrics();
    }

    public Vector getTuningControlMetrics() {
        return this.allMetrics.getTuningControlMetrics();
    }

    public AutotuneMetricCollection getMetrics() {
        return this.allMetrics;
    }

    public AutotuneMetricCollection getLoggingMetrics() {
        return this.loggingMetrics;
    }

    public void setLoggingMetrics(AutotuneMetricCollection autotuneMetricCollection) {
        this.loggingMetrics = autotuneMetricCollection;
    }

    public void addAdaptorMetrics(AutotuneAdaptor autotuneAdaptor) throws AbleException {
        AutotuneMetric autotuneMetric;
        int n;
        AutotuneMetricCollection autotuneMetricCollection = autotuneAdaptor.getMetrics();
        Vector vector = autotuneMetricCollection.getWorkloadMetrics();
        for (n = 0; n < vector.size(); ++n) {
            autotuneMetric = (AutotuneMetric)vector.elementAt(n);
            this.allMetrics.addMetric(autotuneMetric);
        }
        vector = autotuneMetricCollection.getConfigurationMetrics();
        for (n = 0; n < vector.size(); ++n) {
            autotuneMetric = (AutotuneMetric)vector.elementAt(n);
            this.allMetrics.addMetric(autotuneMetric);
        }
        vector = autotuneMetricCollection.getServiceLevelMetrics();
        for (n = 0; n < vector.size(); ++n) {
            autotuneMetric = (AutotuneMetric)vector.elementAt(n);
            this.allMetrics.addMetric(autotuneMetric);
        }
        vector = autotuneMetricCollection.getTuningControlMetrics();
        for (n = 0; n < vector.size(); ++n) {
            autotuneMetric = (AutotuneMetric)vector.elementAt(n);
            this.allMetrics.addMetric(autotuneMetric);
        }
    }

    public void setLogData(boolean bl) {
        this.loggingMetrics.setLogData(bl);
    }

    public boolean getLogData() {
        return this.loggingMetrics.getLogData();
    }

    public boolean isLogData() {
        return this.loggingMetrics.isLogData();
    }

    public void setLogDataFileName(String string) {
        this.loggingMetrics.setLogDataFileName(string);
    }

    public String getLogDataFileName() {
        return this.loggingMetrics.getLogDataFileName();
    }

    public void writeLogData() throws AbleException {
        this.loggingMetrics.writeLogData();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

