/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.autotune.AutotuneConfigurationMetric;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneServiceLevelMetric;
import com.ibm.able.autotune.AutotuneTuningControlMetric;
import com.ibm.able.autotune.AutotuneWorkloadMetric;
import com.ibm.able.beans.AbleExport;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleLiteral;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AutotuneMetricCollection
implements Serializable {
    protected Hashtable metrics = new Hashtable();
    protected Vector workloadMetrics = new Vector();
    protected Vector configurationMetrics = new Vector();
    protected Vector serviceLevelMetrics = new Vector();
    protected Vector tuningControlMetrics = new Vector();
    protected AbleExport exportBean = null;
    protected boolean logData = false;
    public static final String DefaultLogDataFileName = "autotune.log";
    protected String logDataFileName = "autotune.log";
    private static String exportRepositoryName = "AutotuneRepository";
    private static String exportMetadataName = "AutotuneRepository-MetaData";

    public void addMetric(AutotuneMetric autotuneMetric) {
        if (this.metrics.contains(autotuneMetric.getName())) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)this, "addMetric", "addMetric() Warning: Metric " + autotuneMetric.getName() + " already is in this metric collection ");
            }
            return;
        }
        this.metrics.put(autotuneMetric.getName(), autotuneMetric);
        if (autotuneMetric instanceof AutotuneServiceLevelMetric) {
            this.serviceLevelMetrics.addElement(autotuneMetric);
        }
        if (autotuneMetric instanceof AutotuneConfigurationMetric) {
            this.configurationMetrics.addElement(autotuneMetric);
        }
        if (autotuneMetric instanceof AutotuneWorkloadMetric) {
            this.workloadMetrics.addElement(autotuneMetric);
        }
        if (autotuneMetric instanceof AutotuneTuningControlMetric) {
            this.tuningControlMetrics.addElement(autotuneMetric);
        }
    }

    public void removeMetric(AutotuneMetric autotuneMetric) {
        if (this.metrics.contains(autotuneMetric.getName())) {
            this.metrics.remove(autotuneMetric.getName());
            if (autotuneMetric instanceof AutotuneServiceLevelMetric) {
                this.serviceLevelMetrics.removeElement(autotuneMetric);
            }
            if (autotuneMetric instanceof AutotuneConfigurationMetric) {
                this.configurationMetrics.removeElement(autotuneMetric);
            }
            if (autotuneMetric instanceof AutotuneWorkloadMetric) {
                this.workloadMetrics.removeElement(autotuneMetric);
            }
            if (autotuneMetric instanceof AutotuneTuningControlMetric) {
                this.tuningControlMetrics.removeElement(autotuneMetric);
            }
        } else if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, (Object)this, "removeMetric()", "Warning: Metric " + autotuneMetric.getName() + " is not in this metric collection");
        }
    }

    public void removeAll() {
        this.metrics.clear();
        this.serviceLevelMetrics.removeAllElements();
        this.configurationMetrics.removeAllElements();
        this.workloadMetrics.removeAllElements();
        this.tuningControlMetrics.removeAllElements();
    }

    public boolean isEmpty() {
        return this.metrics.isEmpty();
    }

    public Hashtable getMetrics() {
        return (Hashtable)this.metrics.clone();
    }

    public AutotuneMetric[] getMetrics(String[] stringArray) {
        AutotuneMetric[] autotuneMetricArray = new AutotuneMetric[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            autotuneMetricArray[i] = (AutotuneMetric)this.metrics.get(stringArray[i]);
        }
        return autotuneMetricArray;
    }

    public double[] getMetricValues(AutotuneMetric[] autotuneMetricArray) throws AbleDataException {
        double[] dArray = new double[autotuneMetricArray.length];
        for (int i = 0; i < autotuneMetricArray.length; ++i) {
            AbleLiteral ableLiteral = autotuneMetricArray[i].getValue();
        }
        return dArray;
    }

    public double[] getMetricValues(String[] stringArray) throws AbleDataException {
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            AutotuneMetric autotuneMetric = (AutotuneMetric)this.metrics.get(stringArray[i]);
            if (autotuneMetric == null) {
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(524288L, (Object)this, "getMetricValues", "Error in getMetricValues(): metric name " + stringArray[i] + " is invalid");
                }
                throw new AbleDataException(Able.NlsMsg((String)"Ex_AuUnknownMetric_NoValue", (Object[])new Object[]{stringArray[i]}));
            }
            AbleLiteral ableLiteral = autotuneMetric.getValue();
            dArray[i] = ableLiteral.getNumericValue();
        }
        return dArray;
    }

    public AutotuneMetric getMetric(String string) {
        return (AutotuneMetric)this.metrics.get(string);
    }

    public Vector getWorkloadMetrics() {
        return this.workloadMetrics;
    }

    public Vector getConfigurationMetrics() {
        return this.configurationMetrics;
    }

    public Vector getServiceLevelMetrics() {
        return this.serviceLevelMetrics;
    }

    public Vector getTuningControlMetrics() {
        return this.tuningControlMetrics;
    }

    public void setLogData(boolean bl) {
        this.logData = bl;
    }

    public boolean getLogData() {
        return this.logData;
    }

    public boolean isLogData() {
        return this.logData;
    }

    public void setLogDataFileName(String string) {
        this.logDataFileName = string;
    }

    public String getLogDataFileName() {
        return this.logDataFileName;
    }

    public void writeLogData() throws AbleException {
        if (this.logData && this.exportBean == null) {
            this.openLogDataFile();
        }
        this.logData(this.exportBean);
    }

    public void eraseLogDataFile() throws AbleException {
        if (this.exportBean != null) {
            this.exportBean.erase();
        }
    }

    public void closeLogDataFile() throws AbleException {
        if (this.exportBean != null) {
            this.exportBean.close();
        }
    }

    public void openLogDataFile() throws AbleException {
        if (this.exportBean == null) {
            this.exportBean = new AbleExport(exportRepositoryName);
            this.exportBean.setDataFileName(this.logDataFileName);
            this.generateDFNFile();
        }
        this.exportBean.init();
    }

    public void generateDFNFile() throws AbleException {
        AbleExport ableExport = null;
        String string = "";
        try {
            AbleLiteral ableLiteral;
            AutotuneMetric autotuneMetric;
            int n;
            ableExport = new AbleExport(exportMetadataName);
            ableExport.setDataFileName(this.logDataFileName + ".dfn");
            ableExport.init();
            ableExport.setInputBuffer((Object)new String[2]);
            Vector vector = this.configurationMetrics;
            for (n = 0; n < vector.size(); ++n) {
                autotuneMetric = (AutotuneMetric)vector.elementAt(n);
                ableLiteral = autotuneMetric.getValue();
                if (ableLiteral.getDataType() == 4) {
                    string = AbleData.DataType((int)13);
                }
                if (ableLiteral.getDataType() == 5) {
                    string = AbleData.DataType((int)12);
                }
                ableExport.setInputBuffer(0, (Object)string);
                ableExport.setInputBuffer(1, (Object)autotuneMetric.getName());
                ableExport.process();
            }
            vector = this.workloadMetrics;
            for (n = 0; n < vector.size(); ++n) {
                autotuneMetric = (AutotuneMetric)vector.elementAt(n);
                ableLiteral = autotuneMetric.getValue();
                if (ableLiteral.getDataType() == 4) {
                    string = AbleData.DataType((int)13);
                }
                if (ableLiteral.getDataType() == 5) {
                    string = AbleData.DataType((int)12);
                }
                ableExport.setInputBuffer(0, (Object)string);
                ableExport.setInputBuffer(1, (Object)autotuneMetric.getName());
                ableExport.process();
            }
            vector = this.serviceLevelMetrics;
            for (n = 0; n < vector.size(); ++n) {
                autotuneMetric = (AutotuneMetric)vector.elementAt(n);
                ableLiteral = autotuneMetric.getValue();
                if (ableLiteral.getDataType() == 4) {
                    string = AbleData.DataType((int)13);
                }
                if (ableLiteral.getDataType() == 5) {
                    string = AbleData.DataType((int)12);
                }
                ableExport.setInputBuffer(0, (Object)string);
                ableExport.setInputBuffer(1, (Object)autotuneMetric.getName());
                ableExport.process();
            }
            vector = this.tuningControlMetrics;
            for (n = 0; n < vector.size(); ++n) {
                autotuneMetric = (AutotuneMetric)vector.elementAt(n);
                ableLiteral = autotuneMetric.getValue();
                if (ableLiteral.getDataType() == 4) {
                    string = AbleData.DataType((int)13);
                }
                if (ableLiteral.getDataType() == 5) {
                    string = AbleData.DataType((int)12);
                }
                ableExport.setInputBuffer(0, (Object)string);
                ableExport.setInputBuffer(1, (Object)autotuneMetric.getName());
                ableExport.process();
            }
        }
        catch (AbleException ableException) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "generateDFNFile", "Error in writing logData metadata file");
                Able.TraceLog.exception(262144L, (Object)this, "generateDFNFile", (Throwable)ableException);
            }
            Able.MessageLog.text(4L, (Object)this, "generateDFNFile", ableException.getLocalizedMessage());
            throw ableException;
        }
        ableExport.close();
    }

    public void logData(AbleExport ableExport) throws AbleException {
        int n = 0;
        try {
            int n2;
            int n3 = 0;
            Object object = ableExport.getInputBuffer();
            if (object instanceof double[]) {
                n3 = ((double[])object).length;
            }
            if (object instanceof String[]) {
                n3 = ((String[])object).length;
            }
            if (n3 != this.metrics.size()) {
                ableExport.setInputBuffer((Object)new String[this.metrics.size()]);
            }
            Vector vector = this.configurationMetrics;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ableExport.setInputBuffer(n2 + n, (Object)((AutotuneMetric)vector.elementAt(n2)).getStringValue());
            }
            n += vector.size();
            vector = this.workloadMetrics;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ableExport.setInputBuffer(n2 + n, (Object)((AutotuneMetric)vector.elementAt(n2)).getStringValue());
            }
            n += vector.size();
            vector = this.serviceLevelMetrics;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ableExport.setInputBuffer(n2 + n, (Object)((AutotuneMetric)vector.elementAt(n2)).getStringValue());
            }
            n += vector.size();
            vector = this.tuningControlMetrics;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ableExport.setInputBuffer(n2 + n, (Object)((AutotuneMetric)vector.elementAt(n2)).getStringValue());
            }
            ableExport.process();
        }
        catch (AbleException ableException) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "logData", "Error in writing to logData.");
                Able.TraceLog.exception(262144L, (Object)this, "logData", (Throwable)ableException);
            }
            Able.MessageLog.text(4L, (Object)this, "logData", ableException.getLocalizedMessage());
            throw ableException;
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

