/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleVariable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class AutotuneMetric
implements Serializable {
    protected String name;
    protected AbleVariable myInitialValue;
    protected AbleVariable myValue;
    protected int referenceCount = 0;
    protected AbleUserDefinedFunction sensor = null;
    protected Object[] sensorArgs = new Object[0];

    public AutotuneMetric() {
    }

    public AutotuneMetric(String string) {
        this.name = string;
    }

    public AutotuneMetric(String string, AbleVariable ableVariable) {
        this.name = string;
        this.myInitialValue = ableVariable;
        this.myValue = ableVariable;
    }

    public AutotuneMetric(String string, AbleVariable ableVariable, AbleUserDefinedFunction ableUserDefinedFunction, Object[] objectArray) {
        this.name = string;
        this.myInitialValue = ableVariable;
        this.myValue = ableVariable;
        this.sensor = ableUserDefinedFunction;
        this.sensorArgs = objectArray;
    }

    public AutotuneMetric(String string, AbleVariable ableVariable, AbleUserDefinedFunction ableUserDefinedFunction) {
        this.name = string;
        this.myInitialValue = ableVariable;
        this.myValue = ableVariable;
        this.sensor = ableUserDefinedFunction;
    }

    public String getName() {
        return this.name;
    }

    public void refreshValue() {
        if (this.sensor != null) {
            try {
                this.myValue.setValue((AbleLiteral)new AbleGenericLiteral(this.sensor.invoke(this.sensorArgs)));
            }
            catch (AbleException ableException) {
                Able.MessageLog.text(4L, (Object)this, "refreshValue", ableException.getLocalizedMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Able.MessageLog.text(4L, (Object)this, "refreshValue", noSuchMethodException.getLocalizedMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Able.MessageLog.text(4L, (Object)this, "refreshValue", invocationTargetException.getTargetException().getLocalizedMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                Able.MessageLog.text(4L, (Object)this, "refreshValue", illegalAccessException.getLocalizedMessage());
            }
        }
    }

    public AbleVariable getInitialValue() {
        return this.myInitialValue;
    }

    public String toString() {
        if (this.myValue == null) {
            return this.name;
        }
        return this.name + "=" + this.myValue.toString();
    }

    public void addReference() {
        ++this.referenceCount;
    }

    public void removeReference() {
        --this.referenceCount;
        if (this.referenceCount < 0) {
            this.referenceCount = 0;
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)this, "removeReference", "Error: '" + this.name + "' metric reference count is negative");
            }
        }
    }

    public boolean isActive() {
        return this.referenceCount > 0;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue.getBooleanValue();
    }

    public AbleLiteral getFuzzyValue() throws AbleDataException {
        return this.myValue.getFuzzyValue();
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue.getGenericValue();
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue.getNumericValue();
    }

    public String getStringValue() throws AbleDataException {
        return this.myValue.getStringValue();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this.myValue.getValue();
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        this.myValue.setBooleanValue(bl);
    }

    public void setGenericValue(Object object) throws AbleDataException {
        this.myValue.setGenericValue(object);
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.myValue.setNumericValue(d);
    }

    public void setStringValue(String string) throws AbleDataException {
        this.myValue.setStringValue(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.myValue.setValue(ableLiteral);
    }

    public String xmlDclString() {
        String string = "";
        return string;
    }

    public String xmlCWrString() {
        String string = "";
        return string;
    }

    public void reset() throws AbleDataException {
        this.myValue.reset();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

