/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleRemoteDefaultAgent;
import com.ibm.able.autotune.AutotuneAdaptor;
import com.ibm.able.autotune.AutotuneAgentDataBean;
import com.ibm.able.autotune.AutotuneAgentIf;
import com.ibm.able.autotune.AutotuneController;
import com.ibm.able.autotune.AutotuneDataBean;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneMetricCollection;
import com.ibm.able.autotune.AutotuneMetricManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

public class AutotuneAgent
extends AbleRemoteDefaultAgent
implements AutotuneAgentIf,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    protected AutotuneController masterController = null;
    protected AutotuneMetricManager metricManager = new AutotuneMetricManager();
    protected int controllerRate = 5000;
    protected boolean synchronousAdaptorMode = true;
    protected int defaultAdaptorRate = 5000;
    protected String dataRepositoryPath;
    protected AutotuneAgentIf remoteAgent;
    protected AutotuneDataBean dataBean;

    public AutotuneAgent() throws AbleException, RemoteException {
        this("AutotuneAgent");
    }

    public AutotuneAgent(String string) throws AbleException, RemoteException {
        super(string);
        this.setControllerRate(5000);
        this.reset();
        this.dataBean = new AutotuneAgentDataBean(this);
    }

    public void setSynchronousAdaptorMode(boolean bl) throws AbleException {
        this.synchronousAdaptorMode = bl;
    }

    public boolean isSynchronousAdaptorMode() throws AbleException {
        return this.synchronousAdaptorMode;
    }

    public void setControllerRate(int n) throws AbleException {
        this.setSleepTime(n);
        this.controllerRate = n;
    }

    public int getControllerRate() throws AbleException {
        return this.controllerRate;
    }

    public void setDefaultAdaptorRate(int n) throws AbleException {
        this.defaultAdaptorRate = n;
    }

    public int getDefaultAdaptorRate() throws AbleException {
        return this.defaultAdaptorRate;
    }

    public void setDataRepositoryPath(String string) throws AbleException {
        this.dataRepositoryPath = string;
    }

    public String getDataRepositoryPath() throws AbleException {
        return this.dataRepositoryPath;
    }

    public AutotuneController getMasterController() throws AbleException {
        return this.masterController;
    }

    public void setMasterController(AutotuneController autotuneController) throws AbleException {
        this.masterController = autotuneController;
    }

    public boolean setMasterController(String string) throws AbleException {
        boolean bl = false;
        Iterator iterator = this.myBeans.values().iterator();
        while (iterator.hasNext()) {
            AbleBean ableBean = (AbleBean)iterator.next();
            if (!(ableBean instanceof AutotuneController)) continue;
            AutotuneController autotuneController = (AutotuneController)ableBean;
            if (!ableBean.getName().equals(string)) break;
            bl = true;
            this.setMasterController(autotuneController);
            break;
        }
        return bl;
    }

    public AutotuneMetricCollection getMetrics() throws AbleException {
        return this.metricManager.getMetrics();
    }

    public AutotuneMetricCollection getLoggingMetrics() throws AbleException {
        return this.metricManager.getLoggingMetrics();
    }

    public void setLoggingMetrics(AutotuneMetricCollection autotuneMetricCollection) throws AbleException {
        this.metricManager.setLoggingMetrics(autotuneMetricCollection);
    }

    public AutotuneMetric getMetric(String string) throws AbleException {
        return this.metricManager.getMetric(string);
    }

    public void setLogData(boolean bl) throws AbleException {
        this.metricManager.setLogData(bl);
    }

    public boolean getLogData() throws AbleException {
        return this.metricManager.getLogData();
    }

    public boolean isLogData() throws AbleException {
        return this.metricManager.isLogData();
    }

    public void setLogDataFileName(String string) throws AbleException {
        this.metricManager.setLogDataFileName(string);
    }

    public String getLogDataFileName() throws AbleException {
        return this.metricManager.getLogDataFileName();
    }

    public void process() throws AbleException {
        if (this.synchronousAdaptorMode) {
            Vector vector = this.getAdaptors();
            for (int i = 0; i < vector.size(); ++i) {
                AbleBean ableBean = (AbleBean)vector.elementAt(i);
                ableBean.process();
            }
        }
        if (this.masterController != null) {
            ((AbleBean)this.masterController).process();
        }
        if (this.metricManager.isLogData()) {
            this.metricManager.writeLogData();
        }
        if (!this.hasRemoteAgent()) {
            this.dataBean.load();
            this.dataChanged(this.dataBean);
        } else {
            this.dataChanged(this);
        }
    }

    public void processTimerEvent() throws AbleException {
        this.process();
    }

    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "processAbleEvent(arg) " + this.name, new Object[]{ableEvent});
        }
        Object object = ableEvent.getArgObject();
        if (this.hasRemoteAgent() && ableEvent.getId() == 1) {
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "processAbleEvent", "DataChanged event received!");
            }
            if (object instanceof AutotuneDataBean) {
                ((AutotuneDataBean)object).save(this);
            }
            this.dataChanged(this);
            if (this.masterController != null) {
                ((AbleBean)this.masterController).dataChanged((Object)this);
            }
        } else {
            super.processAbleEvent(ableEvent);
        }
    }

    public void writeLogData() throws AbleException {
        this.metricManager.writeLogData();
    }

    public void reset() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(true);
    }

    public void init() throws AbleException {
        Vector vector = this.getAdaptors();
        for (int i = 0; i < vector.size(); ++i) {
            AbleBean ableBean = (AbleBean)vector.elementAt(i);
            ableBean.init();
        }
        this.metricManager.init(vector);
        Vector vector2 = this.getControllers();
        for (int i = 0; i < vector2.size(); ++i) {
            AbleBean ableBean = (AbleBean)vector2.elementAt(i);
            if (i == 0 && this.masterController == null) {
                this.masterController = (AutotuneController)ableBean;
            }
            ableBean.init();
        }
        if (vector.size() > 0) {
            this.masterController.setAdaptor((AutotuneAdaptor)vector.elementAt(0));
        }
        super.init();
    }

    public Vector getAdaptors() throws AbleException {
        Vector<AbleBean> vector = new Vector<AbleBean>();
        Iterator iterator = this.myBeans.values().iterator();
        while (iterator.hasNext()) {
            AbleBean ableBean = (AbleBean)iterator.next();
            if (!(ableBean instanceof AutotuneAdaptor)) continue;
            vector.addElement(ableBean);
        }
        return vector;
    }

    public Vector getControllers() throws AbleException {
        Vector<AbleBean> vector = new Vector<AbleBean>();
        Iterator iterator = this.myBeans.values().iterator();
        while (iterator.hasNext()) {
            AbleBean ableBean = (AbleBean)iterator.next();
            if (!(ableBean instanceof AutotuneController)) continue;
            vector.addElement(ableBean);
        }
        return vector;
    }

    public void setRemoteAgent(AutotuneAgentIf autotuneAgentIf) {
        this.remoteAgent = autotuneAgentIf;
    }

    public AutotuneAgentIf getRemoteAgent() {
        return this.remoteAgent;
    }

    public boolean hasRemoteAgent() {
        return this.remoteAgent != null;
    }

    public void setDataBean(Object object) {
    }

    public Object getDataBean() {
        return null;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

