/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleX;
import com.ibm.able.agents.AbleScriptAgent;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.Vector;

public class AbleJavaScriptAgent
extends AbleScriptAgent {
    public static final String defaultName = AbleX.NlsMsg("DFLT_NAME_JavaScriptAgent");
    protected static final long serialVersionUID = 2001100500100300001L;
    private static final String JavaScriptLanguage = "javascript";
    protected transient BSFManager mgr = new BSFManager();
    protected transient BSFEngine rhinoEngine = null;
    protected String initScript = null;
    protected String processScript = null;
    protected String processTimerScript = null;

    public AbleJavaScriptAgent() throws AbleException {
        super(defaultName);
    }

    public void init() throws AbleException {
        try {
            Object object;
            this.rhinoEngine = this.mgr.loadScriptingEngine(JavaScriptLanguage);
            this.mgr.registerBean("agent", (Object)this);
            Vector vector = this.getBeans();
            for (int i = 0; i < vector.size(); ++i) {
                object = (AbleBean)vector.get(i);
                this.mgr.registerBean(object.getName(), object);
            }
            if (this.initScriptFileName != null && this.initScriptFileName.length() > 0) {
                FileReader fileReader = new FileReader(this.initScriptFileName);
                this.initScript = IOUtils.getStringFromReader((Reader)fileReader);
                object = BSFManager.getLangFromFilename((String)this.initScriptFileName);
                if (!JavaScriptLanguage.equals(object) && this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "init()", "Init scripting language is " + (String)object + " rather than " + JavaScriptLanguage + ".");
                }
            }
            if (this.processScriptFileName != null && this.processScriptFileName.length() > 0) {
                FileReader fileReader = new FileReader(this.processScriptFileName);
                this.processScript = IOUtils.getStringFromReader((Reader)fileReader);
                object = BSFManager.getLangFromFilename((String)this.processScriptFileName);
                if (!JavaScriptLanguage.equals(object) && this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "init()", "Process scripting language is " + (String)object + " rather than " + JavaScriptLanguage + ".");
                }
            }
            if (this.processTimerScriptFileName != null && this.processTimerScriptFileName.length() > 0) {
                FileReader fileReader = new FileReader(this.processTimerScriptFileName);
                this.processTimerScript = IOUtils.getStringFromReader((Reader)fileReader);
                object = BSFManager.getLangFromFilename((String)this.processTimerScriptFileName);
                if (!JavaScriptLanguage.equals(object) && this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "init()", "ProcessTimer scripting language is " + (String)object + " rather than " + JavaScriptLanguage + ".");
                }
            }
            if (this.initScript != null) {
                this.mgr.exec(JavaScriptLanguage, this.initScriptFileName, -1, -1, (Object)this.initScript);
            }
        }
        catch (AbleException ableException) {
            throw ableException;
        }
        catch (BSFException bSFException) {
            this.logger.text(4L, (Object)this, "init()", bSFException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init()", (Throwable)bSFException);
            }
            throw new AbleException(bSFException.getLocalizedMessage(), (Throwable)bSFException);
        }
        catch (IOException iOException) {
            this.logger.text(4L, (Object)this, "init()", iOException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init()", (Throwable)iOException);
            }
            throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        if (this.isAbleEventProcessingEnabled() || this.isTimerEventProcessingEnabled()) {
            this.startEnabledEventProcessing();
        } else {
            int n = this.state.getState();
            this.state.setState(1022);
            this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1022));
        }
    }

    public void process() throws AbleException {
        try {
            if (this.processScript != null) {
                this.mgr.exec(JavaScriptLanguage, this.processScriptFileName, -1, -1, (Object)this.processScript);
            }
        }
        catch (BSFException bSFException) {
            this.logger.text(4L, (Object)this, "process()", bSFException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "process()", (Throwable)bSFException);
            }
            throw new AbleException(bSFException.getLocalizedMessage(), (Throwable)bSFException);
        }
    }

    public void processTimerEvent() throws AbleException {
        try {
            if (this.processTimerScript != null) {
                this.mgr.exec(JavaScriptLanguage, this.processTimerScriptFileName, -1, -1, (Object)this.processTimerScript);
            }
        }
        catch (BSFException bSFException) {
            this.logger.text(4L, (Object)this, "processTimerEvent()", bSFException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "processTimerEvent()", (Throwable)bSFException);
            }
            throw new AbleException(bSFException.getLocalizedMessage(), (Throwable)bSFException);
        }
    }

    public void addBean(AbleBean ableBean) throws AbleException {
        if (ableBean != null) {
            this.mgr.registerBean(ableBean.getName(), (Object)ableBean);
            super.addBean(ableBean);
        }
    }

    public void removeBean(AbleBean ableBean) throws AbleException {
        if (ableBean != null) {
            this.mgr.unregisterBean(ableBean.getName());
            super.removeBean(ableBean);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.mgr = new BSFManager();
        try {
            this.rhinoEngine = this.mgr.loadScriptingEngine(JavaScriptLanguage);
            Vector vector = this.getBeans();
            for (int i = 0; i < vector.size(); ++i) {
                AbleBean ableBean = (AbleBean)vector.get(i);
                this.mgr.registerBean(ableBean.getName(), (Object)ableBean);
            }
        }
        catch (BSFException bSFException) {
            this.logger.text(4L, (Object)this, "readObject()", bSFException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject()", (Throwable)bSFException);
            }
            return;
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

