/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Convert {
    public static final String toQuotedString(Object object) {
        return Convert.toQuotedString(object.toString());
    }

    public static final String toQuotedString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        int n = stringBuffer.length() - 2;
        while (n > 0) {
            if (stringBuffer.charAt(n) == '\"' && stringBuffer.charAt(n - 1) != '\\') {
                stringBuffer.insert(n, '\\');
            }
            --n;
        }
        if (stringBuffer.charAt(0) != '\"' && stringBuffer.charAt(stringBuffer.length() - 1) != '\"') {
            stringBuffer.insert(0, '\"').append('\"');
        }
        return stringBuffer.toString();
    }

    public static final String fromQuotedString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        int n = stringBuffer.length() - 2;
        while (n > 0) {
            if (stringBuffer.charAt(n) == '\"' && stringBuffer.charAt(n - 1) == '\\') {
                stringBuffer.deleteCharAt(n - 1);
            }
            --n;
        }
        if (stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
            stringBuffer.deleteCharAt(0).deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static final char[] toCharArray(String string) {
        return Convert.toCharArray(string.getBytes());
    }

    public static final char[] toCharArray(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[2 * n];
        byte by = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n3 = n2 << 1;
            by = byArray[n2];
            cArray[n3] = Convert.nibbleToHexChar(by >> 4);
            cArray[n3 + 1] = Convert.nibbleToHexChar(by);
            ++n2;
        }
        return cArray;
    }

    public static final byte[] toByteArray(char[] cArray) {
        int n = cArray.length / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n) {
            n3 = n2 << 1;
            n4 = Convert.hexCharToNibble(cArray[n3]) << 4;
            n5 = Convert.hexCharToNibble(cArray[n3 + 1]);
            byArray[n2] = (byte)(n4 | n5);
            ++n2;
        }
        return byArray;
    }

    public static final char nibbleToHexChar(int n) {
        char c = ' ';
        switch ((byte)(n & 0xF)) {
            case 0: {
                c = '0';
                break;
            }
            case 1: {
                c = '1';
                break;
            }
            case 2: {
                c = '2';
                break;
            }
            case 3: {
                c = '3';
                break;
            }
            case 4: {
                c = '4';
                break;
            }
            case 5: {
                c = '5';
                break;
            }
            case 6: {
                c = '6';
                break;
            }
            case 7: {
                c = '7';
                break;
            }
            case 8: {
                c = '8';
                break;
            }
            case 9: {
                c = '9';
                break;
            }
            case 10: {
                c = 'A';
                break;
            }
            case 11: {
                c = 'B';
                break;
            }
            case 12: {
                c = 'C';
                break;
            }
            case 13: {
                c = 'D';
                break;
            }
            case 14: {
                c = 'E';
                break;
            }
            case 15: {
                c = 'F';
            }
        }
        return c;
    }

    public static final int hexCharToNibble(char c) {
        int n = -1;
        switch (c) {
            case '0': {
                n = 0;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case 'A': 
            case 'a': {
                n = 10;
                break;
            }
            case 'B': 
            case 'b': {
                n = 11;
                break;
            }
            case 'C': 
            case 'c': {
                n = 12;
                break;
            }
            case 'D': 
            case 'd': {
                n = 13;
                break;
            }
            case 'E': 
            case 'e': {
                n = 14;
                break;
            }
            case 'F': 
            case 'f': {
                n = 15;
            }
        }
        return n;
    }

    public static final Object toObject(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static final byte[] toByteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

