/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.xml;

import javax.agent.AgentName;
import javax.agent.Envelope;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAct;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrConnective;
import org.jagent.acr.AcrConstructor;
import org.jagent.acr.AcrDateTime;
import org.jagent.acr.AcrEnvelope;
import org.jagent.acr.AcrLabel;
import org.jagent.acr.AcrLocator;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrNumber;
import org.jagent.acr.AcrObject;
import org.jagent.acr.AcrPayload;
import org.jagent.acr.AcrPredication;
import org.jagent.acr.AcrQuantifier;
import org.jagent.acr.AcrReference;
import org.jagent.acr.AcrSerializer;
import org.jagent.acr.AcrString;
import org.jagent.acr.AcrSymbol;
import org.jagent.acr.AcrTransportMessage;
import org.jagent.acr.AcrTuple;
import org.jagent.acr.AcrVariable;
import org.jagent.transform.xml.JasAcrXMLConstants;
import org.jagent.util.Convert;

public final class JasAcrXMLSerializer
extends AcrSerializer
implements JasAcrXMLConstants {
    private static final String PROPERTIES = "jas.acr.node-properties";

    public void clear() {
        super.clear();
        this.write("<?xml version=\"1.0\"?>\n");
        this.write("<!DOCTYPE aclmessage SYSTEM 'AbstractContent.dtd'>\n");
    }

    public String toString() {
        return super.toString();
    }

    protected AcrSerializer open() {
        this.write("<");
        return this;
    }

    protected AcrSerializer close() {
        this.write(">");
        return this;
    }

    protected AcrSerializer separator() {
        return this;
    }

    protected void header(String string) {
        this.indent();
        this.open();
        this.write(string);
        this.close();
        this.newln();
        this.pushIndent();
    }

    protected void footer(String string) {
        this.popIndent();
        this.indent();
        this.open();
        this.write("/");
        this.write(string);
        this.close();
        this.newln();
    }

    protected void entry(String string, String string2) {
        this.indent();
        this.open();
        this.write(string);
        this.close();
        this.write(string2);
        this.open();
        this.write("/");
        this.write(string);
        this.close();
        this.newln();
    }

    protected void entry(AcrNode acrNode, String string, String string2) {
        if (!acrNode.containsKey(PROPERTIES)) {
            this.entry(string, string2);
        } else {
            this.header(acrNode, string);
            this.indent();
            this.write(string2);
            this.newln();
            this.footer(acrNode, string);
        }
    }

    public void serialize(TransportMessage transportMessage) {
        this.serializeTransportMessage((AcrTransportMessage)transportMessage);
    }

    public void serialize(Envelope envelope) {
        this.serializeEnvelope((AcrEnvelope)envelope);
    }

    public void serialize(Payload payload) {
        this.serializePayload((AcrPayload)payload);
    }

    public void serialize(AgentName agentName) {
        this.serializeAgentName((AcrAgentName)agentName);
    }

    public void serialize(Locator locator) {
        this.serializeLocator((AcrLocator)locator);
    }

    public void serializeTransportMessage(AcrTransportMessage acrTransportMessage) {
        this.header(acrTransportMessage, "transportmessage");
        acrTransportMessage.getEnvelope().acceptSerializer(this);
        acrTransportMessage.getPayload().acceptSerializer(this);
        this.footer(acrTransportMessage, "transportmessage");
    }

    public void serializeEnvelope(AcrEnvelope acrEnvelope) {
        this.header(acrEnvelope, "envelope");
        this.header("receiver");
        this.serializeLocator((AcrLocator)acrEnvelope.getReceiver());
        this.footer("receiver");
        this.header("sender");
        this.serializeLocator((AcrLocator)acrEnvelope.getSender());
        this.footer("sender");
        this.footer(acrEnvelope, "envelope");
    }

    public void serializePayload(AcrPayload acrPayload) {
        this.header(acrPayload, "payload");
        acrPayload.getMessage().acceptSerializer(this);
        this.footer(acrPayload, "payload");
    }

    public void serializeAclMessage(AclMessage aclMessage) {
        this.header(aclMessage, "aclmessage");
        this.entry("performative", aclMessage.getPerformative());
        this.entry("sender", aclMessage.getSender());
        this.entry("receiver", aclMessage.getReceivers());
        this.entry("content", aclMessage.getContent());
        this.footer(aclMessage, "aclmessage");
    }

    public void serializeAct(AcrAct acrAct) {
        this.header(acrAct, "act");
        this.entry("agent", acrAct.getAgent());
        this.entry("action", acrAct.getAction());
        this.entry("patient", acrAct.getPatient());
        this.entry("instrument", acrAct.getInstrument());
        this.footer(acrAct, "act");
    }

    public void serializeDateTime(AcrDateTime acrDateTime) {
        this.header(acrDateTime, "datetime");
        this.indent();
        this.write(this.format(acrDateTime.getYear(), 4));
        this.write(this.format(acrDateTime.getMonth(), 2));
        this.write(this.format(acrDateTime.getDay(), 2));
        this.write("T");
        this.write(this.format(acrDateTime.getHour(), 2));
        this.write(this.format(acrDateTime.getMinute(), 2));
        this.write(this.format(acrDateTime.getSecond(), 2));
        this.write(this.format(acrDateTime.getMillis(), 3));
        this.write(acrDateTime.isUTC() ? "Z" : "");
        this.newln();
        this.footer(acrDateTime, "datetime");
    }

    public void serializeConnective(AcrConnective acrConnective) {
        this.header(acrConnective, "connective");
        this.entry("fqn", acrConnective.getName());
        AcrNode[] acrNodeArray = acrConnective.getArguments();
        int n = 0;
        int n2 = acrNodeArray.length;
        while (n < n2) {
            acrNodeArray[n].acceptSerializer(this);
            ++n;
        }
        this.footer(acrConnective, "connective");
    }

    public void serializeConstructor(AcrConstructor acrConstructor) {
        this.header(acrConstructor, "constructor");
        this.entry("fqn", acrConstructor.getName());
        this.entry("argument", acrConstructor.getArgument());
        this.footer(acrConstructor, "constructor");
    }

    public void serializeLabel(AcrLabel acrLabel) {
        this.header(acrLabel, "label");
        this.entry("fqn", acrLabel.getName());
        this.entry("argument", acrLabel.getArgument());
        this.footer(acrLabel, "label");
    }

    public void serializeLocator(AcrLocator acrLocator) {
        this.header(acrLocator, "locator");
        this.entry("type", acrLocator.getType());
        this.entry("address", acrLocator.getAddress());
        this.footer(acrLocator, "locator");
    }

    public void serializeObject(AcrObject acrObject) {
        try {
            byte[] byArray = Convert.toByteArray(acrObject.getObject());
            char[] cArray = Convert.toCharArray(byArray);
            this.entry(acrObject, "object", String.valueOf(cArray));
        }
        catch (Exception exception) {
            Object object = acrObject.getObject();
            String string = "Exception during serialization of " + object + "\n" + exception;
            throw new IllegalArgumentException(string);
        }
    }

    public void serializePredication(AcrPredication acrPredication) {
        this.header(acrPredication, "predication");
        this.entry("fqn", acrPredication.getName());
        this.entry("argument", acrPredication.getArgument());
        this.footer(acrPredication, "predication");
    }

    public void serializeQuantifier(AcrQuantifier acrQuantifier) {
        this.header(acrQuantifier, "quantifier");
        this.entry("fqn", acrQuantifier.getName());
        acrQuantifier.getVariable().acceptSerializer(this);
        acrQuantifier.getNode().acceptSerializer(this);
        this.footer(acrQuantifier, "quantifier");
    }

    public void serializeAgentName(AcrAgentName acrAgentName) {
        this.entry(acrAgentName, "agentname", acrAgentName.getName());
    }

    public void serializeNumber(AcrNumber acrNumber) {
        this.entry(acrNumber, "number", acrNumber.getNumber());
    }

    public void serializeString(AcrString acrString) {
        this.entry(acrString, "string", acrString.getString());
    }

    public void serializeSymbol(AcrSymbol acrSymbol) {
        this.entry(acrSymbol, "symbol", acrSymbol.getSymbol());
    }

    public void serializeVariable(AcrVariable acrVariable) {
        this.entry(acrVariable, "variable", acrVariable.getVariable());
    }

    public void serializeReference(AcrReference acrReference) {
        this.entry(acrReference, "reference", acrReference.getReference());
    }

    public void serializeTuple(AcrTuple acrTuple) {
        this.indent();
        this.open();
        this.write("tuple");
        this.write(" arity = \"");
        this.write(String.valueOf(acrTuple.getTupleArity()));
        this.write("\"");
        this.close();
        this.newln();
        this.pushIndent();
        this.listProperties(acrTuple);
        AcrNode[] acrNodeArray = acrTuple.getTupleElements();
        int n = 0;
        int n2 = acrNodeArray.length;
        while (n < n2) {
            acrNodeArray[n].acceptSerializer(this);
            ++n;
        }
        this.footer(acrTuple, "tuple");
    }

    private String format(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(n);
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }
}

