/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.xml;

import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.agent.Envelope;
import javax.agent.JasBean;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jagent.JasBeanImpl;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAct;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrConnective;
import org.jagent.acr.AcrConstructor;
import org.jagent.acr.AcrDateTime;
import org.jagent.acr.AcrEnvelope;
import org.jagent.acr.AcrLabel;
import org.jagent.acr.AcrLocator;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrNumber;
import org.jagent.acr.AcrObject;
import org.jagent.acr.AcrPayload;
import org.jagent.acr.AcrPredication;
import org.jagent.acr.AcrQuantifier;
import org.jagent.acr.AcrReference;
import org.jagent.acr.AcrString;
import org.jagent.acr.AcrSymbol;
import org.jagent.acr.AcrTransportMessage;
import org.jagent.acr.AcrTuple;
import org.jagent.acr.AcrVariable;
import org.jagent.transform.xml.JasAcrXMLConstants;
import org.jagent.util.Convert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class JasAcrXMLParser
implements JasAcrXMLConstants {
    private Hashtable table;
    private Element root;
    private static final String FQN = "fqn";

    JasAcrXMLParser(String string) throws Exception {
        InputSource inputSource = new InputSource(new StringReader(string));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        this.root = document.getDocumentElement();
        Class<?> clazz = this.getClass();
        Class[] classArray = new Class[]{Class.forName("org.w3c.dom.Node")};
        this.table = new Hashtable();
        this.table.put("transportmessage", clazz.getDeclaredMethod("transportmessage", classArray));
        this.table.put("payload", clazz.getDeclaredMethod("payload", classArray));
        this.table.put("envelope", clazz.getDeclaredMethod("envelope", classArray));
        this.table.put("aclmessage", clazz.getDeclaredMethod("aclmessage", classArray));
        this.table.put("act", clazz.getDeclaredMethod("act", classArray));
        this.table.put("agentname", clazz.getDeclaredMethod("agentname", classArray));
        this.table.put("connective", clazz.getDeclaredMethod("connective", classArray));
        this.table.put("constructor", clazz.getDeclaredMethod("constructor", classArray));
        this.table.put("datetime", clazz.getDeclaredMethod("datetime", classArray));
        this.table.put("label", clazz.getDeclaredMethod("label", classArray));
        this.table.put("locator", clazz.getDeclaredMethod("locator", classArray));
        this.table.put("number", clazz.getDeclaredMethod("number", classArray));
        this.table.put("predication", clazz.getDeclaredMethod("predication", classArray));
        this.table.put("quantifier", clazz.getDeclaredMethod("quantifier", classArray));
        this.table.put("reference", clazz.getDeclaredMethod("reference", classArray));
        this.table.put("string", clazz.getDeclaredMethod("string", classArray));
        this.table.put("symbol", clazz.getDeclaredMethod("symbol", classArray));
        this.table.put("tuple", clazz.getDeclaredMethod("tuple", classArray));
        this.table.put("variable", clazz.getDeclaredMethod("variable", classArray));
    }

    AcrNode parse() throws Exception {
        return this.handle_node(this.root);
    }

    private void setAcrNodeProperties(AcrNode acrNode, Element element) throws Exception {
        Element element2 = this.getChildElementByName(element, "properties");
        if (element2 != null) {
            JasBean jasBean = this.properties(element2);
            Enumeration enumeration = jasBean.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                acrNode.addProperty(string, (AcrNode)jasBean.get(string));
            }
        }
    }

    private Element getChildElementByName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            if (nodeList.item(n).getNodeName().equals(string)) {
                return (Element)nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    private Element[] getChildElements(Element element) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            if (nodeList.item(n) instanceof Element) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        return arrayList.toArray(new Element[0]);
    }

    private String getText(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength() - 1;
        return n < 0 ? null : nodeList.item(n).getNodeValue().trim();
    }

    public AclMessage aclmessage(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, "performative");
        Element element3 = this.getChildElementByName(element, "sender");
        Element element4 = this.getChildElementByName(element, "receiver");
        Element element5 = this.getChildElementByName(element, "content");
        AclMessage aclMessage = new AclMessage(this.performative(element2));
        aclMessage.setSender(this.sender(element3));
        aclMessage.setReceivers(this.receiver(element4));
        aclMessage.setContent(this.content(element5));
        this.setAcrNodeProperties(aclMessage, element);
        return aclMessage;
    }

    public AcrNode act(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, "agent");
        Element element3 = this.getChildElementByName(element, "action");
        Element element4 = this.getChildElementByName(element, "instrument");
        Element element5 = this.getChildElementByName(element, "patient");
        AcrAct acrAct = new AcrAct();
        acrAct.setAgent(this.agent(element2));
        acrAct.setAction(this.action(element3));
        acrAct.setInstrument(this.instrument(element4));
        acrAct.setPatient(this.patient(element5));
        this.setAcrNodeProperties(acrAct, element);
        return acrAct;
    }

    public String action(Node node) {
        return node.getFirstChild().getNodeValue().trim();
    }

    public String agent(Node node) {
        return node.getFirstChild().getNodeValue().trim();
    }

    public AcrAgentName agentname(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrAgentName.");
        }
        AcrAgentName acrAgentName = new AcrAgentName(string);
        this.setAcrNodeProperties(acrAgentName, (Element)node);
        return acrAgentName;
    }

    public AcrNode argument(Node node) throws Exception {
        Element[] elementArray = this.getChildElements((Element)node);
        if (elementArray.length > 0) {
            return this.handle_node(elementArray[0]);
        }
        return null;
    }

    public AcrConnective connective(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, FQN);
        AcrConnective acrConnective = new AcrConnective(this.fqn(element2));
        Element[] elementArray = this.getChildElements(element);
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            if (!elementArray[n].getNodeName().equals(FQN)) {
                acrConnective.addArgument(this.handle_node(elementArray[n]));
            }
            ++n;
        }
        this.setAcrNodeProperties(acrConnective, element);
        return acrConnective;
    }

    public AcrConstructor constructor(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, FQN);
        Element element3 = this.getChildElementByName(element, "argument");
        String string = this.fqn(element2);
        AcrNode acrNode = this.argument(element3);
        AcrConstructor acrConstructor = new AcrConstructor(string, acrNode);
        this.setAcrNodeProperties(acrConstructor, element);
        return acrConstructor;
    }

    private AcrNode content(Node node) throws Exception {
        Element[] elementArray = this.getChildElements((Element)node);
        if (elementArray.length > 0) {
            return this.handle_node(elementArray[0]);
        }
        return null;
    }

    public AcrDateTime datetime(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrDateTime.");
        }
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(9, 11));
        int n5 = Integer.parseInt(string.substring(11, 13));
        int n6 = Integer.parseInt(string.substring(13, 15));
        int n7 = Integer.parseInt(string.substring(15, 18));
        boolean bl = !Character.isDigit(string.charAt(string.length() - 1));
        AcrDateTime acrDateTime = new AcrDateTime(bl);
        acrDateTime.set(n, n2, n3, n4, n5, n6, n7);
        return acrDateTime;
    }

    public TransportMessage transportmessage(Node node) throws Exception {
        Element element = (Element)node;
        Element[] elementArray = this.getChildElements(element);
        Element element2 = this.getChildElementByName(element, "envelope");
        Element element3 = this.getChildElementByName(element, "payload");
        Envelope envelope = this.envelope(element2);
        Payload payload = this.payload(element3);
        AcrTransportMessage acrTransportMessage = new AcrTransportMessage(envelope, payload);
        this.setAcrNodeProperties(acrTransportMessage, element);
        return acrTransportMessage;
    }

    public Payload payload(Node node) throws Exception {
        Element element = (Element)node;
        Element[] elementArray = this.getChildElements(element);
        AcrPayload acrPayload = new AcrPayload();
        switch (elementArray.length) {
            case 1: {
                acrPayload.setMessage(this.handle_node(elementArray[0]));
                break;
            }
            case 2: {
                acrPayload.setMessage(this.handle_node(elementArray[1]));
                this.setAcrNodeProperties(acrPayload, element);
                break;
            }
            default: {
                throw new Exception("Too many payload child nodes.");
            }
        }
        return acrPayload;
    }

    public Envelope envelope(Node node) throws Exception {
        Element element = (Element)node;
        Element[] elementArray = this.getChildElements(element);
        AcrEnvelope acrEnvelope = new AcrEnvelope();
        Element element2 = this.getChildElementByName(element, "sender");
        Element element3 = this.getChildElementByName(element, "receiver");
        element2 = this.getChildElementByName(element2, "locator");
        element3 = this.getChildElementByName(element3, "locator");
        AcrLocator acrLocator = this.locator(element3);
        AcrLocator acrLocator2 = this.locator(element2);
        acrEnvelope.setSender(acrLocator2);
        acrEnvelope.setReceiver(acrLocator);
        this.setAcrNodeProperties(acrEnvelope, element);
        return acrEnvelope;
    }

    public String fqn(Node node) {
        return node.getFirstChild().getNodeValue().trim();
    }

    public AcrNode instrument(Node node) throws Exception {
        Element[] elementArray = this.getChildElements((Element)node);
        if (elementArray.length == 0) {
            throw new Exception("Error parsing AcrAct: instrument.");
        }
        return this.handle_node(elementArray[0]);
    }

    public AcrLocator locator(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, "type");
        Element element3 = this.getChildElementByName(element, "address");
        String string = this.getText(element2);
        String string2 = this.getText(element3);
        if (string == null || string2 == null) {
            throw new Exception("Error parsing AcrLocator.");
        }
        AcrLocator acrLocator = new AcrLocator(string, string2);
        this.setAcrNodeProperties(acrLocator, element);
        return acrLocator;
    }

    public AcrNumber number(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrNumber.");
        }
        AcrNumber acrNumber = new AcrNumber(string);
        this.setAcrNodeProperties(acrNumber, (Element)node);
        return acrNumber;
    }

    public AcrObject object(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrObject.");
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = Convert.toByteArray(cArray);
        Object object = Convert.toObject(byArray);
        AcrObject acrObject = new AcrObject(object);
        this.setAcrNodeProperties(acrObject, (Element)node);
        return acrObject;
    }

    public AcrNode patient(Node node) throws Exception {
        Element[] elementArray = this.getChildElements((Element)node);
        if (elementArray.length == 0) {
            throw new Exception("Error parsing AcrAct: patient.");
        }
        return this.handle_node(elementArray[0]);
    }

    public AcrPredication predication(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, FQN);
        Element element3 = this.getChildElementByName(element, "argument");
        String string = this.fqn(element2);
        AcrNode acrNode = this.argument(element3);
        AcrPredication acrPredication = new AcrPredication(string, acrNode);
        this.setAcrNodeProperties(acrPredication, element);
        return acrPredication;
    }

    public String performative(Node node) {
        String string = node.getFirstChild().getNodeValue().trim();
        return string;
    }

    public AcrQuantifier quantifier(Node node) throws Exception {
        Object object;
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, FQN);
        Element element3 = this.getChildElementByName(element, "variable");
        Element[] elementArray = this.getChildElements(element);
        String string = this.fqn(element2);
        AcrVariable acrVariable = this.variable(element3);
        AcrNode acrNode = null;
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            object = elementArray[n].getNodeName();
            if (!((String)object).equals(FQN) && !((String)object).equals("variable")) {
                acrNode = this.handle_node(elementArray[n]);
                break;
            }
            ++n;
        }
        object = new AcrQuantifier(string, acrVariable, acrNode);
        this.setAcrNodeProperties((AcrNode)object, element);
        return object;
    }

    public AcrAgentName[] receiver(Node node) throws Exception {
        ArrayList<AcrAgentName> arrayList = new ArrayList<AcrAgentName>();
        NodeList nodeList = ((Element)node).getElementsByTagName("agentname");
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            arrayList.add(this.agentname(nodeList.item(n)));
            ++n;
        }
        return arrayList.toArray(new AcrAgentName[0]);
    }

    public JasBean properties(Node node) throws Exception {
        JasBeanImpl jasBeanImpl = new JasBeanImpl();
        if (node != null) {
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagName("property");
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                jasBeanImpl.setAll(this.property(nodeList.item(n)));
                ++n;
            }
        }
        return jasBeanImpl;
    }

    public JasBean property(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        String string = this.fqn(nodeList.item(1));
        AcrNode acrNode = this.handle_node(nodeList.item(3));
        JasBeanImpl jasBeanImpl = new JasBeanImpl();
        jasBeanImpl.set(string, acrNode);
        return jasBeanImpl;
    }

    public AcrReference reference(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrReference.");
        }
        AcrReference acrReference = new AcrReference(string);
        this.setAcrNodeProperties(acrReference, (Element)node);
        return acrReference;
    }

    public AcrAgentName sender(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, "agentname");
        if (element2 != null) {
            return this.agentname(element2);
        }
        return null;
    }

    public AcrString string(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrString.");
        }
        AcrString acrString = new AcrString(string);
        this.setAcrNodeProperties(acrString, (Element)node);
        return acrString;
    }

    public AcrSymbol symbol(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrSymbol.");
        }
        AcrSymbol acrSymbol = new AcrSymbol(string);
        this.setAcrNodeProperties(acrSymbol, (Element)node);
        return acrSymbol;
    }

    public AcrTuple tuple(Node node) throws Exception {
        Element[] elementArray = this.getChildElements((Element)node);
        AcrTuple acrTuple = new AcrTuple();
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            acrTuple.addTupleElement(this.handle_node(elementArray[n]));
            ++n;
        }
        this.setAcrNodeProperties(acrTuple, (Element)node);
        return acrTuple;
    }

    public AcrVariable variable(Node node) throws Exception {
        String string = this.getText((Element)node);
        if (string == null) {
            throw new Exception("Error parsing AcrVariable.");
        }
        AcrVariable acrVariable = new AcrVariable(string);
        this.setAcrNodeProperties(acrVariable, (Element)node);
        return acrVariable;
    }

    public AcrLabel label(Node node) throws Exception {
        Element element = (Element)node;
        Element element2 = this.getChildElementByName(element, FQN);
        String string = this.fqn(element2);
        AcrNode acrNode = null;
        Element[] elementArray = this.getChildElements(element);
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            String string2 = elementArray[n].getNodeName();
            if (!string2.equals(FQN) && !string2.equals("variable")) {
                acrNode = this.handle_node(elementArray[n]);
                break;
            }
            ++n;
        }
        return new AcrLabel(string, acrNode);
    }

    private AcrNode handle_node(Node node) throws Exception {
        String string = node.getNodeName();
        if (!this.table.containsKey(string)) {
            return null;
        }
        Method method = (Method)this.table.get(string);
        return (AcrNode)method.invoke((Object)this, node);
    }
}

