/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl.parser;

import java.util.ArrayList;
import java.util.Arrays;
import org.jagent.transform.sl.SL0ActionExpression;
import org.jagent.transform.sl.SL0AtomicFormula;
import org.jagent.transform.sl.SL0Content;
import org.jagent.transform.sl.SL0FunctionalTerm;
import org.jagent.transform.sl.SL0Term;
import org.jagent.transform.sl.parser.SL0ContentParser;

public class Tester {
    private String input;
    private Class rtnType;
    private Object rtnValue;

    private Tester() {
    }

    private String[] getAtomicFormulas() {
        String string = "symbol";
        String string2 = "true";
        String string3 = "false";
        String string4 = "(result foobar no)";
        String string5 = "(symbol yes no maybe)";
        return new String[]{string, string2, string3, string4, string5};
    }

    private String[] getActionExpressions() {
        String string = "(action andy@mrmagoo.nosc.mil:5678/acc quit)";
        return new String[]{string};
    }

    private String[] getFunctionalTerms() {
        String string = "(gotcha)";
        String string2 = "(symbol okay blah)";
        String string3 = "(symbol :noun andy :verb run)";
        return new String[]{string, string2, string3};
    }

    private String[] getTerms() {
        String string = "word";
        String string2 = "\"string literal 1\"";
        String string3 = "\"string \\\"literal\\\" 2\"";
        String string4 = "(set fe fi fo fum)";
        String string5 = "(sequence fe fi fo fum)";
        String[] stringArray = new String[]{string, string2, string3, string4, string5};
        String[] stringArray2 = this.getActionExpressions();
        String[] stringArray3 = this.getFunctionalTerms();
        String[] stringArray4 = new String[stringArray.length + stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray4, stringArray.length + stringArray2.length, stringArray3.length);
        return stringArray4;
    }

    private String[] getWffs() {
        String[] stringArray = this.getActionExpressions();
        String[] stringArray2 = this.getAtomicFormulas();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray3[n] = stringArray2[n];
            ++n;
        }
        int n2 = stringArray2.length;
        int n3 = 0;
        int n4 = stringArray2.length + stringArray.length;
        while (n2 + n3 < n4) {
            stringArray3[n2 + n3] = "(done " + stringArray[n3] + ")";
            ++n3;
        }
        return stringArray3;
    }

    private String[] getPropositions() {
        return this.getWffs();
    }

    private String[] getContents() {
        String[] stringArray = this.getActionExpressions();
        String[] stringArray2 = this.getPropositions();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.addAll(Arrays.asList(stringArray2));
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            arrayList.set(n, "(" + arrayList.get(n) + ")");
            ++n;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = 0;
            while (n4 < stringArray2.length) {
                arrayList.add("(" + stringArray[n3] + stringArray2[n4] + ")");
                arrayList.add("(" + stringArray2[n4] + stringArray[n3] + ")");
                ++n4;
            }
            ++n3;
        }
        return arrayList.toArray(new String[0]);
    }

    private void testAtomicFormula() throws Exception {
        System.out.print("Testing AtomicFormula...");
        String[] stringArray = this.getAtomicFormulas();
        int n = 0;
        while (n < stringArray.length) {
            SL0AtomicFormula sL0AtomicFormula = SL0ContentParser.parseSL0AtomicFormula(stringArray[n]);
            if (!(sL0AtomicFormula instanceof SL0AtomicFormula)) {
                throw new RuntimeException(sL0AtomicFormula.getClass().toString());
            }
            ++n;
        }
        System.out.println("okay.");
    }

    private void testActionExpression() throws Exception {
        System.err.print("Testing ActionExpression...");
        String[] stringArray = this.getActionExpressions();
        int n = 0;
        while (n < stringArray.length) {
            SL0ActionExpression sL0ActionExpression = SL0ContentParser.parseSL0ActionExpression(stringArray[n]);
            if (!(sL0ActionExpression instanceof SL0ActionExpression)) {
                throw new RuntimeException(sL0ActionExpression.getClass().toString());
            }
            ++n;
        }
        System.err.println("okay.");
    }

    private void testFunctionalTerm() throws Exception {
        System.err.print("Testing FunctionalTerm...");
        String[] stringArray = this.getFunctionalTerms();
        int n = 0;
        while (n < stringArray.length) {
            SL0FunctionalTerm sL0FunctionalTerm = SL0ContentParser.parseSL0FunctionalTerm(stringArray[n]);
            if (!(sL0FunctionalTerm instanceof SL0FunctionalTerm)) {
                throw new RuntimeException(sL0FunctionalTerm.getClass().toString());
            }
            ++n;
        }
        System.err.println("okay.");
    }

    private void testTerm() throws Exception {
        System.err.print("Testing SLTerm...");
        String[] stringArray = this.getTerms();
        int n = 0;
        while (n < stringArray.length) {
            SL0Term sL0Term = SL0ContentParser.parseSL0Term(stringArray[n]);
            if (!(sL0Term instanceof SL0Term)) {
                throw new RuntimeException(sL0Term.getClass().toString());
            }
            ++n;
        }
        System.err.println("okay.");
    }

    private void testContent() throws Exception {
        System.err.print("Testing SL0Content...");
        String[] stringArray = this.getContents();
        int n = 0;
        while (n < stringArray.length) {
            SL0Content sL0Content = SL0ContentParser.parseSL0Content(stringArray[n]);
            if (!(sL0Content instanceof SL0Content)) {
                throw new RuntimeException(sL0Content.getClass().toString());
            }
            ++n;
        }
        System.err.println("okay.");
    }

    public static void main(String[] stringArray) throws Exception {
        Tester tester = new Tester();
        tester.testAtomicFormula();
        tester.testActionExpression();
        tester.testFunctionalTerm();
        tester.testTerm();
        tester.testContent();
    }
}

