/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl;

import org.jagent.transform.sl.SLString;

public class Word
extends SLString {
    private String string;

    public Word(String string) {
        this.check(string);
        this.string = string;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Word)) {
            return false;
        }
        return this.string.equals(((Word)object).string);
    }

    public String toString() {
        return this.string;
    }

    private void check(String string) {
        if (string.indexOf(40) > -1 || string.indexOf(41) > -1) {
            throw new IllegalArgumentException("Word contains: ()'s");
        }
        char c = string.charAt(0);
        if ('\u0000' <= c && c <= ' ') {
            throw new IllegalArgumentException("Word contains: NPC's");
        }
        if (Character.isDigit(c)) {
            throw new IllegalArgumentException("Word starting with: 0-9");
        }
        if (c == '#' || c == ':' || c == '-' || c == '?') {
            throw new IllegalArgumentException("Word starting with: #:-?");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "andy_spydell";
        Word word = new Word(string);
        System.err.println(word);
        Word word2 = (Word)word.clone();
        System.err.println("word == copy ? " + word.equals(word2));
        System.err.println("word.hashCode() = " + word.hashCode());
        System.err.println("copy.hashCode() = " + word2.hashCode());
    }
}

