/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl;

import org.jagent.transform.sl.SLNumericalConstant;

public class SLInteger
extends SLNumericalConstant {
    private long value;
    private byte type;
    private static final byte BYTE = 0;
    private static final byte SHORT = 1;
    private static final byte INT = 2;
    private static final byte LONG = 3;

    public SLInteger(byte by) {
        this((long)by);
        this.type = 0;
    }

    public SLInteger(short s) {
        this((long)s);
        this.type = 1;
    }

    public SLInteger(int n) {
        this((long)n);
        this.type = (byte)2;
    }

    public SLInteger(long l) {
        this.value = l;
        this.type = (byte)3;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public static SLInteger parseInteger(String string) {
        long l = Long.parseLong(string);
        if (-128L <= l && l <= 127L) {
            return new SLInteger((byte)l);
        }
        if (-32768L <= l && l <= 32767L) {
            return new SLInteger((short)l);
        }
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            return new SLInteger((int)l);
        }
        return new SLInteger(l);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SLInteger)) {
            return false;
        }
        return this.value == ((SLInteger)object).value;
    }

    public String toString() {
        if (this.type == 0) {
            return String.valueOf((byte)this.value);
        }
        if (this.type == 1) {
            return String.valueOf((short)this.value);
        }
        if (this.type == 2) {
            return String.valueOf((int)this.value);
        }
        return String.valueOf(this.value);
    }
}

