/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl;

import org.jagent.transform.sl.SLNumericalConstant;

public class SLFloat
extends SLNumericalConstant {
    private double value;
    private byte type;
    private static final byte FLOAT = 0;
    private static final byte DOUBLE = 1;

    public SLFloat(double d) {
        this.value = d;
        this.type = 1;
    }

    public SLFloat(float f) {
        this((double)f);
        this.type = 0;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public static SLFloat parseFloat(String string) {
        double d = Double.parseDouble(string);
        if ((double)1.4E-45f <= d && d <= 3.4028234663852886E38) {
            return new SLFloat((float)d);
        }
        return new SLFloat(d);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SLFloat)) {
            return false;
        }
        return this.value == ((SLFloat)object).value;
    }

    public String toString() {
        if (this.type == 0) {
            return String.valueOf((float)this.value);
        }
        return String.valueOf(this.value);
    }
}

