/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl;

import java.util.ArrayList;
import java.util.List;
import org.jagent.transform.sl.FunctionSymbol;
import org.jagent.transform.sl.Parameter;
import org.jagent.transform.sl.SL0Term;
import org.jagent.transform.sl.SLNode;

public class SL0FunctionalTerm
extends SLNode
implements SL0Term {
    private byte type;
    private static final byte TERM = 0;
    private static final byte PARAM = 1;
    private static final byte NONE = 2;

    public SL0FunctionalTerm(FunctionSymbol functionSymbol) {
        super.addNode(functionSymbol);
        this.type = (byte)2;
    }

    public SL0FunctionalTerm(FunctionSymbol functionSymbol, SL0Term[] sL0TermArray) {
        super.addNode(functionSymbol);
        this.type = 0;
        int n = 0;
        int n2 = sL0TermArray.length;
        while (n < n2) {
            super.addNode((SLNode)((Object)sL0TermArray[n]));
            ++n;
        }
    }

    public SL0FunctionalTerm(FunctionSymbol functionSymbol, Parameter[] parameterArray) {
        super.addNode(functionSymbol);
        this.type = 1;
        int n = 0;
        int n2 = parameterArray.length;
        while (n < n2) {
            super.addNode(parameterArray[n]);
            ++n;
        }
    }

    public void addParameter(Parameter parameter) {
        if (this.type == 0) {
            throw new IllegalArgumentException("Add Parameter to Term list.");
        }
        if (this.type == 2) {
            this.type = 1;
        }
        super.addNode(parameter);
    }

    public void addTerm(SL0Term sL0Term) {
        if (this.type == 1) {
            throw new IllegalArgumentException("Add Term to Parameter list.");
        }
        if (this.type == 2) {
            this.type = 0;
        }
        super.addNode((SLNode)((Object)sL0Term));
    }

    public FunctionSymbol getSymbol() {
        return (FunctionSymbol)super.getNodeAt(0);
    }

    public boolean containsTerms() {
        return this.type == 2 || this.type == 0;
    }

    public boolean containsParams() {
        return this.type == 2 || this.type == 1;
    }

    public SL0Term[] getTerms() {
        if (!this.containsTerms()) {
            throw new UnsupportedOperationException("Items are not Parameters");
        }
        return this.getItems().toArray(new SL0Term[0]);
    }

    public Parameter[] getParams() {
        if (!this.containsParams()) {
            throw new UnsupportedOperationException("Items are not SL0Terms");
        }
        return this.getItems().toArray(new Parameter[0]);
    }

    private List getItems() {
        int n = this.getNodeCount();
        ArrayList<SLNode> arrayList = new ArrayList<SLNode>(n - 1);
        int n2 = 1;
        while (n2 < n) {
            arrayList.add(this.getNodeAt(n2));
            ++n2;
        }
        return arrayList;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SL0FunctionalTerm)) {
            return false;
        }
        if (this.type != ((SL0FunctionalTerm)object).type) {
            return false;
        }
        return super.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append(this.getSymbol());
        if (this.type != 2) {
            List list = this.getItems();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                String string = list.get(n).toString();
                if (stringBuffer.charAt(stringBuffer.length() - 1) != ')' || string.startsWith("(")) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                ++n;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

