/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl;

import java.util.ArrayList;
import org.jagent.transform.sl.PredicateSymbol;
import org.jagent.transform.sl.PropositionSymbol;
import org.jagent.transform.sl.SL0ActionExpression;
import org.jagent.transform.sl.SL0Term;
import org.jagent.transform.sl.SLNode;
import org.jagent.transform.sl.StringLiteral;
import org.jagent.transform.sl.Word;

public class SL0AtomicFormula
extends SLNode {
    private byte type;
    private boolean bool;
    private static final byte PROP_SYM = 0;
    private static final byte RESULT = 1;
    private static final byte PRED_SYM = 2;
    private static final byte BOOLEAN = 3;

    public SL0AtomicFormula(PropositionSymbol propositionSymbol) {
        super.addNode(propositionSymbol);
        this.type = 0;
    }

    public SL0AtomicFormula(SL0Term sL0Term, SL0Term sL0Term2) {
        super.addNode((SLNode)((Object)sL0Term));
        super.addNode((SLNode)((Object)sL0Term2));
        this.type = 1;
    }

    public SL0AtomicFormula(PredicateSymbol predicateSymbol, SL0Term[] sL0TermArray) {
        super.addNode(predicateSymbol);
        int n = 0;
        int n2 = sL0TermArray.length;
        while (n < n2) {
            super.addNode((SLNode)((Object)sL0TermArray[n]));
            ++n;
        }
        this.type = (byte)2;
    }

    public SL0AtomicFormula(boolean bl) {
        this.bool = bl;
        this.type = (byte)3;
    }

    public boolean isPropsitionExpr() {
        return this.type == 0;
    }

    public boolean isResultExpr() {
        return this.type == 1;
    }

    public boolean isPredicateExpr() {
        return this.type == 2;
    }

    public boolean isBooleanExpr() {
        return this.type == 3;
    }

    public PropositionSymbol getPropositionSymbol() {
        if (this.type != 0) {
            throw new UnsupportedOperationException("Not a proposition.");
        }
        return (PropositionSymbol)this.getNodeAt(0);
    }

    public SL0Term getActionTerm() {
        if (this.type != 1) {
            throw new UnsupportedOperationException("Not a result expression.");
        }
        return (SL0Term)((Object)this.getNodeAt(0));
    }

    public SL0Term getResultTerm() {
        if (this.type != 1) {
            throw new UnsupportedOperationException("Not a result expression.");
        }
        return (SL0Term)((Object)this.getNodeAt(1));
    }

    public PredicateSymbol getPredicateSymbol() {
        if (this.type != 2) {
            throw new UnsupportedOperationException("Not a predicate expr.");
        }
        return (PredicateSymbol)this.getNodeAt(0);
    }

    public SL0Term[] getPredicateTerms() {
        if (this.type != 2) {
            throw new UnsupportedOperationException("Not a predicate expr.");
        }
        int n = this.getNodeCount();
        ArrayList<SLNode> arrayList = new ArrayList<SLNode>(n - 1);
        int n2 = 1;
        while (n2 < n) {
            arrayList.add(this.getNodeAt(n2));
            ++n2;
        }
        return arrayList.toArray(new SL0Term[0]);
    }

    public boolean getBoolean() {
        if (this.type != 3) {
            throw new UnsupportedOperationException("Not a boolean expression.");
        }
        return this.bool;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SL0AtomicFormula)) {
            return false;
        }
        SL0AtomicFormula sL0AtomicFormula = (SL0AtomicFormula)object;
        if (this.type != sL0AtomicFormula.type || this.bool != sL0AtomicFormula.bool) {
            return false;
        }
        if (this.type == 3) {
            return this.bool == sL0AtomicFormula.bool;
        }
        return super.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append(this.getPropositionSymbol());
                break;
            }
            case 1: {
                stringBuffer.append("(result ");
                stringBuffer.append(this.getActionTerm()).append(" ");
                stringBuffer.append(this.getResultTerm());
                stringBuffer.append(")");
                break;
            }
            case 2: {
                stringBuffer.append("(");
                stringBuffer.append(this.getPredicateSymbol());
                SL0Term[] sL0TermArray = this.getPredicateTerms();
                int n = 0;
                int n2 = sL0TermArray.length;
                while (n < n2) {
                    String string = sL0TermArray[n].toString();
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != ')' || string.startsWith("(")) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string);
                    ++n;
                }
                stringBuffer.append(")");
                break;
            }
            case 3: {
                stringBuffer.append(this.bool);
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        PropositionSymbol propositionSymbol = new PropositionSymbol("foobar");
        SL0AtomicFormula sL0AtomicFormula = new SL0AtomicFormula(propositionSymbol);
        Word word = new Word("andy@iiop://mrmagoo.nosc.mil/acc");
        StringLiteral stringLiteral = new StringLiteral("fe fi fo fum");
        SL0ActionExpression sL0ActionExpression = new SL0ActionExpression(word, stringLiteral);
        Word word2 = new Word("QUIT");
        SL0AtomicFormula sL0AtomicFormula2 = new SL0AtomicFormula(sL0ActionExpression, word2);
        PredicateSymbol predicateSymbol = new PredicateSymbol("hi_there");
        SL0Term[] sL0TermArray = new SL0Term[]{new Word("noun"), new StringLiteral("verb phrase")};
        SL0AtomicFormula sL0AtomicFormula3 = new SL0AtomicFormula(predicateSymbol, sL0TermArray);
        SL0AtomicFormula sL0AtomicFormula4 = new SL0AtomicFormula(true);
        SL0AtomicFormula sL0AtomicFormula5 = new SL0AtomicFormula(false);
        System.err.println(sL0AtomicFormula);
        System.err.println(sL0AtomicFormula2);
        System.err.println(sL0AtomicFormula3);
        System.err.println(sL0AtomicFormula4);
        System.err.println(sL0AtomicFormula5);
        SL0AtomicFormula sL0AtomicFormula6 = (SL0AtomicFormula)sL0AtomicFormula.clone();
        SL0AtomicFormula sL0AtomicFormula7 = (SL0AtomicFormula)sL0AtomicFormula2.clone();
        SL0AtomicFormula sL0AtomicFormula8 = (SL0AtomicFormula)sL0AtomicFormula3.clone();
        SL0AtomicFormula sL0AtomicFormula9 = (SL0AtomicFormula)sL0AtomicFormula4.clone();
        SL0AtomicFormula sL0AtomicFormula10 = (SL0AtomicFormula)sL0AtomicFormula5.clone();
        System.err.println("sf1 == cp1 ? " + sL0AtomicFormula.equals(sL0AtomicFormula6));
        System.err.println("sf2 == cp2 ? " + sL0AtomicFormula2.equals(sL0AtomicFormula7));
        System.err.println("sf3 == cp3 ? " + sL0AtomicFormula3.equals(sL0AtomicFormula8));
        System.err.println("sf4 == cp4 ? " + sL0AtomicFormula4.equals(sL0AtomicFormula9));
        System.err.println("sf5 == cp5 ? " + sL0AtomicFormula5.equals(sL0AtomicFormula10));
        System.err.println("sf1 == cp2 ? " + sL0AtomicFormula.equals(sL0AtomicFormula7));
        System.err.println("sf2 == cp3 ? " + sL0AtomicFormula2.equals(sL0AtomicFormula8));
        System.err.println("sf3 == cp4 ? " + sL0AtomicFormula3.equals(sL0AtomicFormula9));
        System.err.println("sf4 == cp5 ? " + sL0AtomicFormula4.equals(sL0AtomicFormula10));
        System.err.println("sf5 == cp1 ? " + sL0AtomicFormula5.equals(sL0AtomicFormula6));
    }
}

