/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.transform.sl;

import org.jagent.transform.sl.SLConstant;

public class DateTime
extends SLConstant {
    private short year;
    private byte month;
    private byte day;
    private byte hour;
    private byte minute;
    private byte second;
    private short millis;
    private char type;

    public DateTime(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0, 0);
    }

    public DateTime(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0, 0);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0, 0);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDay(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(n6);
        this.setMillis(n7);
    }

    private void setYear(int n) {
        if (n < 0 || 9999 < n) {
            throw new IllegalArgumentException("Year range error.");
        }
        this.year = (short)n;
    }

    private void setMonth(int n) {
        if (n < 1 || 12 < n) {
            throw new IllegalArgumentException("Month outside of range [1-12]");
        }
        this.month = (byte)n;
    }

    private void setDay(int n) {
        if (n < 1 || 31 < n) {
            throw new IllegalArgumentException("Day outside of range [1-31]");
        }
        this.day = (byte)n;
    }

    private void setHour(int n) {
        if (n < 0 || 23 < n) {
            throw new IllegalArgumentException("Hour outside of range [0-23]");
        }
        this.hour = (byte)n;
    }

    private void setMinute(int n) {
        if (n < 0 || 59 < n) {
            throw new IllegalArgumentException("Minute outside of range [0-59]");
        }
        this.minute = (byte)n;
    }

    private void setSecond(int n) {
        if (n < 0 || 59 < n) {
            throw new IllegalArgumentException("Second outside of range [0-59]");
        }
        this.second = (byte)n;
    }

    private void setMillis(int n) {
        if (n < 0 || 999 < n) {
            throw new IllegalArgumentException("Millis outside of range [0-999]");
        }
        this.millis = (short)n;
    }

    public void setType(char c) {
        if (!Character.isLetter(c)) {
            throw new IllegalArgumentException("Type not valid [a-z,A-Z].");
        }
        this.type = c;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillis() {
        return this.millis;
    }

    public char getType() {
        return this.type;
    }

    public static DateTime parseDateTime(String string) {
        char[] cArray = string.toCharArray();
        int n = Integer.parseInt(String.valueOf(cArray, 0, 4));
        int n2 = Integer.parseInt(String.valueOf(cArray, 4, 2));
        int n3 = Integer.parseInt(String.valueOf(cArray, 6, 2));
        int n4 = Integer.parseInt(String.valueOf(cArray, 9, 2));
        int n5 = Integer.parseInt(String.valueOf(cArray, 11, 2));
        int n6 = Integer.parseInt(String.valueOf(cArray, 13, 2));
        int n7 = Integer.parseInt(String.valueOf(cArray, 15, 3));
        DateTime dateTime = new DateTime(n, n2, n3, n4, n5, n6, n7);
        if (cArray.length == 19) {
            dateTime.setType(cArray[18]);
        }
        return dateTime;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateTime)) {
            return false;
        }
        DateTime dateTime = (DateTime)object;
        return this.year == dateTime.year && this.month == dateTime.month && this.day == dateTime.day && this.hour == dateTime.hour && this.minute == dateTime.minute && this.second == dateTime.second && this.millis == dateTime.millis && this.type == dateTime.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.year < 1000 ? "0" : "");
        stringBuffer.append(this.year < 100 ? "0" : "");
        stringBuffer.append(this.year < 10 ? "0" : "");
        stringBuffer.append(this.year);
        stringBuffer.append(this.month < 10 ? "0" : "").append(this.month);
        stringBuffer.append(this.day < 10 ? "0" : "").append(this.day);
        stringBuffer.append("T");
        stringBuffer.append(this.hour < 10 ? "0" : "").append(this.hour);
        stringBuffer.append(this.minute < 10 ? "0" : "").append(this.minute);
        stringBuffer.append(this.second < 10 ? "0" : "").append(this.second);
        stringBuffer.append(this.millis < 100 ? (this.millis < 10 ? "00" : "0") : "");
        stringBuffer.append(this.millis);
        if (Character.isLetter(this.type)) {
            stringBuffer.append(this.type);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        DateTime dateTime = new DateTime(1970, 1, 1);
        System.err.println(dateTime);
        DateTime dateTime2 = (DateTime)dateTime.clone();
        System.err.println("dt == copy ? " + dateTime.equals(dateTime2));
        dateTime2.setType('z');
        System.err.println(dateTime2);
        System.err.println("dt == copy ? " + dateTime.equals(dateTime2));
    }
}

