/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.util;

import java.net.MalformedURLException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.agent.Locator;
import javax.agent.service.transport.NotLocatableException;
import org.jagent.service.util.IPLocator;
import org.jagent.service.util.IPUtility;
import org.jagent.util.URIUtility;

public final class RMIUtility {
    private RMIUtility() {
    }

    public static Registry getRegistry(Locator locator) throws NotLocatableException {
        try {
            String string = IPUtility.getLocalHost();
            int n = 1099;
            String string2 = string;
            int n2 = n;
            if (locator instanceof IPLocator) {
                n2 = ((IPLocator)locator).getPort();
                string2 = ((IPLocator)locator).getHost();
            } else {
                String[] stringArray = URIUtility.parseAsURI(locator.getAddress());
                if (stringArray[1] != null) {
                    string2 = stringArray[1];
                }
                if (stringArray[2] != null) {
                    n2 = Integer.parseInt(stringArray[2]);
                }
            }
            boolean bl = !string2.equals(string);
            boolean bl2 = n2 != n;
            Registry registry = null;
            registry = bl && bl2 ? LocateRegistry.getRegistry(string2, n2) : (bl && !bl2 ? LocateRegistry.getRegistry(string2) : (!bl && bl2 ? LocateRegistry.getRegistry(n2) : LocateRegistry.getRegistry()));
            return registry;
        }
        catch (MalformedURLException malformedURLException) {
            throw new NotLocatableException("Cannot determine port.", malformedURLException);
        }
        catch (RemoteException remoteException) {
            throw new NotLocatableException("Cannot locate Registry.", remoteException);
        }
    }

    public static Registry getLocalRegistry(int n) throws RemoteException {
        try {
            return LocateRegistry.createRegistry(n);
        }
        catch (RemoteException remoteException) {
            return LocateRegistry.getRegistry(n);
        }
    }

    public static Remote getRemote(Locator locator) throws NotLocatableException {
        Remote remote = RMIUtility.getRemote(locator.getAddress());
        if (remote != null) {
            return remote;
        }
        if (locator.containsKey("javax.agent.locator.ip.rmi.id")) {
            Object object;
            Object object2 = locator.get("javax.agent.locator.ip.rmi.id");
            Object object3 = locator.get("javax.agent.locator.host");
            remote = RMIUtility.getRemote(object3, object = locator.get("javax.agent.locator.port"), object2);
            if (remote != null) {
                return remote;
            }
        }
        throw new NotLocatableException();
    }

    private static Remote getRemote(String string) {
        Remote remote = null;
        try {
            String[] stringArray = URIUtility.parseAsURI(string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            String string5 = stringArray[3];
            remote = RMIUtility.getRemote(string3, string4, string5);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return remote;
    }

    private static Remote getRemote(Object object, Object object2, Object object3) {
        String string = "127.0.0.1";
        if (object != null) {
            string = String.valueOf(object);
        }
        int n = 1099;
        if (object2 != null) {
            n = Integer.parseInt(String.valueOf(object2));
        }
        try {
            Registry registry = LocateRegistry.getRegistry(string, n);
            if (object3 != null) {
                String string2 = String.valueOf(object3);
                try {
                    String string3 = URIUtility.buildURI("rmi", string, n, string2);
                    return registry.lookup(string3);
                }
                catch (Exception exception) {
                    try {
                        return registry.lookup(string2);
                    }
                    catch (Exception exception2) {}
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }
}

