/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.util;

import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import javax.agent.service.ServiceProperties;
import org.jagent.service.RMIService;
import org.jagent.service.util.IPUtility;
import org.jagent.service.util.RMIUtility;
import org.jagent.util.URIUtility;

public abstract class RMIBasicService
extends RemoteObject
implements RMIService {
    private String bindingAddr = "";
    private Registry registry = null;
    private boolean isExported = false;
    private boolean isBound = false;

    protected RMIBasicService() throws Exception {
        this.initialize(IPUtility.getOpenPort());
    }

    protected RMIBasicService(ServiceProperties serviceProperties) throws Exception {
        String string;
        if (serviceProperties.containsKey("export-service") && !Boolean.valueOf(string = serviceProperties.get("export-service").toString()).booleanValue()) {
            return;
        }
        if (serviceProperties != null && serviceProperties.containsKey("javax.agent.service.ip.service-port") && serviceProperties.containsKey("javax.agent.service.ip.service-host")) {
            string = (String)serviceProperties.get("javax.agent.service.ip.service-port");
            String string2 = (String)serviceProperties.get("javax.agent.service.ip.service-host");
            if (serviceProperties.containsKey("platform-socket-factory")) {
                RMISocketFactory rMISocketFactory = (RMISocketFactory)serviceProperties.get("platform-socket-factory");
                this.initialize(Integer.parseInt(string), string2, rMISocketFactory);
            } else {
                this.initialize(Integer.parseInt(string), string2, null);
            }
        } else if (serviceProperties != null && serviceProperties.containsKey("javax.agent.service.ip.service-port")) {
            string = (String)serviceProperties.get("javax.agent.service.ip.service-port");
            this.initialize(Integer.parseInt(string));
        } else {
            this.initialize(IPUtility.getOpenPort());
        }
    }

    private void initialize(int n, String string, RMISocketFactory rMISocketFactory) throws Exception {
        if (rMISocketFactory == null) {
            UnicastRemoteObject.exportObject(this);
        } else {
            UnicastRemoteObject.exportObject(this, 0, rMISocketFactory, rMISocketFactory);
        }
        this.isExported = true;
        String string2 = this.getBindingName();
        this.bindingAddr = URIUtility.buildURI("rmi", string, n, string2);
        this.registry = RMIUtility.getLocalRegistry(n);
    }

    protected void bindServiceToRegistry() throws Exception {
        if (this.registry != null) {
            this.registry.bind(this.bindingAddr, this);
            this.isBound = true;
        }
    }

    private void initialize(int n) throws Exception {
        UnicastRemoteObject.exportObject(this);
        this.isExported = true;
        String string = IPUtility.getLocalHost();
        String string2 = this.getBindingName();
        this.bindingAddr = URIUtility.buildURI("rmi", string, n, string2);
        System.out.println("\nbindingAddr is: " + this.bindingAddr + "\n");
        this.registry = RMIUtility.getLocalRegistry(n);
        this.registry.bind(this.bindingAddr, this);
        this.isBound = true;
    }

    protected abstract String getBindingName();

    protected void shutdown() throws RemoteException, NoSuchObjectException, NotBoundException {
        if (this.isBound) {
            this.registry.unbind(this.bindingAddr);
            this.isBound = false;
        }
        if (this.isExported) {
            UnicastRemoteObject.unexportObject(this, true);
            this.isExported = false;
        }
        this.bindingAddr = null;
        this.registry = null;
    }

    public ServiceProperties getServiceProperties() {
        return null;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }
}

