/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.rmi;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NoSuchTransportException;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import javax.agent.service.transport.TransportSystem;
import org.jagent.service.transport.rmi.RMITransportSystem;

public class RMITransportSystemProxy
implements TransportSystem,
Serializable {
    private RMITransportSystem delegate;

    public RMITransportSystemProxy(RMITransportSystem rMITransportSystem) {
        this.delegate = rMITransportSystem;
    }

    public ServiceProperties getServiceProperties() {
        return null;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }

    public MessageTransportService[] getMessageTransportServices() throws TransportFailure {
        try {
            return this.delegate.getMessageTransportServices();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }

    public MessageTransportService getMessageTransportService(Locator locator) throws NotLocatableException, TransportFailure {
        try {
            return this.delegate.getMessageTransportService(locator);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }

    public MessageTransportService getMessageTransportService(JasBean jasBean) throws NotLocatableException, TransportFailure {
        try {
            return this.delegate.getMessageTransportService(jasBean);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }

    public MessageSender newMessageSender(JasBean jasBean) throws NotLocatableException, TransportFailure {
        try {
            return this.delegate.newMessageSender(jasBean);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }

    public MessageReceiver newMessageReceiver(JasBean jasBean) throws NotLocatableException, TransportFailure {
        try {
            return this.delegate.newMessageReceiver(jasBean);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, NoSuchTransportException, TransportFailure {
        try {
            this.delegate.sendMessage(transportMessage);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }

    public void sendMessage(TransportMessage transportMessage, Locator locator) throws NotLocatableException, NoSuchTransportException, TransportFailure {
        try {
            this.delegate.sendMessage(transportMessage, locator);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access service.", remoteException);
        }
    }
}

