/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.rmi;

import java.rmi.RemoteException;
import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NoSuchTransportException;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.service.transport.BasicTransportSystem;
import org.jagent.service.transport.rmi.RMITransportSystem;
import org.jagent.service.util.RMIBasicService;

public class RMITransportSystemImpl
extends RMIBasicService
implements RMITransportSystem {
    private BasicTransportSystem delegate;
    private static final String RMI = "rmi";
    private static final String TS_FACTORY = "org.jagent.service.transport.rmi.RMIMessageTransportServiceFactory";

    public RMITransportSystemImpl() throws Exception {
        this.initialize(null);
    }

    public RMITransportSystemImpl(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        this.initialize(serviceProperties);
    }

    private void initialize(ServiceProperties serviceProperties) throws Exception {
        this.delegate = new BasicTransportSystem();
        if (serviceProperties != null) {
            serviceProperties.set("transport-factory-class", TS_FACTORY);
            if (serviceProperties.containsKey("javax.agent.service.ip.service-port")) {
                Object object = serviceProperties.get("javax.agent.service.ip.service-port");
                serviceProperties.set("javax.agent.service.ip.service-port", object);
            }
            if (!this.loadTransportService(RMI, serviceProperties)) {
                this.shutdown();
                throw new Exception("Cannot start transport service.");
            }
            this.bindServiceToRegistry();
        }
    }

    public String getBindingName() {
        return "message-transport-system";
    }

    public boolean loadTransportService(String string, ServiceProperties serviceProperties) {
        try {
            this.delegate.loadTransportService(string, serviceProperties);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean unloadTransportService(String string) {
        MessageTransportService messageTransportService = this.delegate.unloadTransportService(string);
        return messageTransportService != null;
    }

    public void shutdown() {
        try {
            super.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessageTransportService[] getMessageTransportServices() throws TransportFailure, RemoteException {
        return this.delegate.getMessageTransportServices();
    }

    public MessageTransportService getMessageTransportService(Locator locator) throws NotLocatableException, TransportFailure, RemoteException {
        return this.delegate.getMessageTransportService(locator);
    }

    public MessageTransportService getMessageTransportService(JasBean jasBean) throws NotLocatableException, TransportFailure, RemoteException {
        return this.delegate.getMessageTransportService(jasBean);
    }

    public MessageSender newMessageSender(JasBean jasBean) throws NotLocatableException, TransportFailure, RemoteException {
        return this.delegate.newMessageSender(jasBean);
    }

    public MessageReceiver newMessageReceiver(JasBean jasBean) throws NotLocatableException, TransportFailure, RemoteException {
        return this.delegate.newMessageReceiver(jasBean);
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, NoSuchTransportException, TransportFailure, RemoteException {
        this.delegate.sendMessage(transportMessage);
    }

    public void sendMessage(TransportMessage transportMessage, Locator locator) throws NotLocatableException, NoSuchTransportException, TransportFailure, RemoteException {
        this.delegate.sendMessage(transportMessage, locator);
    }
}

