/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.rmi;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.acr.AcrTransportMessage;
import org.jagent.service.transport.rmi.RMIMessageReceiverImpl;
import org.jagent.service.transport.rmi.RMIMessageSender;
import org.jagent.service.util.IPUtility;
import org.jagent.service.util.RMILocator;
import org.jagent.util.URIUtility;

public class RMIMessageTransportService
implements MessageTransportService,
Serializable {
    private transient MessageSender prototypeSender;
    private transient MessageReceiver prototypeReceiver;
    private int port;
    private static final String RMI = "rmi";

    public RMIMessageTransportService() throws TransportFailure {
    }

    public RMIMessageTransportService(ServiceProperties serviceProperties) throws TransportFailure {
        this();
        this.port = 1099;
        if (serviceProperties.containsKey("javax.agent.service.ip.service-port")) {
            this.port = Integer.parseInt(serviceProperties.get("javax.agent.service.ip.service-port").toString());
        } else {
            serviceProperties.set("javax.agent.service.ip.service-port", String.valueOf(this.port));
        }
    }

    public ServiceProperties getServiceProperties() throws TransportFailure {
        return null;
    }

    public TransportMessage createTransportMessage() {
        return new AcrTransportMessage();
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }

    public boolean isSupported(Locator locator) throws TransportFailure {
        if (locator instanceof RMILocator) {
            return true;
        }
        String string = locator.getAddress();
        if (string == null) {
            return false;
        }
        try {
            String[] stringArray = URIUtility.parseAsURI(string);
            if (stringArray[0] != null && stringArray[0].toLowerCase().equals(RMI)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Locator newLocalLocator() throws TransportFailure {
        String string = new VMID().toString();
        return new RMILocator(IPUtility.getLocalHost(), this.port, string);
    }

    public Locator newLocalLocator(String string) throws TransportFailure {
        String string2 = new VMID().toString();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new RMILocator(IPUtility.getLocalHost(), n, string2);
    }

    public Locator newLocalLocator(JasBean jasBean) throws TransportFailure {
        Locator locator = this.newLocalLocator();
        locator.setAll(jasBean);
        return locator;
    }

    public MessageSender newMessageSender() throws TransportFailure {
        return new RMIMessageSender(this);
    }

    public MessageSender newMessageSender(JasBean jasBean) throws TransportFailure {
        return this.newMessageSender();
    }

    public MessageReceiver newMessageReceiver() throws TransportFailure {
        return new RMIMessageReceiverImpl(this);
    }

    public MessageReceiver newMessageReceiver(JasBean jasBean) throws TransportFailure {
        return this.newMessageReceiver();
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, TransportFailure {
        this.getMessageSender().sendMessage(transportMessage);
    }

    public void sendMessage(TransportMessage transportMessage, Locator locator) throws NotLocatableException, TransportFailure {
        throw new TransportFailure("Unsupported Operation.");
    }

    private MessageSender getMessageSender() throws TransportFailure {
        if (this.prototypeSender == null) {
            this.prototypeSender = this.newMessageSender();
        }
        return this.prototypeSender;
    }

    private MessageReceiver getMessageReceiver() throws TransportFailure {
        if (this.prototypeReceiver == null) {
            this.prototypeReceiver = this.newMessageReceiver();
        }
        return this.prototypeReceiver;
    }
}

