/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.rmi;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotBoundException;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.service.transport.rmi.RMIMessageReceiver;
import org.jagent.service.util.RMIUtility;

public class RMIMessageSender
implements MessageSender,
Serializable {
    private MessageTransportService service;
    private boolean isBound;
    private Remote remote;

    public RMIMessageSender(MessageTransportService messageTransportService) {
        this.service = messageTransportService;
        this.isBound = false;
    }

    public MessageTransportService getMessageTransportService() throws TransportFailure {
        return this.service;
    }

    public void bindToRemoteLocator(Locator locator) throws NotLocatableException, TransportFailure {
        this.remote = RMIUtility.getRemote(locator);
        this.isBound = true;
    }

    public Locator getRemoteLocator() throws NotBoundException, TransportFailure {
        if (!this.isBound) {
            throw new NotBoundException();
        }
        try {
            Locator locator = ((RMIMessageReceiver)this.remote).getLocator();
            return locator;
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access remote end-point.", remoteException);
        }
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, TransportFailure {
        try {
            Locator locator = transportMessage.getReceiver();
            this.bindToRemoteLocator(locator);
            ((RMIMessageReceiver)this.remote).acceptMessage(transportMessage);
        }
        catch (RemoteException remoteException) {
            throw new TransportFailure("Cannot access remote end-point.", remoteException);
        }
    }
}

