/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.rmi;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.transport.MessageListener;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.service.transport.rmi.RMIMessageReceiver;
import org.jagent.service.util.RMIUtility;
import org.jagent.util.MessageQueue;

public class RMIMessageReceiverImpl
extends RemoteObject
implements RMIMessageReceiver,
MessageReceiver,
Serializable {
    private MessageTransportService ts;
    private Locator locator;
    private Set callbackSet;
    private Map pollingMap;
    private MessageQueue msgQueue;
    private Registry registry;
    private String bindKey;

    public RMIMessageReceiverImpl(MessageTransportService messageTransportService) {
        this.ts = messageTransportService;
        this.callbackSet = new HashSet();
        this.pollingMap = new HashMap();
        this.msgQueue = new MessageQueue();
    }

    public void shutdown() {
        try {
            this.registry.unbind(this.bindKey);
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void bindToLocalLocator(Locator locator) throws NotLocatableException, TransportFailure {
        this.registry = RMIUtility.getRegistry(locator);
        try {
            UnicastRemoteObject.exportObject(this);
            this.bindKey = locator.getAddress();
            this.registry.bind(this.bindKey, this);
            this.locator = locator;
        }
        catch (RemoteException remoteException) {
            try {
                this.registry.unbind(this.bindKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TransportFailure("Cannot export MessageReceiver.", remoteException);
        }
        catch (Exception exception) {
            try {
                this.registry.unbind(this.bindKey);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new TransportFailure("Cannot bind to Registry.", exception);
        }
    }

    public Locator getLocalLocator() throws TransportFailure {
        if (this.locator != null) {
            return this.locator;
        }
        return this.ts.newLocalLocator();
    }

    public MessageTransportService getMessageTransportService() throws TransportFailure {
        return this.ts;
    }

    public Locator getLocator() throws RemoteException {
        return this.locator;
    }

    public void acceptMessage(TransportMessage transportMessage) throws RemoteException {
        Iterator iterator = this.callbackSet.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                ((MessageListener)iterator.next()).receiveMessage(transportMessage);
            }
        } else {
            this.msgQueue.enqueue(transportMessage);
        }
    }

    public int getNumberOfMessages() throws TransportFailure {
        return this.msgQueue.length();
    }

    public TransportMessage getMessage() throws InterruptedException, TransportFailure {
        return (TransportMessage)this.msgQueue.dequeue();
    }

    public TransportMessage getMessage(long l) throws InterruptedException, TransportFailure {
        return (TransportMessage)this.msgQueue.dequeue(l);
    }

    public void addMessageListener(MessageListener messageListener) throws TransportFailure {
        this.callbackSet.add(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) throws TransportFailure {
        this.callbackSet.remove(messageListener);
    }
}

