/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.http;

import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NoSuchTransportException;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import javax.agent.service.transport.TransportSystem;
import org.jagent.service.transport.BasicTransportSystem;

public class HttpTransportSystem
implements TransportSystem {
    private BasicTransportSystem delegate;
    private static final String HTTP = "javax.agent.service.http";
    private static final String TS_FACTORY = "org.jagent.service.transport.http.HttpMessageTransportServiceFactory";

    public HttpTransportSystem() throws Exception {
        this.initialize(null);
    }

    public HttpTransportSystem(ServiceProperties serviceProperties) throws Exception {
        this.initialize(serviceProperties);
    }

    private void initialize(ServiceProperties serviceProperties) throws Exception {
        this.delegate = new BasicTransportSystem();
        if (serviceProperties != null) {
            serviceProperties.set("transport-factory-class", TS_FACTORY);
            if (serviceProperties.containsKey("javax.agent.service.http.service-port")) {
                Object object = serviceProperties.get("javax.agent.service.http.service-port");
                serviceProperties.set("javax.agent.service.http.service-port", object);
            }
            if (!this.loadTransportService(HTTP, serviceProperties)) {
                throw new Exception("Cannot start transport service.");
            }
        }
    }

    public String getBindingName() {
        return "message-transport-system";
    }

    public boolean loadTransportService(String string, ServiceProperties serviceProperties) {
        try {
            this.delegate.loadTransportService(string, serviceProperties);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean unloadTransportService(String string) {
        MessageTransportService messageTransportService = this.delegate.unloadTransportService(string);
        return messageTransportService != null;
    }

    public ServiceProperties getServiceProperties() {
        return null;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }

    public MessageTransportService[] getMessageTransportServices() throws TransportFailure {
        return this.delegate.getMessageTransportServices();
    }

    public MessageTransportService getMessageTransportService(Locator locator) throws NotLocatableException, TransportFailure {
        return this.delegate.getMessageTransportService(locator);
    }

    public MessageTransportService getMessageTransportService(JasBean jasBean) throws NotLocatableException, TransportFailure {
        return this.delegate.getMessageTransportService(jasBean);
    }

    public MessageSender newMessageSender(JasBean jasBean) throws NotLocatableException, TransportFailure {
        return this.delegate.newMessageSender(jasBean);
    }

    public MessageReceiver newMessageReceiver(JasBean jasBean) throws NotLocatableException, TransportFailure {
        return this.delegate.newMessageReceiver(jasBean);
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, NoSuchTransportException, TransportFailure {
        this.delegate.sendMessage(transportMessage);
    }

    public void sendMessage(TransportMessage transportMessage, Locator locator) throws NotLocatableException, NoSuchTransportException, TransportFailure {
        this.delegate.sendMessage(transportMessage, locator);
    }
}

