/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.http;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.agent.TransportMessage;
import javax.agent.service.transport.MessageListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jagent.service.transport.http.HttpMessageReceiver;
import org.jagent.service.transport.http.QueueManager;

public class HttpRouterServlet
extends HttpServlet {
    static QueueManager qman = new QueueManager();
    private static String myurl = null;
    private static String mypath = null;
    private static ServletContext context;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        context = servletConfig.getServletContext();
        myurl = servletConfig.getInitParameter("RouterURL");
        if (myurl == null) {
            System.err.println("Specify the router's address!");
        }
        if (!myurl.endsWith("/")) {
            myurl = myurl + "/";
        }
        try {
            mypath = new URL(myurl).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException.getMessage());
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("This is a router servlet used in the http transport implementation.");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Object deserialize(byte[] byArray) throws ClassNotFoundException, StreamCorruptedException, OptionalDataException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            int n = httpServletRequest.getContentLength();
            byte[] byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            dataInputStream.readFully(byArray);
            TransportMessage transportMessage = (TransportMessage)HttpRouterServlet.deserialize(byArray);
            String string = transportMessage.getReceiver().getAddress();
            String string2 = new URL(string).getPath();
            String string3 = string2.substring(mypath.length());
            HttpMessageReceiver httpMessageReceiver = (HttpMessageReceiver)HttpMessageReceiver.receivers.get(string3);
            if (httpMessageReceiver != null) {
                if (httpMessageReceiver.listenersOn) {
                    Enumeration enumeration = httpMessageReceiver.listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        MessageListener messageListener = (MessageListener)enumeration.nextElement();
                        messageListener.receiveMessage(transportMessage);
                    }
                } else {
                    qman.get(string3).enqueue(transportMessage);
                }
            }
            httpServletResponse.getOutputStream().close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void sendMessage(TransportMessage transportMessage) {
        URL uRL = null;
        URLConnection uRLConnection = null;
        try {
            uRL = new URL(transportMessage.getReceiver().getAddress());
            uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
            objectOutputStream.writeObject(transportMessage);
            uRLConnection.getInputStream().close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String getRouterAddress() {
        return myurl;
    }
}

