/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.http;

import java.net.MalformedURLException;
import java.net.URL;
import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.acr.AcrTransportMessage;
import org.jagent.service.transport.http.HttpLocator;
import org.jagent.service.transport.http.HttpMessageReceiver;
import org.jagent.service.transport.http.HttpMessageSender;
import org.jagent.service.transport.http.HttpRouterServlet;

public class HttpMessageTransportService
implements MessageTransportService {
    public static final String ADDRESS = "org.jagent.service.transport.http.address";
    private MessageSender prototypeSender = this.newMessageSender();
    private MessageReceiver prototypeReceiver = this.newMessageReceiver();
    private static int counter = 0;

    public HttpMessageTransportService() throws TransportFailure {
    }

    public HttpMessageTransportService(ServiceProperties serviceProperties) throws TransportFailure {
        this();
    }

    public ServiceProperties getServiceProperties() throws TransportFailure {
        return null;
    }

    public TransportMessage createTransportMessage() {
        return new AcrTransportMessage();
    }

    public boolean isSupported(Locator locator) throws TransportFailure {
        String string = locator.getAddress();
        System.out.println("address: " + string);
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            return string2.equals("http");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private static synchronized String getUniqueString() {
        return "loc" + System.currentTimeMillis() + counter++;
    }

    public Locator newLocalLocator() throws TransportFailure {
        HttpLocator httpLocator = new HttpLocator();
        httpLocator.setAddress(HttpRouterServlet.getRouterAddress() + HttpMessageTransportService.getUniqueString());
        return httpLocator;
    }

    public Locator newLocalLocator(String string) throws TransportFailure {
        HttpLocator httpLocator = new HttpLocator();
        httpLocator.setAddress(HttpRouterServlet.getRouterAddress() + HttpMessageTransportService.getUniqueString());
        return httpLocator;
    }

    public Locator newLocalLocator(JasBean jasBean) throws TransportFailure {
        HttpLocator httpLocator = new HttpLocator();
        httpLocator.setAddress((String)jasBean.get(ADDRESS));
        return httpLocator;
    }

    public MessageSender newMessageSender() throws TransportFailure {
        HttpMessageSender httpMessageSender = new HttpMessageSender();
        httpMessageSender.service = this;
        return httpMessageSender;
    }

    public MessageSender newMessageSender(JasBean jasBean) throws TransportFailure {
        HttpMessageSender httpMessageSender = new HttpMessageSender();
        httpMessageSender.service = this;
        return httpMessageSender;
    }

    public MessageReceiver newMessageReceiver() throws TransportFailure {
        HttpMessageReceiver httpMessageReceiver = new HttpMessageReceiver();
        httpMessageReceiver.service = this;
        return httpMessageReceiver;
    }

    public MessageReceiver newMessageReceiver(JasBean jasBean) throws TransportFailure {
        HttpMessageReceiver httpMessageReceiver = new HttpMessageReceiver();
        httpMessageReceiver.service = this;
        return httpMessageReceiver;
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, TransportFailure {
        HttpRouterServlet.sendMessage(transportMessage);
    }

    public void sendMessage(TransportMessage transportMessage, Locator locator) throws NotLocatableException, TransportFailure {
        transportMessage.setReceiver(locator);
        HttpRouterServlet.sendMessage(transportMessage);
    }
}

