/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.transport.MessageListener;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.service.transport.http.HttpRouterServlet;
import org.jagent.service.transport.http.QueueManager;
import org.jagent.util.MessageQueue;

public class HttpMessageReceiver
implements MessageReceiver {
    static QueueManager qman = HttpRouterServlet.qman;
    private MessageQueue queue = null;
    MessageTransportService service = null;
    private Locator locator = null;
    private String localAddress = null;
    static Hashtable receivers = new Hashtable();
    Vector listeners = null;
    boolean listenersOn = false;

    public MessageTransportService getMessageTransportService() throws TransportFailure {
        return this.service;
    }

    private String locator2localAddress(Locator locator) {
        String string = locator.getAddress();
        String string2 = null;
        try {
            string2 = new URL(string).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
        String string3 = string2.substring(string2.lastIndexOf("/") + 1);
        return string3;
    }

    public void bindToLocalLocator(Locator locator) throws NotLocatableException, TransportFailure {
        this.localAddress = this.locator2localAddress(locator);
        try {
            this.queue = qman.register(this.localAddress);
        }
        catch (IllegalStateException illegalStateException) {
            throw new NotLocatableException(locator.getAddress());
        }
        receivers.put(this.localAddress, this);
        this.locator = locator;
    }

    public Locator getLocalLocator() throws TransportFailure {
        return this.locator;
    }

    public void addMessageListener(MessageListener messageListener) throws TransportFailure {
        try {
            this.listeners.addElement(messageListener);
        }
        catch (NullPointerException nullPointerException) {
            this.listeners = new Vector();
            this.listeners.addElement(messageListener);
        }
        this.listenersOn = true;
    }

    public void removeMessageListener(MessageListener messageListener) throws TransportFailure {
        if (this.listeners != null) {
            this.listeners.removeElement(messageListener);
            if (this.listeners.size() == 0) {
                this.listenersOn = false;
            }
        }
    }

    public int getNumberOfMessages() throws TransportFailure {
        return this.queue.length();
    }

    public TransportMessage getMessage() throws InterruptedException, TransportFailure {
        return (TransportMessage)this.queue.dequeue();
    }

    public TransportMessage getMessage(long l) throws InterruptedException, TransportFailure {
        return (TransportMessage)this.queue.dequeue(l);
    }

    protected void finalize() throws Throwable {
        receivers.remove(this.localAddress);
        qman.deregister(this.queue);
    }
}

